
/*
 * Sample code. These routines simply display the data received from
 * VersaTrack in a text window. They can be adapted to
 * actually use the data for controlling an external device.
 */
 
#include "radextrn.h"
#undef  CV
#define CV                 2.998e5		/* speed of light constant Km/s */

extern radparam_t rigInfo;
extern HWND rdhwnd;

/*
 * These rotines will be called each time a valid message is received
 */
 
void
r_control(char *satname , double elevation,
          double dist, double velo, double fopl)
{
    extern void rdisp_update(void);
    double dp;

    if (rigInfo.radio.ra_rxcenter <= 0)
    	rigInfo.radio.ra_rxcenter = 145000; /* Unit is KHZ */
    	
	dp = (-1 * velo) / 2.997e5;  /* approx. coefficient */
    rigInfo.radio.ra_doppler = (int) (dp * rigInfo.radio.ra_rxcenter * 1000);

    if (rdhwnd)
        rdisp_update();

#ifdef _DEBUG_
    diag("%s: El %.1lf Range %.1lf Spd %3.4lf Doppler coef %+.4e loss %.1lf\n",
        satname, elevation, dist, velo, dp, fopl);
#endif /* _DEBUG_ */
	/*
	 * Use the data to either send appropriate command to device, or
	 * accumulate, compute mean, average or median (if rate is too high)
     * before issuing cmds to device.
	 */
}
    
void
r_interrupt(char *satname, char *reason)
{
#ifdef _DEBUG_
    sprintf(tmpbuf,"+++ interrupt: '%s'\n", reason);
    diag(tmpbuf);
#endif /* _DEBUG_ */
	/*
	 * Notify user. suspend device control.
	 */
}

void
r_init(char *satname, char *sitename, char *mode, int update)
{
#ifdef _DEBUG_
    sprintf(tmpbuf,"+++ Initialize: '%s' from '%s' Mode %s Update %d sec.\n",
        satname, sitename, mode, update);
    diag(tmpbuf);
#endif /* _DEBUG_ */
	/*
	 * Proceed to determine server parameters, if a satellite/transponder/mode
	 * database is used, determine correct uplink/downlink. Issue cmds
	 * to radio to set frequency/mode.
	 * For a rotator, determine min/max limits of travel, stepping rate
	 * and skews for intertia compensation, start/stop latancies, etc.
	 * Some of these operations may need to be delayed until several
	 * movement samples have been accumulated.
	 */
}

void
r_end(HWND wid)
{
#ifdef _DEBUG_
    diag("End Connection: Window ID = %x\n", wid);
#endif /* _DEBUG_ */
	/*
	 * Proceed to restore device status for device that is being controlled.
	 * For a rotator, it may be necessary to park both in AZ and EL.
	 * Notify user.
	 */
}

void
r_begin(HWND wid)
{
#ifdef _DEBUG_
    diag("Begin Connection: Window ID = %x\n", wid);
#endif /* _DEBUG_ */
	/*
	 * Proceed to open the COM port to the device being controlled, etc.
	 * Get device status and initialize data structures and state information.
	 */
}

void
r_special(int code)
{
#ifdef _DEBUG_
    sprintf(tmpbuf,"+++ received special cmd (%d)\n", code);
    diag(tmpbuf);
    /* NOT CURRENTLY USED */
#endif /* _DEBUG_ */
}
