# %W% %E% %U%
# MICROSOFT WIN32 SDK - Makefile for VersaTrack's Radio Control Server 
# S.N. Oct 10, 1994

DEBUG = 1
MAINDIR = ..
TARGETSRV  = $(MAINDIR)\radserv.exe

MAKE = nmake
LIBEXE = lib
LINKEXE = link
CC = cl
CPP = cl
RC = rc

CFLAGS_D_WEXE    = -nologo -W3 -D_X86_ -D_DEBUG_ -D_WINDOWS -DWIN32
CFLAGS_R_WEXE    = -nologo -W3 -D_X86_ -DNDEBUG -D_WINDOWS -DWIN32
LFLAGS_D_WEXE    = -nologo -defaultlib:user32,gdi32,advapi32
LFLAGS_R_WEXE    = -nologo -defaultlib:user32,gdi32,advapi32
SRVLFLAGS_D_WEXE = -nologo -map -debug -debugtype:cv -subsystem:windows
SRVLFLAGS_R_WEXE = -nologo -map -subsystem:windows user32.lib gdi32.lib
SRVLIBS          = user32.lib gdi32.lib advapi32.lib
MAKEFLAGS        = L E
RCFLAGS          = -D_WINDOWS -DWIN32
D_RCDEFINES      = -D_DEBUG -D_DEBUG_
R_RCDEFINES      = -DNDEBUG
CC_D_OPTIM       =
CC_R_OPTIM       = -Ox


SRVOBJS = \
    radsrv.obj \
    radmsg.obj \
    util.obj \
    sysreg.obj \
    ttysetup.obj \
    radsetup.obj \
    raddisp.obj \
    tty.obj

!if "$(DEBUG)" == "1"

CFLAGS         = $(CFLAGS_D_WEXE) $(CC_D_OPTIM) -I.. -I.
LFLAGS         = $(LFLAGS_D_WEXE)
SRVLFLAGS      = $(SRVLFLAGS_D_WEXE)
RCDEFINES      = $(RCFLAGS) $(D_RCDEFINES)
ALLDLLOBJS     = $(DLLOBJS) $(MAINDIR)\prf.obj
ALLSRVOBJS     = $(SRVOBJS) $(MAINDIR)\prf.obj
!else

CFLAGS         = $(CFLAGS_R_WEXE) $(CC_R_OPTIM) -I.. -I.
LFLAGS         = $(LFLAGS_R_WEXE)
SRVLFLAGS      = $(SRVLFLAGS_R_WEXE)
RCDEFINES      = $(RCFLAGS) $(R_RCDEFINES)
ALLDLLOBJS     = $(DLLOBJS)
ALLSRVOBJS     = $(SRVOBJS)

!endif

SRVDEPS    =  \
    radextrn.h \
    resource.h
    
all:	$(TARGETSRV)

$(SRVOBJS):  $(SRVDEPS)

radio.res:    radio.rc resource.h

.rc.res:
    $(RC) $(RCDEFINES) -r $*.rc


$(TARGETSRV):	radio.res $(ALLSRVOBJS)
    echo >NUL @<<radio.inp
$(ALLSRVOBJS)
radio.res
-out:$(TARGETSRV)

$(SRVLIBS)
$(SRVLIBS_EXT)
$(DEFFILE_OPTION)
<<
    link $(SRVLFLAGS) @radio.inp


tty.exe:    tty.c
    $(CC) $(CFLAGS) -O1 -Os tty.c -link -defaultlib:user32,gdi32,advapi32
        
$(MAINDIR)\prf.obj:
    @cd ..
    @$(MAKE) "DEBUG=$(DEBUG)" "INSTALLDIR=$(INSTALLDIR)" prf.obj
    @cd rad
 
.c.obj:
	$(CC) $(CFLAGS) -c $*.c

clean:
    -@del *.obj *.lib *.aps *.sbr *.map *.res *.pch >NUL 2>NUL

clobber:    clean
    -@del $(TARGETSRV) >NUL 2>NUL

backup:
    -@radbkup A:

zip:
    -@mkradzip
