#ifndef _RADEXTRNS_H
#define _RADEXTRNS_H

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>

#define RADVERSION  0

#define CWHITE  15
#define CBLACK  0

#define BUFLEN      160
#define CMD_PAUSE   0x0001
#define CMD_RESUME  0x0002

#ifndef MIN
#define MIN(x,y)    (((x) < (y)) ? (x) : (y))
#endif

#define VST_LOCK()      EnterCriticalSection(&VstLock)
#define VST_UNLOCK()    LeaveCriticalSection(&VstLock)

/*
 * Interprocess Messages:
 * DO NOT CHANGE MESSAGE NUMBER(S)
 */
#define VST_PROBE_AYT     (WM_USER   + 27)        /* VST Are You There?       */

/*
 * Local Messages
 */
#define CNTRL_CLIENTEXIT    (WM_USER   +  8)        /* Local terminate msg.  */
#define SERVER_CLIENTINIT   (WM_USER   +  9)        /* Client connected      */
/*
 * Timer IDs: (must fit in 16 bits)
 */
#define IDT_HEARTBEAT   31700

/*
 *Serial port handshaking parameters
 */
#define TTY_RTSCTS  0x1     /* RTS/CTS Handshake */
#define TTY_DSRDTR  0x2     /* DSR/DTR Handshake */
#define TTY_XONXOFF 0x4     /* XON-XOFF Handshake by COM port driver */

typedef struct tag_ttystruct {
    HANDLE      ad_ttyh;
    HANDLE      ad_WrEvent;
    HANDLE      ad_RdEvent;
    OVERLAPPED  ad_WrOverlap;
    OVERLAPPED  ad_RdOverlap;
} ttyadj_t;

#define tt_ttyh         tt_adj->ad_ttyh
#define tt_WrEvent      tt_adj->ad_WrEvent
#define tt_RdEvent      tt_adj->ad_RdEvent
#define tt_WrOverlap    tt_adj->ad_WrOverlap
#define tt_RdOverlap    tt_adj->ad_RdOverlap

typedef struct tag_ttyinfo {
    int         tt_portno;
    int         tt_baudrate;
    char        tt_databits;
    char        tt_parity;
    char        tt_stopbits;
    int         tt_flags;
    int         tt_icdelay;
    char        tt_optparams[32];
    ttyadj_t   *tt_adj;
} tty_t;


typedef struct tag_radioinfo {
    int         ra_rxcenter;
    int         ra_txcenter;
    int         ra_doppler;
    int         ra_flags;
    char        ra_rxbfo[4];
    char        ra_txbfo[4];
    int         ra_RFU[8];
    /* etc. etc. */
} radioinfo_t;

typedef struct tag_radparam {
    tty_t       tty;
    radioinfo_t radio;
} radparam_t;


typedef struct tag_button {
    int         fval;
    int         bval;
    int         oldf;
} button_t;

extern void fatal (char *);
extern BOOL yesno (char *);
extern void usermsg (char *);
extern POINT *DialogPos (HWND, HWND);
extern void UpperCase(char *);
extern char *saveString(char *);
extern int  cistrcmp(char *, char *);
extern void stripTrailingSpace(char *);
extern char *stripLeadingSpace(char *);
extern char *getline(char *, int, FILE *);
extern char *GetEditText(HWND, int, char *, int);
extern void PortParams(void);
extern void RadioParams(void);
extern BOOL VstIsAlive(void);
extern BOOL ServerCreate(void);

#ifdef _DEBUG_
extern void (*diag)(va_list, ...);
extern void DebugFunc(va_list, ...);
extern void ConsClose(void);
extern void _vst_assert_(BOOL, char *, char *,  int);
#else  /* _DEBUG_ */
extern void (*diag)(va_list, ...);
#endif /* _DEBUG_ */

extern void setbuttons(HWND, int, button_t *);

extern HWND  Gwnd;
extern HWND  vsthwnd;
extern DWORD vstth;
extern DWORD vstpid;
extern int   srv_state;
extern HANDLE   ServerThread;
extern CRITICAL_SECTION  VstLock;
extern char tmpbuf[], textbuf[], VersionStr[];
extern COLORREF BColors[];
extern HBRUSH hBDrawBrush[];
extern char textbuf[BUFLEN], tmpbuf[BUFLEN], textbuf[BUFLEN];
extern radparam_t rigInfo;
extern ttyadj_t   ttyadj;

#endif /* _RADEXTRNS_H */
