//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __TNCMGR_H
#define  __TNCMGR_H

#ifndef  __CALLUP_H
#include "callup.h"
#endif

#ifndef  __OBJECT_H
#include "object.h"
#endif

class Config;
class HwDevice;
class Kiss;
class Slip;
class Terminal;
class Timer;
class Window;

class TncMgr : public Object
{
public:
         enum         { KissMode, TermMode };
         unsigned       tncMode;

                        TncMgr(       Terminal*     term,
                                      Kiss*         kiss,
                                      Slip*         slip,
                                      HwDevice*     dev,
                                const Config&       cfg,
                                      Window&       win );
                        ~TncMgr();
         void           flush();
         void           initialize();
         void           kissToTerm();
         unsigned       mode() { return tncMode; }
         void           sendFullDupCmd();
         void           terminate();
         void           termToKiss();

private:
   enum               { LINESIZE = 80 };
   const Config&        cfg;
         HwDevice*      dev;
         Timer*         fullDupTimer;
         Kiss*          kiss;
   const unsigned       responseDelay;
         Slip*          slip;
         Terminal*      term;
         Window&        win;

         void           commandsFromFile( const char* fileName );
         void           setKissParams();

};

class FullDupCallUp : public CallUp
{
public:
                         FullDupCallUp( Object& obj );
         void            func() const;
};

#endif   __TNCMGR_H
