//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __TNCMGR_H
#include "tncmgr.h"
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __HWDEVICE_H
#include "hwdevice.h"
#endif

#ifndef  __KISS_H
#include "kiss.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __SLIP_H
#include "slip.h"
#endif

#ifndef  __TERMINAL_H
#include "terminal.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

TncMgr::TncMgr(       Terminal*  term,
                      Kiss*      kiss,
                      Slip*      slip,
                      HwDevice*  dev,
                const Config&    cfg,
                      Window&    win )
           :
                cfg( cfg ),
                dev( dev ),
                fullDupTimer( 0 ),
                kiss( kiss ),
                responseDelay( 110 ),
                slip( slip ),
                term( term ),
                tncMode( TermMode ),
                win( win )
//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
{}

TncMgr::~TncMgr()
//--------------------------------------------------------------------------
// Destructor
//--------------------------------------------------------------------------
{
   if (fullDupTimer)
      delete fullDupTimer;
}

void TncMgr::commandsFromFile( const char* fileName )
//--------------------------------------------------------------------------
// Send commands from command file to TNC
//--------------------------------------------------------------------------
{
   FILE* file;
   if ((file = fopen( fileName, "r")) != 0)      // if file exists
   {
      while (!feof( file ))
      {
         term->recvIn( *(new MBuf( "\r\n", 2 )) );
         MBuf* record = new MBuf( LINESIZE );
         if (!record)
            win.printFatal( "Out of memory" );
         if (fgets( record->data, LINESIZE - 1, file ) == 0 ||
             record->data[0] == '\n')
            break;
         if (*record->data != ';')               // ignore comments
         {
            int i = strlen( record->data );      // add CR
            if (record->data[ i-1 ] == '\n')
               record->data[ i-1 ] = '\r';
            else
            {
               record->data[ i ] = '\r';
               i++;
               record->data[ i ] = 0;
            }
            record->cnt = strlen( record->data );
//          MBuf* recCopy = new MBuf( *record );
//          if (!recCopy)
//             win.printFatal( "Out of memory" );
            term->send( *record );               // send records to TNC
//          term->recvIn( *recCopy );            // make our own echo
//          term->recvIn( *(new MBuf( "\n", 1 )) );
            delay( cfg.commandDelay );           // wait for the TNC to reply
            dev->poll();                         // get the reply
         }
      }
      fclose( file );
   }
}

void TncMgr::initialize()
//--------------------------------------------------------------------------
// TNC initialization process
//--------------------------------------------------------------------------
{
   if (cfg.kissTnc)                              // if TNC with KISS eprom
   {
      setKissParams();
      tncMode = KissMode;                        // set mode state variable
   }
   else
   {
      MBuf* buf = new MBuf( "\r", 1 );
      term->send( *buf );                        // in case TNC is in terminal
      delay( cfg.commandDelay );                 //  mode
      kissToTerm();                              // put TNC in terminal mode
      commandsFromFile( cfg.tncInitFile );       // send initialization commands
      if (cfg.tncStartMode != TermMode)          // put TNC in startup mode
        termToKiss();
   }
   if (cfg.fullDupCmdInterval)
   {
      static FullDupCallUp fullDupCallUp( *this );
      fullDupTimer = new Timer( "FullDup", fullDupCallUp, cfg.fullDupCmdInterval );
      fullDupTimer->start();
   }
}

void TncMgr::sendFullDupCmd()
//--------------------------------------------------------------------------
// Send full duplex KISS command to TNC.  This is a static function called
// by the "fullDup" timer.  It must be passed a pointer to the object.
//--------------------------------------------------------------------------
{
   if (tncMode == KissMode)
   {
      kiss->send( Kiss::FULLDUP, 1 );
      delay( cfg.commandDelay );
   }
   fullDupTimer->start();
}

void TncMgr::setKissParams()
//--------------------------------------------------------------------------
// Initialize TNC in KISS mode
//--------------------------------------------------------------------------
{
   delay( cfg.commandDelay );
   if (cfg.txd)
      kiss->send( Kiss::TXDELAY, cfg.txd );
   delay( cfg.commandDelay );
   if (cfg.persistence)
      kiss->send( Kiss::PERSIST, cfg.persistence );
   delay( cfg.commandDelay );
   if (cfg.slotTime)
      kiss->send( Kiss::SLOTTIME, cfg.slotTime );
   delay( cfg.commandDelay );
   kiss->send( Kiss::FULLDUP, cfg.fullDuplex );
   delay( cfg.commandDelay );
}

void TncMgr::terminate()
//--------------------------------------------------------------------------
// TNC termination process
//--------------------------------------------------------------------------
{
   if (tncMode == KissMode && !cfg.kissTnc)
      kissToTerm();                              // put TNC in terminal mode
   if (!cfg.kissTnc)                             // if not TNC with KISS eprom
      commandsFromFile( cfg.tncTermFile );       // send termination commands
}

void TncMgr::termToKiss()
// ------------------------------------------------------------------------
// Put TNC in kiss mode
// ------------------------------------------------------------------------
{
   term->flush( 'I' );                           // flush input buffer
   MBuf* bp = new MBuf( "KISS ON\r", 8 );
   term->send( *bp );                            // send KISS command
   delay( cfg.aeaDelay );
   bp = new MBuf( "RESTART\r", 8 );
   term->send( *bp );                            // send RESTART command
   delay( cfg.restartDelay );                    // give TNC some time
   setKissParams();                              // initialize TNC
   win.print( "KISS      was OFF\r\nKISS      now ON" );
   tncMode = KissMode;                           // set mode state variable
   dev->link( *slip );                           // set device to SLIP
   term->flush( 'I' );                           // flush input buffer
}

void TncMgr::kissToTerm()
// --------------------------------------------------------------------------
// Change TNC from KISS mode to terminal mode.
// --------------------------------------------------------------------------
{
   term->flush( 'I' );                           // flush input buffer

   // This is done for switching in the simulation mode

   kiss->send( Kiss::OFF, 0 );                   // send KISS OFF command
   delay( cfg.breakDelay );                          // give TNC some time
   MBuf* bp = new MBuf( "\x11", 1 );
   term->send( *bp );                            // send ^Q
   delay( cfg.commandDelay );
   bp = new MBuf( "\r\x03\x03\x03\r", 5 );
   dev->link( *term );                           // set device to terminal
   term->send( *bp );                            // send CR-^C-^C-^C-CR
   delay( cfg.commandDelay );
   bp = new MBuf( "KISS OFF\r", 9 );
   term->send( *bp );                            // send "KISS OFF" in acsii
   delay( cfg.commandDelay );
   tncMode = TermMode;                           // set mode state variable
   term->flush( 'I' );                           // flush input buffer
   bp = new MBuf( "\r\n", 2 );
   term->recvIn( *bp );                          // clear the input line
   bp = new MBuf( "\r", 1 );
   term->send( *bp );                            // get cmd: response from TNC
//   win.print( "\n" );
}

FullDupCallUp::FullDupCallUp( Object& obj ) : CallUp( obj )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void FullDupCallUp::func() const
// -------------------------------------------------------------------------
// Full duplex command timer call up function
// -------------------------------------------------------------------------
{
   ((TncMgr&) obj).sendFullDupCmd();
}

