//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __TIMER_H
#define  __TIMER_H

#ifndef  __OBJECT_H
#include "object.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

typedef void interrupt (*CastIsr) (...);

class CallUp;

class Timer
{
public:
    enum TimerState   { Started, Stopped, Expired };

   static unsigned      showTimerActivity;       // show timer messages
   static unsigned      showLoopSpeed;           // show freq of cycle() calls
   static Window*       win;                     // window output object

                        Timer( const char* );
                        Timer( const char*         name,
                                     CallUp&       cu,
                               const unsigned long ms );
   virtual              ~Timer();
          unsigned long getDuration() const { return duration; }
   static void          cycle();
          int           getState() { return state; }
          unsigned long msLeft() const;
   static unsigned long msTime();
   static unsigned long dosTime();
   static void          removeISR();
          void          set( CallUp& tcu, const unsigned long ms );
          void          set( const unsigned long ms ) { duration = ms; }
          void          start();
          void          start( const unsigned long ms );
          void          stop();

private:
   static int           INT1C;                   // DOS tick timer vector
   static float         CLKTCK;                  // clock ticks per second

   static Window        defaultWin;              // default window
          unsigned long duration;
   static unsigned long elapsedSecs;             // elapsed time in seconds
   static unsigned long elapsedTicks;            // elapsed time in ticks
   const  char*         name;
          Timer*        next;
   static CastIsr       oldTickISR;              // pointer to tick timer ISR
   static unsigned long startSecs;               // start time in seconds
          TimerState    state;
          unsigned long stopTimeMs;
          CallUp*       cu;
   static unsigned      timerCount;              // count of Timers
   static Timer*        timerChainHead;          // head of Timer chain

   static void          installISR();
   static void interrupt newTickISR( ... );
};

#endif   __TIMER_H
