//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __SATLINK_H
#define  __SATLINK_H

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CALLUP_H
#include "callup.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __OBJECT_H
#include "object.h"
#endif

#ifndef  __ROTOR_H
#include "rotor.h"
#endif

class ActList;
class AsyncIntf;
class Ax25;
class BeaconMgr;
class CmdLine;
class Config;
class CountsList;
class DirBcstMgr;
class DirDlMgr;
class Directory;
class DirFileMgr;
class DirFrameMgr;
class EventQueue;
class FileBcstMgr;
class FTL0;
class FTL0User;
class FileFrameMgr;
class Help;
class HighTime;
class HwDevice;
class Kiss;
class LinkTable;
class NoL3FrameMgr;
class QueueFrameMgr;
class Rotor;
class SemanticsAnalyzer;
class Slip;
class StatusLine;
class StatusList;
class SyntaxAnalyzer;
class Terminal;
class Timer;
class TncMgr;
class UserMgr;
class Window;

class SatLink : public Object
{
public:
          enum         { EXITAFTERTIMER = 1,
                         ABORTTIMER,
                         IDLETIMER,
                         USEREXIT,
                         EXITONSATERROR };

          FTL0User*      ftl0User;               // FTL0 protocol user
          Config         cfg;                    // configuration parameters
          HwDevice*      dev;                    // input hardware device
          Timer*         exitAfterTimer;
          StatusLine*    sLine;                  // screen status line
          Slip*          slip;                   // SLIP protocol object ptr
          UserMgr*       userMgr;

                         SatLink();
                         ~SatLink();
   static void           ctrlc_handler( int );
          void           exitProgram( const int exitCode );
          void           initialize();
          void           run( int argc, char **argv );
          void           showDlRate();
			 void           terminate();

private:
          ActList*       actList;                // activity file list
          AsyncIntf*     ai;                     // async interface
          Ax25*&         axpr;                   // Ax.25 pointer reference
          Rotor          antennaControl;         // OrbitDRV interface
          char           bbsAddr[ Ax25::AXALEN ];
          char           bcstAddr[ Ax25::AXALEN ];
          BeaconMgr*     bm;                     // handles UI beacons
          CmdLine*       cLine;
          DirBcstMgr*    dbm;                    // directory broadcast manager
          DirDlMgr*      ddm;                    // directory download manager
          DirFileMgr*    dfm;                    // directory file manager
          Timer*         dlRateTimer;            // downlink rate timer ptr
			 Directory*     dir;                    // PFH directory viewer
          FileBcstMgr*   fbm;
          Window*        fileWin;
          unsigned long  firstHeard;
          Window*        frameWin;               // screen frame window
          FTL0*          ftl0;                   // FTL0 protocol handler
          Help*          help;
          HighTime*      hTime;
          NoL3FrameMgr*  hnl3;
          Window*        infoWin;                // screen information window
          Kiss*          kiss;                   // KISS protocol object ptr
          LinkTable      linkTable;
          char           logAddr[ Ax25::AXALEN ];
          int            logCs;                  // log SLIP frame for callsign
          char           myAddr[ Ax25::AXALEN ];
          SyntaxAnalyzer* parser;                // select equation parser
   static unsigned       pgmExitFlag;
          EventQueue*    pQ;                     // pending events queue
          SemanticsAnalyzer* sem;                // eqn semantics analyzer
          StatusList*    sList;                  // download file status list
          Terminal*      terminal;               // terminal mode protocol
          TncMgr*        tncMgr;                 // TNC manager

   static void          pgmExit();
          void          print() const;

          friend class  ErrCallUp;
          friend class  DlRateCallUp;
          friend class  ExitPgmCallUp;
          friend class  UserMgr;
};

extern SatLink* satLink;

class ErrCallUp : public CallUp
{
public:
                         ErrCallUp( Object& obj );
         void            func() const;
};

class DlRateCallUp : public CallUp
{
public:
                         DlRateCallUp( Object& obj );
         void            func() const;
};

class ExitPgmCallUp : public CallUp
{
public:
                         ExitPgmCallUp( Object& obj, int exitCode );
         void            func() const;

private:
         int             exitCode;
};

#endif  __SATLINK_H
