//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __QUEUE_H
#define  __QUEUE_H

class Config;
class Window;

class Event
{
public:
   static enum         { No_Event,

                         Rqst_Term_Mode,         // program events
                         Rqst_Host_Mode,
                         Rqst_Kiss_Mode,
                         Host_Command,
                         Terminal_Command,
                         Rqst_Help,
                         Rqst_Printer_Toggle,
                         Rqst_Microsat_Chng,
                         Rqst_DOS_Gateway,
                         Rqst_Send_Break,
                         Rqst_DCD_Toggle,
                         Rqst_Dir_Rebuild,
                         Rqst_Program_Exit,
                         Rqst_Capture,
                         Rqst_Toggle_Grab,
                         Exit_Program,

                                              // datalink associated events
                         Rcv_Datalink_Frame,     // from link
                         Rqst_Term_Data_Link,    // from user
                         Request_Connect,        // from user
                         Request_Passive,
                         Request_Disconnect,     // from link
                         Rcv_Stn_Busy_Resp,      // from link
                         Rcv_Con_Ack_Resp,       // from link
                         Data_Link_Established,  // from link
                         Data_Link_Terminated,   // from link

                                              // network associated events
                         Rcv_AX25_Proto,
                         Rcv_File_Proto,
                         Rcv_Dir_Proto,
                         RcvFTL0Proto,
                         Rcv_No_L3_Proto,


                         Connect_Delayed_Timeout,
                         Rcv_Sat_Full_Frame,     // via UI frame
                         Rcv_Sat_Open_Frame,     // via UI frame
                         Rcv_LOGIN_RESP,

                         User_Requests_Upload,   // upload events
                         File_Queued,
                         Rcv_UL_GO_RESP,
                         Rcv_UL_ERROR_RESP,
                         Rcv_UL_ACK_RESP,
                         Rcv_UL_NAK_RESP,

                         User_Requests_Abort,    // up & download event

                         User_Requests_Download, // download events
                         User_Requests_Directory,
                         User_Requests_Selection,
                         Rcv_DL_ABORTED_RESP,
                         Rcv_DL_COMPLETED_RESP,
                         Rcv_SELECT_RESP,
                         Rcv_DATA,
                         Rcv_DATA_END,
                         Rcv_DL_ERROR_RESP,

                         User_Requests_Fill_Dir, // broadcast events
                         User_Requests_Begin_File,
                         User_Requests_Fill_File,
                         User_Requests_Stop_File,
                         RcvBcstQueueFrame,

                         Last_Heard_Timeout,     // timer events
                         AckTimerExpired,
                         IdleTimerExpired };

          unsigned       i;                      // type identifier
          void*          m;                      // message pointer

  static  void           display( unsigned eventType,
                                  Window&  win,
                                  Config&  cfg );

private:
   static char*          eventStr[ 59 ];
};

class EventQueue
{
public:
                         EventQueue( Config& cfg, Window& win  );
                         ~EventQueue() {};
          void           add( unsigned i, void* m );
          int            empty();
          int            next( unsigned* i, void** m );
          void           flush();

private:
   static enum         { QUEUE_SIZE = 50 };

          int            count;
          Config&        cfg;
          Event          list[ QUEUE_SIZE ];
          int            qsize;
          Window&        win;
};

#endif __QUEUE_H
