//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __PROTOCOL_H
#define  __PROTOCOL_H

#ifndef  __OBJECT_H
#include "object.h"
#endif

// Description
//
//    Defines the abstract base class Protocol.  Protocol is the class
//    at the root of all communications protocols and protocol interfaces.
//

class CallUp;
class MBuf;
class Window;

#include "window.h"

class Protocol : public Object
{
public:
            enum        {  SEND_IN        = 1,    // i/o logging/tracing control
                           SEND_OUT       = 2,
                           RECV_IN        = 4,
                           RECV_OUT       = 8 };

            unsigned long  sendBytesIn;
            unsigned long  sendBytesOut;
            unsigned long  sendErrCnt;
            unsigned       sendFramesIn;
            unsigned       sendFramesOut;
            unsigned long  recvBytesIn;
            unsigned long  recvBytesOut;
            unsigned long  recvErrCnt;
            unsigned       recvFramesIn;
            unsigned       recvFramesOut;
   static   Protocol*      ZERO;
   static   unsigned       UZERO;

                           Protocol();
   virtual                 ~Protocol() {};
   virtual  void           logRecvIn() {}
                           //  receive an incoming filled MBuf to process
   virtual  void           setErrCall( CallUp& func ) { eCallUp = &func; }
   virtual  void           setInfoWin( Window& win ) { iWin = &win; }
   virtual  void           setFrameWin( Window& win ) { frWin = &win; }

protected:
            unsigned*      debug;
   static   Window         defaultWin;           // default window
            CallUp*        eCallUp;
   static   Window*        frWin;                // frame window
   static   Window*        iWin;                 // information window
            unsigned*      logInFrames;
            unsigned*      logOutFrames;
            unsigned*      showData;
            unsigned*      showDataHex;
            unsigned*      showErrMsgs;
            unsigned*      showInFrames;
            unsigned*      showOutFrames;
            unsigned*      showHeaders;
};

#define     NOPROTO      *(Protocol::ZERO)

class L1Protocol : public Protocol
{
public:
                           L1Protocol() : Protocol() {}
   virtual  int            send( MBuf& ) = 0;
   virtual  void           recvIn( MBuf& ) = 0;
};

class L2Protocol : public Protocol
{
public:
   static   enum         { XALEN = 7 };

                           L2Protocol() : Protocol() {}
   virtual  void           recvIn( MBuf& ) = 0;
   virtual  int            send( char*   dest,     // destination AX.25 address (7 bytes, shifted)
                                 char*   source,   // source AX.25 address (7 bytes, shifted)
                                 int     cmdrsp,   // command/response indication
                                 int     ctl,      // control field
                                 MBuf&   mb ) = 0; // data field (follows PID)
};

class Level3Iface
{
public:
          L2Protocol*     l2p;                   // level 2 link pointer
          char            src[ L2Protocol::XALEN ];  // source address
          char            dest[ L2Protocol::XALEN ]; // destination address
          MBuf*           bp;                    // pointer to data buffer
          int             mcast;                 // multi-cast flag

                          Level3Iface( L2Protocol* l2p,
                                       char*       src,
                                       char*       dest,
                                       MBuf*       bp,
                                       int         mcast );
};

class L3Protocol : public Protocol
{
public:
                           L3Protocol() : Protocol() {}
   virtual  void           recvIn( Level3Iface& l3If );
};

class ProtoLink
{
private:
public:
            int            pid;                     // protocol identifier
            Protocol*      proto;                   // interfacing protocol
};

class LinkTable
{
public:
                           LinkTable( const unsigned size ) :
                                      tableSize( size ), linkCount( 0 ) {}
   virtual                 ~LinkTable() {}
   virtual  void           insert( Protocol& p, int id );
   virtual  Protocol&      lookup( int id );

protected:
            unsigned       tableSize;
            unsigned       linkCount;
            ProtoLink      link[ 3 ];

};

#endif  __PROTOCOL_H