//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

#ifndef  __CONIO_H
#include "conio.h"
#endif

#ifndef  __MEM_H
#include "mem.h"
#endif

#ifndef  __PROCESS_H
#include <process.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __CALLUP_H
#include "callup.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

Window    Protocol::defaultWin( 1, 1, 80, 25, RED, YELLOW );
Window*   Protocol::iWin = &Protocol::defaultWin;
Window*   Protocol::frWin = &Protocol::defaultWin;
Protocol* Protocol::ZERO = 0;
unsigned  Protocol::UZERO = 0;

Protocol::Protocol() : Object(),
                       debug( &UZERO ), eCallUp( 0 ),
                       logInFrames( 0 ), logOutFrames( 0 ),
                       recvBytesIn( 0 ), recvBytesOut( 0 ),
                       recvErrCnt( 0 ),
                       recvFramesIn( 0 ), recvFramesOut( 0 ),
                       sendBytesIn( 0 ), sendBytesOut( 0 ),
                       sendErrCnt( 0 ),
                       sendFramesIn( 0 ), sendFramesOut( 0 ),
                       showData( &UZERO ), showDataHex( &UZERO ),
                       showErrMsgs( &UZERO ),
                       showInFrames( &UZERO ), showOutFrames( &UZERO ),
                       showHeaders( &UZERO )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{}

Level3Iface::Level3Iface( L2Protocol* l2p,
                          char*       src,
                          char*       dest,
                          MBuf*       bp,
                          int         mcast )
                        :
                        l2p( l2p ),
                        bp( bp ),
                        mcast( mcast )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   memcpy( this->src, src, L2Protocol::XALEN );
   memcpy( this->dest, dest, L2Protocol::XALEN );
}

void L3Protocol::recvIn( Level3Iface& l3If )
// --------------------------------------------------------------------------
//  Receive an incoming interface object to process
// --------------------------------------------------------------------------
{
   delete l3If.bp;
   delete &l3If;
}

void LinkTable::insert( Protocol& p, int id )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (linkCount == tableSize)
      return;
   link[ linkCount ].pid = id;
   link[ linkCount ].proto = &p;
   linkCount++;
}

Protocol& LinkTable::lookup( int id )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   for ( int i = 0; i < linkCount; i++)
      if (id == link[ i ].pid)
         return *link[ i ].proto;
   return NOPROTO;
}
