//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __PKTQUEUE_H
#include "pktqueue.h"
#endif

// --------------------------------------------------------------------------
// Append a packet to the end of the queue
// --------------------------------------------------------------------------
void PktQueue::enqueue( MBuf* bp )
{
   if (bp == 0)
      return;

   if (q == 0)                         // if queue is empty, stick at front
   {
      q = new PktBuf;
      q->mbp = bp;
      q->next = 0;

   }
   else
   {
      PktBuf* pbp;
      for (pbp = q; pbp->next != 0; pbp = pbp->next)
         ;
      pbp->next = new PktBuf;
      pbp->next->mbp = bp;
//      pbp->next->next = 0;                     // C++ 4.01 doesn't like this
      PktBuf* pbp1 = pbp->next;              // Use this for C++ 4.01
      pbp1->next = 0;                        //
   }
   count++;
}

// --------------------------------------------------------------------------
// Unlink a packet from the head of the queue
// --------------------------------------------------------------------------
MBuf* PktQueue::dequeue()
{
   if (q == 0)
      return 0;

   PktBuf* pbp = q;
   q = pbp->next;
   MBuf* bp = pbp->mbp;
   delete pbp;
   count--;
   return bp;
}

// --------------------------------------------------------------------------
// Initialize the queue iterator.  Skip the first i packets in the the queue.
// and return the i+1 packet.
// --------------------------------------------------------------------------
MBuf* PktQueue::initIterator( const unsigned i )
{
   if (q == 0)
      return 0;

   unsigned j = i;
   for (qIterator = q; qIterator != 0; qIterator = qIterator->next)
      if (j == 0)
         return qIterator->mbp;
      else
         j--;
   return 0;
}

// --------------------------------------------------------------------------
// Iterate to the next packet in the queue
// --------------------------------------------------------------------------
MBuf* PktQueue::next()
{
   if( qIterator == 0)
      return 0;
   qIterator = qIterator->next;
   if (qIterator != 0)
      return qIterator->mbp;
   else
      return 0;
}

// --------------------------------------------------------------------------
// Free entire queue of packets
// --------------------------------------------------------------------------
void PktQueue::free()
{
   MBuf* bp;
   while ((bp = dequeue()) != 0)
      delete bp;
}

// --------------------------------------------------------------------------
// Count up the total number of bytes in the queue
// --------------------------------------------------------------------------
unsigned PktQueue::len() const
{
   if (!q)
      return 0;
   PktBuf* bp = q;
   unsigned cnt = 0;
   while (bp != 0)
   {
      cnt += bp->mbp->cnt;
      bp = bp->next;
   }
   return cnt;
}
