//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __CTYPE_H
#include <ctype.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __PFHEADER_H
#include "pfheader.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

PFileHeader* PFileHeader::ZERO = 0;

char PFileHeader::statusChar[] = { 'g', '', 'A', ' ', 'n', ' ', ' ', ' ',
                                   'P', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
                                   ' ', ' ', 'E' };

PFileHeader::PFileHeader( Window& iWin )
                        :
                          iWin( iWin ),
                          file_number( 0 ),                // 0x01
                          file_size( 0 ),                  // 0x04
                          last_modified_time( 0 ),         // 0x06 *
                          seu_flag( 0 ),                   // 0x07 *
                          file_type( 0 ),                  // 0x08
                          header_checksum( 0 ),            // 0x0a
                          source( 0 ),                     // 0x10
                          upload_time( 0 ),                // 0x12
                          download_count( 0 ),             // 0x13 *
                          destination( 0 ),                // 0x14
                          expire_time( 0 ),                // 0x17
                          priority( 0 ),                   // 0x18
                          compression_type( 0 ),           // 0x19
                          bbs_message_type( 0 ),           // 0x20 *
                          bulletin_id_number( 0 ),         // 0x21
                          title( 0 ),                      // 0x22
                          keywords( 0 ),                   // 0x23
                          file_description( 0 ),           // 0x24
                          compression_description( 0 ),    // 0x25
                          user_file_name( 0 ),             // 0x26
                          csum( 0 ),                       // calculated checksum
                          status( 0 )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{
   *file_name = 0;                               // 0x02
   *file_ext = 0;                                // 0x03 *
   *ax25_uploader = 0;                           // 0x11
   pFileHeaderSize = sizeof( PFileHeader ) + 100;
}

PFileHeader::PFileHeader( const PFileHeader& p ) : iWin( p.iWin )
// --------------------------------------------------------------------------
//  Copy constructor
// --------------------------------------------------------------------------
{
   file_number = p.file_number;
   strcpy( file_name, p.file_name );
   strcpy( file_ext, p.file_ext );
   file_size = p.file_size;
   last_modified_time = p.last_modified_time;
   seu_flag = seu_flag;
   file_type = p.file_type;
   header_checksum = p.header_checksum;
   if ((source = new char[ strlen( p.source ) + 1 ]) != 0)
      strcpy( source, p.source);
   strcpy( ax25_uploader, p.ax25_uploader );
   upload_time = p.upload_time;
   download_count = p.download_count;
   if ((destination = new char[ strlen( p.destination ) + 1 ]) != 0)
      strcpy( destination, p.destination );
   expire_time = p.expire_time;
   priority = p.priority;
   compression_type = p.compression_type;
   bbs_message_type = p.bbs_message_type;
   if ((bulletin_id_number = new char[ strlen( p.bulletin_id_number ) + 1 ]) != 0)
      strcpy( bulletin_id_number, p.bulletin_id_number );
   if ((title = new char[ strlen( p.title ) + 1 ]) != 0)
      strcpy( title, p.title );
   if ((keywords = new char[ strlen( p.keywords ) + 1 ]) != 0)
      strcpy( keywords, p.keywords );
   if ((file_description = new char[ strlen( p.file_description ) + 1 ]) != 0)
      strcpy( file_description, p.file_description );
   if ((compression_description =
      new char[ strlen( p.compression_description ) + 1 ]) != 0)
      strcpy( compression_description, p.compression_description );
   if ((user_file_name = new char[ strlen( p.user_file_name ) + 1 ]) != 0)
      strcpy( user_file_name, p.user_file_name );
   csum = p.csum;
   displayThis = p.displayThis;
   pFileHeaderSize = p.pFileHeaderSize;
   status = p.status;
}

PFileHeader::~PFileHeader()
// --------------------------------------------------------------------------
//  Destructor
// --------------------------------------------------------------------------
{
   if (source)
      delete source;
   if (destination)
      delete destination;
   if (bulletin_id_number)
      delete bulletin_id_number;
   if (title)
      delete title;
   if (keywords)
      delete keywords;
   if (file_description)
      delete file_description;
   if (compression_description)
      delete compression_description;
   if (user_file_name)
      delete user_file_name;
}

void PFileHeader::display()
// ---------------------------------------------------------------------
//  Display pacsat file header
// ---------------------------------------------------------------------
{
   if (&iWin == Window::ZERO )
      return;
   iWin.print( prtStr() );                       // display in info window
}

void PFileHeader::display( const unsigned position )
// ---------------------------------------------------------------------
//  Display pacsat file header in the infoWindow at a specific position
// ---------------------------------------------------------------------
{
   if (&iWin == Window::ZERO )
      return;
   iWin.printLine( position + 2, prtStr() );     // display
   iWin.printLine( position + 2, "-->" );        // overwrite "Dir"
}

int PFileHeader::displayOnScreen( const int panFlag )
// ---------------------------------------------------------------------
//   Displays the contents of a pfh data object on the screen.
// ---------------------------------------------------------------------
{
   char line[80];

   if (!displayThis)
      return 0;
   char* titlePtr = strlen( title ) != 0 ? title : file_name;
   if (!panFlag)
   {
      struct tm* Time = localtime( (time_t *)&upload_time );
      char fileTime[ 12 ];
      strftime( fileTime, 12, "%m/%d %H:%M", Time );
      sprintf( line,
               "%8lx\xb3%c\xb3%-30.30s\xb3%-6.6s\xb3%-6.6s\xb3%s\xb3%7lu    ",
               file_number, statusChar[ status ], titlePtr, destination,
               source, &fileTime, file_size );
   }
   else
      sprintf( line,
               "%8lx\xb3%c\xb3%-40.40s\xb3%-27.27s",
               file_number, statusChar[ status ], titlePtr, keywords );
   cputs( line );
   return 1;
}

void PFileHeader::displayOnScreen() const
// ---------------------------------------------------------------------
//  Displays the contents of a pfh data object on the screen.  Uses
//  entire screen.
// ---------------------------------------------------------------------
{
   struct tm* Time = localtime( (time_t *)&upload_time );
   char upTime[ 12 ];
   strftime( upTime, 12, "%m/%d %H:%M", Time );
   Time = localtime( (time_t *)&expire_time );
   char exTime[ 12 ];
   strftime( exTime, 12, "%m/%d %H:%M", Time );
   clrscr();
   char* typeStr;
   switch (unsigned( file_type ))
   {
      case 0:
         typeStr = "ASCII text";
         break;
      case 1:
         typeStr = "RLI/MBL message";
         break;
      case 2:
         typeStr = "RLI/MBL import file (multiple messages)";
         break;
      case 3:
         typeStr = "UoSat whole orbit data";
         break;
      case 6:
         typeStr = "MS-DOS .EXE file";
         break;
      case 7:
         typeStr = "MS-DOS .COM file";
         break;
      case 8:
         typeStr = "Keplerian Elements (NASA format)";
         break;
      case 9:
         typeStr = "Keplerian Elements (AMSAT format)";
         break;
      case 12:
         typeStr = "Multiple files (one or more non-ASCII)";
         break;
      case 13:
         typeStr = "Multiple files (all ASCII)";
         break;
      case 14:
         typeStr = "Image - GIF format";
         break;
      case 15:
         typeStr = "Image - PCX format";
         break;
      case 16:
         typeStr = "Image - JPG format";
         break;
      case 200:
         typeStr = "Configuration files - U/L from command stations";
         break;
      case 201:
         typeStr = "AL FTL0/PB activity logs";
         break;
      case 202:
         typeStr = "BL broadcast logs";
         break;
      case 203:
         typeStr = "WD whole orbit data logs";
         break;
      case 204:
         typeStr = "ADCS logs";
         break;
      case 205:
         typeStr = "TDE logs";
         break;
      case 206:
         typeStr = "SCTE logs";
         break;
      case 207:
         typeStr = "Transputer logs (including EISLOG)";
         break;
      case 208:
         typeStr = "SEU logs";
         break;
      case 209:
         typeStr = "CPE logs (UO3)";
         break;
      case 210:
         typeStr = "Battery charge logs";
         break;
      case 211:
         typeStr = "Image files";
         break;
      case 212:
         typeStr = "PL* (SPL logs)";
         break;
      case 213:
         typeStr = "CU* (PCT log files)";
         break;
      case 214:
         typeStr = "PC* (PCT command logs)";
         break;
      case 215:
         typeStr = "Quick look image files";
         break;
      default:
         typeStr = "Unknown";
         break;
   }

   cprintf( "Type any key to return to directory list.\r\n\r\n"
            "Message id          : %8lx\r\n"
            "Length              : %8lu\r\n"
            "Body type           : %3u %s\r\n"
            "File name           : %s\r\n"
            "Title               : %.56s\r\n"
            "Key words           : %.56s\r\n"
            "Sender              : %.56s\r\n"
            "Uploader            : %s\r\n"
            "Destination         : %.56s\r\n"
            "Posted at           : %s\r\n"
            "Expires at          : %s\r\n"
            "Priority            : %3u\r\n"
            "Compression         : %3u\r\n\r\n"
            "BID                 : %.56s\r\n"
            "Body info           : %.56s\r\n"
            "Original name       : %.56s\r\n",
            file_number,
            file_size,
            (unsigned) file_type, typeStr,
            file_name,
            title,
            keywords,
            source,
            ax25_uploader,
            destination,
            upTime,
            exTime,
            (unsigned) priority,
            (unsigned) compression_type,
            bulletin_id_number,
            compression_description,
            user_file_name );
}

unsigned PFileHeader::get( char* data, int cnt )
// --------------------------------------------------------------------------
//  Gets a pacsat file header (pfh) from the accumulator array.  If a
//  complete pfh is in the array, return a pointer to the pfh info
//  structure.  If the pfh is incomplete, return a NULL pointer.
// --------------------------------------------------------------------------
{
   char* cp = data;                              // point to first data byte
   char* last = data + cnt - 1;                  // point to last data byte

   if (*cp++ != 0xAA || *cp++ != 0x55)           // check for AA55
      return 0;

   csum = 0xAA + 0x55;                           // start checksum calc

   file_number = 0;                              // 0x01
   file_size = 0;                                // 0x04
   last_modified_time = 0;                       // 0x06
   seu_flag = 0;                                 // 0x07
   file_type = 0;                                // 0x08
   header_checksum = 0;                          // 0x0a
   if (source)                                   // delete dynamicly
   {                                             // allocated space from
      delete source;                             // previous "get()"
      source = 0;                                // 0x10
   }
   *ax25_uploader = 0;                           // 0x11
   upload_time = 0;                              // 0x12
   download_count = 0;                           // 0x13
   if (destination)
   {
      delete destination;
      destination = 0;                           // 0x14
   }
   expire_time = 0;                              // 0x17
   priority = 0;                                 // 0x18
   compression_type = 0;                         // 0x19
   bbs_message_type = 0;                         // 0x20
   if (bulletin_id_number)
   {
      delete bulletin_id_number;
      bulletin_id_number = 0;                    // 0x21
   }
   if (title)
   {
      delete title;
      title = 0;                                 // 0x22
   }
   if (keywords)
   {
      delete keywords;
      keywords = 0;                              // 0x23
   }
   if (file_description)
   {
      delete file_description;
      file_description = 0;                      // 0x24
   }
   if (compression_description)
   {
      delete compression_description;
      compression_description = 0;               // 0x25
   }
   if (user_file_name)
   {
      delete user_file_name;
      user_file_name = 0;                        // 0x26
   }
   status = 0;

   pFileHeaderSize = sizeof( PFileHeader ) + 100;

   // read header items

   while (1)                                     // for all header fields
   {
      if (cp + 2 > last)                         // if not complete id and len
         return 0;

      unsigned id    = *cp++;
      unsigned id2   = *cp++;
      unsigned len   = *cp++;
      id       |= id2 << 8;
      csum += id + id2 + len;

      if (id == 0 && len == 0)                   // if end of header
         break;                                  //   yes, exit loop
      if (cp + len - 1 > last)                   // if out of data
         return 0;                               //   yes, exit function

      int i;
      unsigned long val;
      if (len <= 4)
      {
         val = 0;
         for (i = 0; i < len; i++)               // reverse the bytes
            val |= (unsigned long) *cp++ << (8 * i);
         cp -= len;                              // back up to start of field
      }

      if (id == 0x0A)                            // get checksum field
         header_checksum = val;
      else
      {
         for (i = 0; i < len; i++)               // calculate our own
            csum += *cp++;
         cp -= len;                              // back up to start of field
      }

      // Decode header items

      switch (id)
      {
         case 0x01:                              // file number
            file_number = val;
            break;
         case 0x02:                              // file name
            if (len > 8)
               len = 8;
            memcpy( file_name, cp, len );
            file_name[ len ] = 0;
            break;
         case 0x03:                              // file extension
            if (len > 3)
               len = 3;
            memcpy( file_ext, cp, len );
            file_ext[ len ] = 0;
            break;
         case 0x04:                              // file size
            file_size = val;
            break;
         case 0x05:                              // create time
            upload_time = val;
            break;
         case 0x06:                              // last modified time
            last_modified_time = val;
            break;
         case 0x07:                              // seu flag
            seu_flag = *cp;
            break;
         case 0x08:                              // file type
            file_type = char( val );
            break;
         case 0x10:                              // source
            if ((source = new char[ len + 1 ]) != 0)
            {
               memcpy( source, cp, len );
               source[ len ] = 0;
               pFileHeaderSize += len + 1;
               char* chp;
               for (chp = source; *chp != 0; chp++) // make it upper case
                  *chp = toupper( *chp );
            }
            break;
         case 0x11:                              // ax25 uploader
            if (len > 6)
               len = 6;
            memcpy( ax25_uploader, cp, len );
            ax25_uploader[ len ] = 0;
            char* chp;
            for (chp = ax25_uploader; *chp != 0; chp++) // make it upper case
               *chp = toupper( *chp );
            if (source[ 0 ] == 0)
            {
               memcpy( source, cp, len );
               source[ len ] = 0;
            }
            break;
         case 0x12:                              // upload time
            upload_time = val;
            break;
         case 0x13:                              // download count
            download_count = unsigned( *cp );
            break;
         case 0x14:                              // destination
            if ((destination = new char[ len + 1 ]) != 0)
            {
               memcpy( destination, cp, len );
               destination[ len ] = 0;
               pFileHeaderSize += len + 1;
               char* chp;
               for (chp = destination; *chp != 0; chp++) // make it upper case
                  *chp = toupper( *chp );
            }
            break;
         case 0x17:                              // expire time
            expire_time = val;
            break;
         case 0x18:
            priority = *cp;                      // priority
            break;
         case 0x19:
            compression_type = *cp;              // compression type
            break;
         case 0x20:                              // bbs message type
            bbs_message_type = unsigned( *cp );
            break;
         case 0x21:                              // bulletin ID number
            if ((bulletin_id_number = new char[ len + 1 ]) != 0)
            {
               memcpy( bulletin_id_number, cp, len );
               bulletin_id_number[ len ] = 0;
               pFileHeaderSize += len + 1;
            }
            break;
         case 0x22:                              // title
            if ((title = new char[ len + 1 ]) != 0)
            {
               memcpy( title, cp, len );
               title[ len ] = 0;
               pFileHeaderSize += len + 1;
            }
            break;
         case 0x23:                              // keywords
            if ((keywords = new char[ len + 1 ]) != 0)
            {
               memcpy( keywords, cp, len );
               keywords[ len ] = 0;
               pFileHeaderSize += len + 1;
            }
            break;
         case 0x24:                              // file description
            if ((file_description = new char[ len + 1 ]) != 0)
            {
               memcpy( file_description, cp, len );
               file_description[ len ] = 0;
               pFileHeaderSize += len + 1;
            }
            break;
         case 0x25:                              // compression description
            if ((compression_description = new char[ len + 1 ]) != 0)
            {
               memcpy( compression_description, cp, len );
               compression_description[ len ] = 0;
               pFileHeaderSize += len + 1;
            }
            break;
         case 0x26:                              // user filename
            if ((user_file_name = new char[ len + 1 ]) != 0)
            {
               memcpy( user_file_name, cp, len );
               user_file_name[ len ] = 0;
               pFileHeaderSize += len + 1;
            }
      }
      cp += len;
   }
   return unsigned( cp - data );                 // return length of header
}

char* PFileHeader::prtStr() const
// ---------------------------------------------------------------------
//  Create print string to display pacsat file header
// ---------------------------------------------------------------------
{
   char t_buf[ 10 ];
   if (upload_time)                              // make file time a string
   {
      struct tm* tm = localtime( (time_t*) &upload_time );
      sprintf( t_buf, "%02u%02u/%02u%02u",
               tm->tm_mon + 1, tm->tm_mday, tm->tm_hour, tm->tm_min );
   }
   else
      strcpy( t_buf, "????/????" );
                                                 // set up dir entry string
   static char buf[ 64 ];
   sprintf( buf, "Dir% 8lx S:%-10.10s T:%-6.6s F:%-6.6s",
            file_number,
            title ? title : file_name,
            destination ? destination : "",
	    source ? source : "" );
   return (char*) &buf;
}

int PFileHeader::operator ==( const PFileHeader& testPfh ) const
// ---------------------------------------------------------------------
//  Determines whether two pfhs are equal by comparing their
//  file numbers.
// ---------------------------------------------------------------------
{
   return file_number == testPfh.file_number;
}

int PFileHeader::operator !=( const PFileHeader& testPfh ) const
// ---------------------------------------------------------------------
//  Determines whether two pfhs are unequal by comparing their
//  file numbers.
// ---------------------------------------------------------------------
{
   return file_number != testPfh.file_number;
}

int PFileHeader::operator <( const PFileHeader& testPfh ) const
// ---------------------------------------------------------------------
//  Determines the ordering of two pfhs.
// ---------------------------------------------------------------------
{
// return upload_time < testPfh.upload_time;
   return file_number < testPfh.file_number;
}

int PFileHeader::operator >( const PFileHeader& testPfh ) const
// ---------------------------------------------------------------------
//  Determines the ordering of two pfhs.
// ---------------------------------------------------------------------
{
// return upload_time > testPfh.upload_time;
   return file_number > testPfh.file_number;
}
