//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __ROTOR_H
#include "rotor.h"
#endif

#ifndef  __SCRWRITE_H
#include "scrwrite.h"
#endif

#ifndef  __SLIP_H
#include "slip.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

#ifndef  __TNCMGR_H
#include "tncmgr.h"
#endif

int MsgLine::initFlag = 0;

MsgLine::MsgLine( const int line, const int bg, const int fg )
                :
                  left( 1 ), right( 80 ), line( line ),
                  bg( bg ), fg( fg )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   if (!initFlag)
   {
      initscwr();                                // init screen write funct
      initFlag = 1;
   }
   msgBuf = new char( right - left + 1 );
   horizline( left, right, line, fg, bg, ' ' );
}

MsgLine::~MsgLine()
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   delete msgBuf;
   horizline( left, right, line, fg, bg, ' ' );
}

void MsgLine::print( const char* c ) const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   writeat( left, line, fg, bg, (char*) c );
}

void MsgLine::printOff( const int offset, const char* c ) const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   writeat( left + offset, line, fg, bg, (char*) c );
}

void MsgLine::printRev( const char* c ) const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   writeat( left, line, bg, LIGHTGRAY, (char*) c );
}

StatusLine::StatusLine( const int bg, const int fg )
                :
                  MsgLine( 25, bg, fg ), highRate( 0 )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   print( "DIR:            AUTO:" );
   printOff( 46, "s:      b:        d:       e:" );
}

void StatusLine::autoStatus( const char* s ) const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   printOff( 23, "        " );
   printOff( 23, s );
}

void StatusLine::currentMode( const int tncMode ) const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   printOff( 33, tncMode == TncMgr::KissMode ? "Kiss" : "Term" );
}

void StatusLine::dirStatus( const int count ) const
// -------------------------------------------------------------------------
//  Display the directory hole count
// -------------------------------------------------------------------------
{
   if (count > 0)
   {
      sprintf( msgBuf, "Part (%i)", count );
      printOff( 13, "  " );
   }
   else
      strcpy( msgBuf,  "Up-to-date" );
   printOff( 5, msgBuf );
}

void StatusLine::dirTotal( const unsigned long total ) const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   sprintf( msgBuf, "%06lu", total );
   printOff( 66, msgBuf );
}

void StatusLine::errorTotal( const unsigned long count ) const
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
{
   sprintf( msgBuf, "%-6lu", count );
   printOff( 75, msgBuf );
}

void StatusLine::fileTotal( const unsigned long count ) const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   sprintf( msgBuf, "%06lu", count );
   printOff( 56, msgBuf );
}

void StatusLine::linkStatus( const char* s ) const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   printOff( 36, s );
}

void StatusLine::showDlRate( Config&     cfg,
                             L1Protocol* proto,
                             Timer&      dlRateTimer,
                             Timer&      exitAfterTimer,
                             Rotor&      antennaControl )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   static unsigned long lastInCount = 0;
   unsigned long rate = (proto->recvBytesIn - lastInCount) / 5;
   if (rate > highRate)
      highRate = rate;
   static char msgBuf[ 32 ];
   sprintf( msgBuf, "%04.5lu", rate );
   printOff( 48, "     " );
   printOff( 48, msgBuf );
   lastInCount = proto->recvBytesIn;
   dlRateTimer.start();

   // To avoid restarting the exitAfterTimer after every packet, we restart
   // it here.  Therefore, the test for activity is done only every 5
   // seconds.

   if (rate && cfg.exitAfterMs)                  // if activity past 5 secs
      exitAfterTimer.start();

   // If OrbitDrv by KB5MU is being used to provide satellite position
   // information to Kansas City Tracker compatible hardware, periodically
   // update the OrbitDrv TSR by sending it the address of a (double)
   // that contains the current time in modified julian format.  WDR

   if (antennaControl.orbitDrvPresent)
      antennaControl.setOrbitDrvTime( Timer::dosTime() );
}

CmdLine::CmdLine( const int bg, const int fg )
                :
                  MsgLine( 1, bg, fg )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{}

void CmdLine::dirSelect() const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   char c[] = "[A]ll, [B]ulletin, [M]ine [O]ne (CR for Bulletin)";
   printRev( c );
}

void CmdLine::init() const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{

   char c[] = "Download: Priority Auto Grab Never Fill "
              "Dir                                     ";
   print( c );
}

void CmdLine::msg( const char* cp1, const unsigned long fileNumber,
                   const char* cp2 ) const
// ------------------------------------------------------------------------
//  Display command message
// ------------------------------------------------------------------------
{
   char* msgBuf = new char[ 80 ];
   if (fileNumber == 0)
      sprintf( msgBuf, "%s message number: %s",
              cp1, cp2 );
   else
      sprintf( msgBuf, "%s message number[%lx]: %s",
              cp1, fileNumber, cp2 );
   printRev( "                                            " );
   printRev( msgBuf );
   delete msgBuf;
}
