//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __MISC_H
#include "misc.h"
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

void charcat( char* cp, char ch )
{
   int i;

   i = strlen( cp );
   cp[ i ] = ch;
   cp[ i+1 ] = 0;
}

// -------------------------------------------------------------------------
// calcrc: XMODEM routine for calculating CRCs
//
// Calculate CRC on a block of data.  Ptr points to block of characters,
// count gives the size of buffer.  This program returns the CRC with the
// LSB of the CRC in the high bit of the result integer.  XMODEM deviates
// from the CCITT standard in that it does not use the LSB of the data 1st,
// nor does it initialize the CRC to all ones as specified by the standard.
// -------------------------------------------------------------------------
int calcrc( char* ptr, int count )
{
   unsigned int crc;
   int      i;

   crc = 0;                            // note not 0xFFFF
   while (--count >= 0)
   {
      crc  ^= (int) *ptr++ << 8;       // convert data char to int
                                       // shift char to high byte
                                       // add current data to current
                                       // remainder modifies only least
                                       // sig 8 bits (high byte) of CRC
      for (i = 0; i < 8; ++i)          // loop for each bit
         if (crc & 0x8000)             // test D XOR R0
         {
            crc  <<= 1;                // disgard LSB of CRC and
                                       // append zero
            crc ^= 0x1021;             // XOR with low 16 bits
                                       // of CCITT polynomial
                                       // because CRC is stored LSB 1st
         }
         else
            crc <<= 1;                 // disgard LSB and append zero
   }
   return crc & 0xFFFF;                // 16-bit result for whole block
}

#include <dos.h>

int setMaxHandleCount( const unsigned count )
// -------------------------------------------------------------------------
//  Sets the maximum number of handles a program can use at any one time.
//  Returns 0 on success, nonzero on failure.
// -------------------------------------------------------------------------
{
   union REGS regs;
   int ret;
   regs.h.ah = 0x67;
   regs.x.bx = count;
   ret = intdos( &regs, &regs );
   return( regs.x.cflag ? ret : 0 );             // error if carry flag is set
}

