//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// LEXICAL.H

#ifndef  LEXICAL_H
#define  LEXICAL_H

#ifndef  __SYMBOL_H
#include "symbol.h"
#endif

#define MAXSTMTLENGTH   1000                     // Max length of a input

class LexicalAnalyzer
{
public:
                        // Token values returned by getsymbol()

   enum                 {  ENDOFLINE = 0,           //  0
                           ALIAS,                   //  1
                           AND,                     //  2
                           ASCTIME,                 //  3
                           AUTO,                    //  4
                           AX25_UPLOADER,           //  5
                           BBS_MESSAGE_TYPE,        //  6
                           BULLETIN_ID_NUMBER,      //  7
                           COMPRESSION_DESC,        //  8
                           COMPRESSION_TYPE,        //  9
                           CREATE_TIME,             // 10
                           DAY,                     // 11
                           DAYS,                    // 12
                           DEBUG,                   // 13
                           DESTINATION,             // 14
                           DOWNLOAD_COUNT,          // 15
                           EQUATIONSIZE,            // 16
                           EXPIRE_TIME,             // 17
                           EXTRAMASK,               // 18
                           F1,                      // 19
                           F10,                     // 20
                           F11,                     // 21
                           F12,                     // 22
                           F2,                      // 23
                           F3,                      // 24
                           F4,                      // 25
                           F5,                      // 26
                           F6,                      // 27
                           F7,                      // 28
                           F8,                      // 29
                           F9,                      // 30
                           FILE_DESCRIPTION,        // 31
                           FILE_EXT,                // 32
                           FILE_NAME,               // 33
                           FILE_NUMBER,             // 34
                           FILE_SIZE,               // 35
                           FILE_TYPE,               // 36
                           GETENVAR,                // 37
                           HOUR,                    // 38
                           HOURS,                   // 39
                           INPUT,                   // 40
                           KEYPRESS,                // 41
                           KEYTITLE,                // 42
                           KEYWORDS,                // 43
                           LAST_MODIFIED_TIME,      // 44
                           MASKAUTO,                // 45
                           MASKDONE,                // 46
                           MASKNEVER,               // 47
                           MASKPRIORITY,            // 48
                           MINUTE,                  // 49
                           MINUTES,                 // 50
                           MODULUS,                 // 51
                           MOD,                     // 52
                           MYADDR,                  // 53
                           MYCALL,                  // 54
                           NEVER,                   // 55
                           OR,                      // 56
                           PRECEDENCE,              // 57
                           PRIORITY,                // 58
                           SEU_FLAG,                // 59
                           SOURCE,                  // 60
                           TITLE,                   // 61
                           TODAY,                   // 62
                           UPLOAD_TIME,             // 63
                           USER_FILE_NAME,          // 64
                           WEEK,                    // 65
                           WEEKS,                   // 66
                           KBAND,                   // 67
                           KBOR,                    // 68
                           NOT,                     // 69
                           OTHER,                   // 70
                           IDENTIFIER,              // 71
                           NUMCONSTANT,             // 72
                           LP,                      // 73
                           RP,                      // 74
                           ADDOP,                   // 75
                           SUBOP,                   // 76
                           MULOP,                   // 77
                           DIVOP,                   // 78
                           EQOP,                    // 79
                           COMMA,                   // 80
                           SEMICOLON,               // 81
                           COLON,                   // 82
                           BACKSLASH,               // 83
                           LESOP,                   // 84
                           LEQOP,                   // 85
                           NEQOP,                   // 86
                           GTOP,                    // 87
                           GEQOP,                   // 88
                           STRCONSTANT,             // 89
                           STATUS                   // 90
                        };

          char            symbol[ MAXSYMLENGTH + 1];// current input symbol
          int             token;                    // current tokenized symbol
          unsigned long   tokenValue;               // current value of #s
   static char*           keywords[ 67 ];           // keywords quickly
          int             debug;                    // display debugging info

                          LexicalAnalyzer() : debug( 0 ) {}

                          // Call initLexicalyzer before calling getSymbol()

          void            initLexicalyzer( const char* lineToParse );
          unsigned        getSymbol();

private:
          #define         NUMVALIDCHARS 55          // # of valid input chars

   static const char      validChars[ NUMVALIDCHARS ];
   static unsigned        map[ 26 ];                // symbol table to locate
   static char*           errorMessages[ 2 ];       // content of error messages
          char            statement[ MAXSTMTLENGTH ]; // statement to be parsed
          char*           bufPtr;                   // ptr into statement
          char*           pSymbol;                  // ptr into symbol
          char            ch;                       // current input char
          int             charOffset;               // char offset in statement

          void            lookupKeyword( char* sym, int& keywrd );
          char            getNextChar();
          void            error( int errcode );
};

#endif


