//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __KISS_H
#define  __KISS_H

// Object class for encapsulating frames in KISS TNC

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

class Ax25;
class Config;

class Kiss : public L1Protocol
{
public:
         enum      KissVal { DATA     = 0,
                                              // medium access control
                             TXDELAY  = 1,
                             PERSIST  = 2,
                             SLOTTIME = 3,
                             TXTAIL   = 4,
                             FULLDUP  = 5,
                             HW       = 6,
                             OFF      = 0xFF };

                   Kiss( unsigned& debug );
   void            link( L1Protocol& loPro, L2Protocol& hiPro );
   void            recvIn( MBuf& );
                      // get from the receiver a pointer to an MBuf that
                      // the receiver created and filled with input
   int             send( MBuf& );
   long            send( enum KissVal cmd, const unsigned long val ) const;

private:
         L2Protocol* hiProto;
         L1Protocol* loProto;

         void      showFrame( const MBuf& ) const;
};

#endif __KISS_H
