//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __SATLINK_H
#include "satlink.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __CTPYE_H
#include <ctype.h>
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __SIGNAL_H
#include <signal.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __ACTLIST_H
#include "actlist.h"
#endif

#ifndef  __ASYINTF_H
#include "asyintf.h"
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __AXSOCK_H
#include "axsock.h"
#endif

#ifndef  __CHGHIGH_H
#include "chghigh.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __DIRBCST_H
#include "dirbcst.h"
#endif

#ifndef  __DIRDL_H
#include "dirdl.h"
#endif

#ifndef  __DIRECTRY_H
#include "directry.h"
#endif

#ifndef  __DIRFILE_H
#include "dirfile.h"
#endif

#ifndef  __FILEBCST_H
#include "filebcst.h"
#endif

#ifndef  __FILEINTF_H
#include "fileintf.h"
#endif

#ifndef  __GETUE_H
#include "getue.h"
#endif

#ifndef  __AX25USER_H
#include "ax25User.h"
#endif

#ifndef  __HDLNOL3_H
#include "hdlnol3.h"
#endif

#ifndef  __HELP_H
#include "help.h"
#endif

#ifndef  __KISS_H
#include "kiss.h"
#endif

#ifndef  __FTL0_H
#include "ftl0.h"
#endif

#ifndef  __FTL0USER_H
#include "ftl0user.h"
#endif

#ifndef  __LOG_H
#include "log.h"
#endif

#ifndef  __MISC_H
#include "misc.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __QUEUE_H
#include "queue.h"
#endif

#ifndef  __ROTOR_H
#include "rotor.h"
#endif

#ifndef  _SCRWRITE_H
#include "scrwrite.h"
#endif

#ifndef  __SEMANTIC_H
#include "semantic.h"
#endif

#ifndef  __SLIP_H
#include "slip.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __SYNTAX_H
#include "syntax.h"
#endif

#ifndef  __TERMINAL_H
#include "terminal.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

#ifndef  __TNCMGR_H
#include "tncmgr.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

unsigned ckMBBIOS( unsigned port )
// -------------------------------------------------------------------------
//  Check if MBBIOS is loaded for a particular port.  Return 1 if yes, 0 if
//  no.
// -------------------------------------------------------------------------
{
   static struct REGPACK reg;
   reg.r_dx = port - 1;
   reg.r_ax = 0x0400;
   intr( 0x14, &reg );
   if (reg.r_ax == 0xAA55)
      return 1;
   else
      return 0;
}

void SatLink::initialize()
// --------------------------------------------------------------------------
//  Initialize all program functions.
//
//  This function creates instances of the high level objects that SatLink
//  uses.  The objects range from display objects to protocol objects for
//  levels 1-3 to the parser objects (lexical, syntactical, and semantical
//  analyzers) for the select equations.
//
//  The order in which the program creates the object instances is important.
//  If the constructor for an object instance (A) requires some other object
//  instance (B) as an argument, then the program will create the instance (B)
//  first.  Pointers to objects are frequently used.  The value of the pointer
//  must be set before it is used as an argument in a constructor call because
//  the pointer is usually dereferenced when it is used.  An exception is the
//  call to the link functions to set the links between the protocols.  In
//  these cases, the pointers are actually passed because A requires B and B
//  requires A.
//
//  Protocol objects are created and then linked.  Explicit linking permits
//  different protocols to be linked without changing the code internal to
//  the objects.  Linking from level 2 to level 3 is via a protocol link
//  table  keyed by the protocol identifier (PID).
//
//  In general, specific level 1-3 protocol objects are derived from generic
//  protocol objects for their respective levels.  This theme is not fully
//  developed because it was an afterthought.  Ideally, all higher level
//  communications functions would be derived from generic objects for levels
//  4-7, even if the generic base class objects are trivial.
//
//  Some objects are derived from an "Object" base class.  This is necessary
//  so that a variety of object types can be passed to the constructor for the
//  "CallUp" objects.  To understand the use of CallUp objects, analyze the
//  constructor calls for various Timer objects and how the Timer object calls
//  the instance of the CallUp object when the TImer expires.
// --------------------------------------------------------------------------
{
   // Create the display objects

   cLine = new CmdLine( cfg.cmdLineBg, cfg.cmdLineFg );
   cLine->init();
   Window::errPath = cfg.workDir;
   Window::capPath = cfg.dlDir;
   fileWin = new Window( 1, 2, 35, 12, cfg.fileWinBg, cfg. fileWinFg );
   fileWin->clear();
   fileWin->printLine( 1, " Message Holes    Size  Offset Rcvd" );
   infoWin = new Window( 37, 2, 80, 12, cfg.infoWinBg, cfg.infoWinFg );
   static Window* msgLine = new Window( 1, 24, 80, 24, cfg.msgLineBg, cfg.msgLineFg );
   infoWin->altWin = msgLine;
   infoWin->clear();
   sLine = new StatusLine( cfg.statusLineBg, cfg.statusLineFg );
   vertline( 36, 2, 12, WHITE, BLACK, 0 );
   horizline( 1, 80, 13, WHITE, BLACK, 0 );
   writeatnc( 1, 13, "SatLink 951107 : " );
   writeatnc( 18, 13, cfg.currentSat );
   frameWin = new Window( 1, 14, 80, 24, cfg.dataWinBg, cfg.dataWinFg );
   frameWin->clear();

   // Screen capture to file

   if (cfg.capture)
   {
      Window::toggleCapture();
      if (Window::capture)
         infoWin->print( "Capture file opened" );
      else
         infoWin->print( "Capture file closed" );
   }

   // Instantiate a syntax analyzer and parse the select equation file.  If
   // no equation file is specified or we can't parse it, use the default
   // equations.  The select equations affect both the directory display
   // function key selections and the file broadcast download selections.
   //
   // Instantiate the semantics analyzer using the largest size of the symbol
   // stack for any equation.

   parser = new SyntaxAnalyzer( cfg.mycall, cfg.alias );
   if (!parser)
      frameWin->printFatal( "Out of memory" );
   if (*cfg.select == 0 || parser->equationFile( cfg.select ) != 0)
      parser->defaultEqns();
   sem = new SemanticsAnalyzer( parser->largestStackSize() );
   if (!sem)
      frameWin->printFatal( "Out of memory" );

   // Initialize general program control functions: maximum DOS file handles,
   // exit routine, and ctrl-c handler

// if (cfg.maxHandleCount)
//    if (setMaxHandleCount( cfg.maxHandleCount ))
//        frameWin->printFatal( "setMaxHandleCount function failed" );
   if (atexit( SatLink::pgmExit ))
      frameWin->printFatal( "atexit function failed" );
   if (signal( SIGINT, SatLink::ctrlc_handler ) == SIG_ERR) 
      frameWin->printFatal( "signal function failed" );

   // Instantiate objects and initialize other functions

   // Message buffer objects

   MBuf::win = frameWin;                         // set dest for MBuf messages

  // Timer objects

   Timer::win = infoWin;                         // set dest for Timer msgs
   Timer::showTimerActivity = cfg.showTimerActivity;

   // Broadcast file status list

   sList = new StatusList( cfg, *infoWin, *frameWin ); // construct sList
   sList->load();                                // read SLIST.DAT

   // Directory file manager (PB__????.PFH)

   dfm = new DirFileMgr( cfg.workDir, cfg.maxDirFileSize, cfg.nDupeSearch,
                         *frameWin );
   if (!dfm)
      frameWin->printFatal( "Out of memory" );
   dfm->checkFiles();                            // check directory files

   // Help

   help = new Help( cfg );

   // Displayed directory

   static int screenCount = 0;
   dir = new Directory( parser, sem, *cLine, cfg, *sList, *dfm, *infoWin,
                        screenCount, *help );
   if (!dir)
      frameWin->printFatal( "Out of memory" );
   dir->init( cfg.workDir, cfg.mycall );         // read initial files

   // Convert callsigns to AX.25 addresses

   if (Ax25::setCall( bcstAddr, cfg.bcstcall) != 0)
   {
      sprintf( frameWin->buf, "Invalid broadcast callsign: %s", cfg.bcstcall );
      frameWin->printFatal( frameWin->buf );
   }
   if (Ax25::setCall( bbsAddr, cfg.bbscall) != 0)
   {
      sprintf( frameWin->buf, "Invalid BBS callsign: %s", cfg.bcstcall );
      frameWin->printFatal( frameWin->buf );
   }
   if (Ax25::setCall( myAddr, cfg.mycall) != 0)
   {
      sprintf( frameWin->buf, "Invalid myCall callsign: %s", cfg.mycall );
      frameWin->printFatal( frameWin->buf );
   }
   if (*cfg.logcall != 0)
   {
      if (Ax25::setCall( logAddr, cfg.logcall) != 0)
      {
         sprintf( frameWin->buf, "Invalid logging callsign: %s", cfg.logcall );
         frameWin->printFatal( frameWin->buf );
      }
   }

   if (cfg.automode)
      sLine->autoStatus( "Idle" );
   else
      sLine->autoStatus( "Disabled" );

   if (ckMBBIOS( cfg.port ))
      frameWin->printFatal( "MBBIOS detected; disable or remove for selected port" );

   // Construct connection log

   static Log log( cfg, *frameWin );

   // We always open a serial interface to the TNC.  In the simulation mode,
   // we would like to be able to demonstrate the terminal mode which
   // requires the serial interface.  We only open the file interface if we
   // are doing a simulation.

   // Construct hardware interfaces

   static ErrCallUp eCallUp( *this );

   if ((ai = new AsyncIntf( cfg.debugPortDataHex, cfg.port )) == 0)
      frameWin->printFatal( "Out of memory" );
   ai->setErrCall( eCallUp );                    // notification function
   ai->set( HwDevice::devDelay, cfg.charDelay );
   ai->set( HwDevice::devInterval, cfg.delayInterval );
   ai->setFrameWin( *frameWin );
   FileIntf* fi = 0;
   if (cfg.simulate && (fi = new FileIntf( cfg.debugPortDataHex, cfg.dlDir )) == 0)
      frameWin->printFatal( "Out of memory" );
   if (fi)
      fi->setFrameWin( *frameWin );
   if ((terminal = new Terminal( cfg.showDataHex )) == 0)
      frameWin->printFatal( "Out of memory" );
   terminal->setFrameWin( *frameWin );

   // Construct level 1 protocols

   // The maxNewBufSize parameter for constructing the Slip object must
   // be as large as the recvOutSize parameter used to open any hardware
   // interface.

   slip = new Slip( 2048, cfg.logInFrames, cfg.logOutFrames, cfg.loggingStatus );
   if (!slip)
      frameWin->printFatal( "Out of memory" );
   slip->setInfoWin( *infoWin );                 // msg output function
   slip->setLogFile( cfg.dlDir );
   slip->setErrCall( eCallUp );                  // notification function

   kiss = new Kiss( cfg.debug );
   if (!kiss)
      frameWin->printFatal( "Out of memory" );
   kiss->setFrameWin( *frameWin );
   kiss->setErrCall( eCallUp );                  // notification function

   // Construct level 3 protocols and associated objects

   // Directory broadcast manager

   dbm = new DirBcstMgr( *bcstAddr, *myAddr, *slip, *dfm, *dir, *parser, *sem,
                         *sList, cfg, *frameWin, *infoWin, *sLine );
   if (!dbm)
      frameWin->printFatal( "Out of memory" );
   dbm->setErrCall( eCallUp );                   // notification function

   // File activity list

   actList = new ActList( *fileWin, *infoWin, *frameWin, cfg.dlDir, dir, sList,
                          cfg.makeBat, cfg.bats1, cfg.bats2, cfg.silent,
                          cfg.maxPfhSize );
   if (!actList)
      frameWin->printFatal( "Out of memory" );

   // File broadcast manager

   fbm = new FileBcstMgr( cfg, *frameWin, *infoWin, *sLine, *actList, *sList,
                          *bcstAddr, *myAddr, *slip );
   if (!fbm)
      frameWin->printFatal( "Out of memory" );
   fbm->setErrCall( eCallUp );                   // notification function

   // High time manager

   hTime = new HighTime( cfg, *cLine, *frameWin );

   //  Directory download manager

   ddm = new DirDlMgr( *infoWin, *dfm, *hTime, cfg.maxPfhSize );

   // TNC manager

   tncMgr = new TncMgr( terminal, kiss, slip, (HwDevice*) ai, cfg, *frameWin );

   // Event queue

   pQ = new EventQueue( cfg, *frameWin );

   // FTL0 protocol

   ftl0 = new FTL0( cfg, *frameWin, *infoWin, *pQ, *hTime, *sList, *dir,
                    *ddm, log, ftl0User );
   if (!hTime || !ddm || !tncMgr || !pQ || !ftl0)
      frameWin->printFatal( "Out of memory" );
   if (cfg.autoUpload)
      ftl0->numToUpload = ftl0->filesToUpload(); // raise file upload flag

   // Construct the level 2 (FTL0) user.  This object class is derive from the
   // Ax25User object class.  FTL0User constructs the level 2 object
   // instances.

   ftl0User = new FTL0User( cfg, *infoWin, *frameWin, *sLine, *ftl0, *kiss,
                            *bbsAddr, *bcstAddr, *myAddr, *logAddr, log,
                            linkTable, eCallUp, *pQ, antennaControl );
   if (!ftl0User)
      frameWin->printFatal( "Out of memory" );

   // Open a passive level 2 connection on which to listen

   ftl0User->handleEvent( Event::Request_Passive, NULBUF );
   if (ftl0User->bcstAxp)
      axpr = ftl0User->bcstAxp;
   else
      frameWin->printFatal( "Can't open server" );

   // Construct the No-level-3 protocol manager

   bm = new BeaconMgr( cfg, *infoWin, *frameWin, *ftl0User, *bbsAddr,
                       *bcstAddr, *myAddr, *dbm, *fbm, *sLine, *sList );
   hnl3 = new NoL3FrameMgr( *bm );
   if (!bm || !hnl3)
      frameWin->printFatal( "Out of memory" );

   // Computer user interface manager

   userMgr = new UserMgr( cfg, *dbm, *fbm, *fileWin, *infoWin, *frameWin,
                          *cLine, *sLine, screenCount, *ftl0User, *hTime,
                          *terminal, *ftl0, *sList, *tncMgr, *actList, *dir,
                          *exitAfterTimer, *pQ, *help );

   if (cfg.screenMode == UserMgr::Review_Directory)
      userMgr->processKey( 'v' );
   if (cfg.screenMode == UserMgr::No_File_Window)
      userMgr->processKey( 26 );

   // Link the lower protocols layers.

   // NOTE: If you delete the "axpr" instance of the Ax25 object, you should
   // first unlink the kiss instance.  Otherwise is will send frames to a
   // non-existant instance.  In this program implementation, axpr should
   // exist until ftl0User is deleted.

   terminal->link( *ai );                        // should always be async
   ai->link( *slip );
   slip->link( *ai, *kiss );
   kiss->link( *slip, *axpr );                   // Link from axpr already done
   fbm->link( axpr );
   dbm->link( axpr );

   // Load the link table from level 2 to level 3

   linkTable.insert( *fbm,  Ax25::PID_BCSTFILE );
   linkTable.insert( *dbm,  Ax25::PID_BCSTDIR  );
   linkTable.insert( *hnl3, Ax25::PID_NO_L3    );

   // Execute protocol initializing functions.  Perform these functions after
   // the protocols are linked

   if (ai->open( 4096, 2048, cfg.portIrq, cfg.portAddr, 2048 ) != 0  ||
      ai->params( cfg.speed, cfg.parity, cfg.databits, cfg.stopbits ) != 0)
//      ai->params1( cfg.speed, cfg.parity, cfg.databits, cfg.stopbits ) != 0)
      frameWin->printFatal( "Error initializing serial port to TNC" );
   if (fi && fi->open() != 0)                    // if input simulation
      frameWin->printFatal( "Error opening simulation input file" );
   tncMgr->initialize();
   if (cfg.simulate)                             // if input simulation
   {                                             //   change protocol links
      dev = (HwDevice*) fi;                      // use file interface
      fi->link( *slip );                         // link fi to slip
      slip->link( *fi, *kiss );                  // reset slip link to fi
   }
   else                                          //  otherwise use async
      dev = (HwDevice*) ai;                      //  interface for data input

   sLine->currentMode( tncMgr->tncMode );        // display current mode

   // Initialize the OrbitDRV interface

   antennaControl.initialize( cfg.orbitDrvInterrupt );

   if (cfg.simulate)
   {
      cfg.logInFrames = 0;
      cfg.logOutFrames = 0;
   }
}

void SatLink::terminate()
// --------------------------------------------------------------------------
//  Terminate all program functions
// --------------------------------------------------------------------------
{
  //Terminate functions

   actList->purgeOldFiles( cfg.dlDir, cfg.actDays, sList ); // purge old .ACT files
   if (cfg.purgeN)                               // purge NEVER files
      actList->purgeFiles( cfg.dlDir );
   delete actList;

   sList->unload();                              // save file status list

   if (cfg.simulate)                             // if input simulation
      slip->link( *ai, *kiss );                  // reset slip link to ai
   tncMgr->terminate();                          // reset TNC functions

   print();                                      // print counters
   fcloseall();                                  // close all open files

   // Call the destructors

   Timer::showTimerActivity = 0;
   delete dbm;
   delete ftl0User;
   delete parser;                                // syntax analyzer
   delete sem;                                   // semantic analyzer
   delete slip;
   slip = 0;
   delete dir;
   delete help;

   // Do not delete the hardware device at this point.  It is deleted in the
   // "SatLink::pgmExit" function.

}

void SatLink::ctrlc_handler( int )
// --------------------------------------------------------------------------
//  Handle control-c and control-break interrupts
// --------------------------------------------------------------------------
{
   signal( SIGINT, SIG_IGN );                    // ignore further SIGINT
   if (satLink->tncMgr->tncMode == TncMgr::TermMode)
   {
      satLink->frameWin->printALFD( "\r" );      // reset print function
      satLink->ai->send( "\x03\r", 2 );          // sent ^C to TNC
      signal( SIGINT, ctrlc_handler );           // reset intercept
   }
   else
   {
      satLink->frameWin->print( "Program aborted" );
      satLink->terminate();
      exit( 1 );
   }
}

void SatLink::pgmExit()
// --------------------------------------------------------------------------
//  Program exit routine
// --------------------------------------------------------------------------
{
   fcloseall();
   if ((HwDevice *)satLink->dev != (HwDevice *)satLink->ai) // if device is allocated
      delete satLink->dev;                       // delete it
   delete satLink->ai;                           // must always delete the
                                                 // interface because it is
                                                 // always used, even for
                                                 // simulations

   // If all the dynamically allocated Timers are not deleted, then our
   // tick timer ISR is still hooked.  We must ALWAYS remove the hook or
   // the system will crash.  Call this function just to be safe.

   Timer::removeISR();

   _setcursortype( _NORMALCURSOR );
   textbackground( BLUE );
   textcolor( WHITE );
}

ErrCallUp::ErrCallUp( Object& obj ) : CallUp( obj )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void ErrCallUp::func() const
// -------------------------------------------------------------------------
// Error call up function
// -------------------------------------------------------------------------
{
   ((SatLink&) obj).sLine->errorTotal( (unsigned long) ((SatLink&) obj).slip->sendErrCnt +
                                                       ((SatLink&) obj).slip->recvErrCnt +
                                                       ((SatLink&) obj).kiss->recvErrCnt +
                                                       ((SatLink&) obj).axpr->recvErrCnt +
                                                       ((SatLink&) obj).dbm->recvErrCnt +
                                                       ((SatLink&) obj).fbm->recvErrCnt +
                                                       ((SatLink&) obj).ai->errCnt() );
}

