//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FTL0_H
#include "ftl0.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  _IO_H
#include <io.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __AX25USER_H
#include "ax25User.h"
#endif

#ifndef  __FTL0PKT_H
#include "ftl0pkt.h"
#endif

#ifndef  __FTL0USER_H
#include "ftl0user.h"
#endif

#ifndef  __GETUE_H
#include "getue.h"
#endif

#ifndef  __LOG_H
#include "log.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __QUEUE_H
#include "queue.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

void FTL0::throughput()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (bytesUploaded)
   {
      unsigned long interval = lastSentTime - startTime;
      if (interval < 1000)
         interval = 1000;
      sprintf( frWin.buf, "Throughput : %lu @ %.0f bytes/sec",
               bytesUploaded, bytesUploaded * (1000.0 / interval) );
      log.write( frWin.buf );
      frWin.print( frWin.buf );
      bytesUploaded = 0;
   }
}

void FTL0::handleUlEvent( int eventType, FTL0Pkt& pkt )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   static char* server_file_name;
          char* new_file_name;

   int oldState = ulState;
   switch (ulState)
   {
      case UL_UNINIT:
         switch (eventType)
         {
            case Event::Rcv_LOGIN_RESP:
               ulState = UL_CMD_OK;
               break;
            default:
               break;                            // ignore, login incomplete
         }
         break;

      case UL_CMD_OK:
         bytesUploaded = 0;
         switch (eventType)
         {
            case Event::User_Requests_Upload:
               log.write( "UPLOAD" );
               transmit( UL_CMD );
               ulState = UL_WAIT;
               break;
            case Event::Data_Link_Terminated:
               ulState = UL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               ulState = UL_UNINIT;
         }
         break;

      case UL_WAIT:
         switch (eventType)
         {
            case Event::User_Requests_Upload:
               break; // ignore
            case Event::Rcv_UL_GO_RESP:
               log.write( "Upload accepted" );
               frWin.print( "Upload accepted" );

               serverFileNumber = *((unsigned long *)(pkt.c + 2));
               byteOffset = *((unsigned long *)(pkt.c + 6));

               sprintf( frWin.buf, "File number : %#lx", serverFileNumber );
               log.write( frWin.buf );
               frWin.print( frWin.buf );

               if (strstr( ulFileName, ".PUL" )) // if we're trying again
               {
                  sprintf( frWin.buf, "Continue offset : %-lu", byteOffset );
                  log.write( frWin.buf );
                  frWin.print( frWin.buf );
               }

               server_file_name = new char[ MAXPATH ];
               sprintf( server_file_name, "%s%-lx.PUL",
                                         cfg.ulDir, serverFileNumber );

               // If the file is not .PUL, then rename it.  The file would
               // already be .PUL if upload had previously initiated.

               if (stricmp( ulFileName, server_file_name ))
               {
                  rename( ulFileName, server_file_name );
                  if (cfg.debug)
                  {
                     sprintf( frWin.buf, "Renamed %s to %s",
                                      ulFileName, server_file_name );
                     frWin.print( frWin.buf );
                  }
               }
               if ((ulFile = fopen( server_file_name, "rb" )) == 0)
               {
                  sprintf( frWin.buf, "hdlule : error opening file %s",
                                   server_file_name );
                  frWin.print( frWin.buf );
                  delete server_file_name;
                  ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
                  ulState = UL_UNINIT;
                  break;
               }
               ulState = UL_DATA;
               tCall();
               break;
            case Event::Rcv_UL_ERROR_RESP:
               switch (pkt.c[2])               // error code
               {
                  case ER_BAD_CONTINUE:
                  case ER_NO_SUCH_FILE_NUMBER:
                     new_file_name = new char[ MAXPATH ];
                     strcpy( new_file_name, ulFileName );
                     memcpy( new_file_name + strlen( new_file_name ) - 3,
                             "XUL", 3 );         // change file extension
                     rename( ulFileName, new_file_name );
                     delete new_file_name;
                     break;
                  case ER_FILE_COMPLETE:
                     new_file_name = new char[ MAXPATH ];
                     strcpy( new_file_name, ulFileName );
                     memcpy( new_file_name + strlen( new_file_name ) - 3,
                             "UL\x0", 3 );       // change file extension
                     if (rename( ulFileName, new_file_name ) != 0)
                     {
                        sprintf( frWin.buf, "error renaming <%s> to *.UL, %s; "
                                            "target filename may already exit",
                                            ulFileName, sys_errlist[ errno ] );
                        frWin.printFatal( frWin.buf );
                     }
                     delete new_file_name;
                     break;
                  case ER_NO_ROOM:
                     ;
               }
               ulState = UL_CMD_OK;
               if ((numToUpload = filesToUpload()) != 0)
                  ftl0User->handleEvent( Event::User_Requests_Upload, NULBUF ); // recursive
               break;
            case Event::Data_Link_Terminated:
               ulState = UL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               ulState = UL_UNINIT;
         }
         break;

      case UL_DATA:
         switch (eventType)
         {
            case Event::User_Requests_Upload:
               break; // ignore
            case Event::Rcv_UL_NAK_RESP:
               fclose( ulFile );
               transmit( DATA_END );
               switch (pkt.c[2])                  // error code
               {
                  case ER_BAD_HEADER:
                  case ER_HEADER_CHECK:
                  case ER_BODY_CHECK:
                     new_file_name = new char[ MAXPATH ];
                     sprintf( new_file_name, "%s%-lx.XUL",
                                            cfg.ulDir, serverFileNumber );
                     rename( server_file_name, new_file_name );
                     delete server_file_name;
                     delete new_file_name;
                     break;
                  case ER_NO_ROOM:
                     ;
               }
               throughput();
               ulState = UL_CMD_OK;
               if ((numToUpload = filesToUpload()) != 0)
                  ftl0User->handleEvent( Event::User_Requests_Upload, NULBUF );  // recursive
               break;
            case Event::Data_Link_Terminated:
               fclose( ulFile );
               throughput();
               ulState = UL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               fclose( ulFile );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               throughput();
               frWin.print( "handleUlEvent : unexpected event" );
               ulState = UL_UNINIT;
         }
         break;

      case UL_END:
         switch (eventType)
         {
            case Event::User_Requests_Upload:
               break; // ignore
            case Event::Rcv_UL_ACK_RESP:
               log.write( "Upload successful" );
               frWin.print( "Upload successful" );
               throughput();
               new_file_name = new char[ MAXPATH ];
               sprintf( new_file_name, "%s%-lx.UL", cfg.ulDir, serverFileNumber );
               rename( server_file_name, new_file_name );
               delete server_file_name;
               delete new_file_name;
               ulState = UL_CMD_OK;
               if ((numToUpload = filesToUpload()) != 0)
                  ftl0User->handleEvent( Event::User_Requests_Upload, NULBUF );  // recursive
               break;
            case Event::Rcv_UL_NAK_RESP:
               switch (pkt.c[2])                  // error code
               {
                  case ER_BAD_HEADER:
                  case ER_HEADER_CHECK:
                  case ER_BODY_CHECK:
                     new_file_name = new char[ MAXPATH ];
                     sprintf( new_file_name, "%s%-lx.XUL",
                                             cfg.ulDir, serverFileNumber );
                     rename( server_file_name, new_file_name );
                     delete server_file_name;
                     delete new_file_name;
                     log.write( "Renamed upload file to *.XUL" );
                     break;
                  case ER_NO_ROOM:
                     ;
               }
               ulState = UL_CMD_OK;
               if ((numToUpload = filesToUpload()) != 0)
                  ftl0User->handleEvent( Event::User_Requests_Upload, NULBUF );  // recursive
               break;
            case Event::Data_Link_Terminated:
               throughput();
               ulState = UL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               ulState = UL_UNINIT;
         }
   }
   if (cfg.debug && ulState != oldState)
   {
      const char *stateStr[5]   = {"UL_UNINIT   ",
                                    "UL_CMD_OK   ",
                                    "UL_WAIT     ",
                                    "UL_DATA     ",
                                    "UL_END      "};
      sprintf( frWin.buf, "[UL_OLD : %s] [UL_NEW : %s]",
               stateStr[ oldState ], stateStr[ ulState ] );
      log.write( frWin.buf );
      frWin.print( frWin.buf );
   }
}

void FTL0::tCall()
// --------------------------------------------------------------------------
//  Transmit function.  Call this function when data can be sent.
// --------------------------------------------------------------------------
{
   if (ulState != UL_DATA)
      return;
   maxBytesToSend = ftl0User->bbsAxp->bytesToSend();
   if (byteOffset < filelength( fileno( ulFile ) ))
   {                                            // we have data to send
      if (transmit( DATA ) != 0)
      {
         fclose( ulFile );
         ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
         ulState = UL_UNINIT;
      }
   }
   else                                          // we've sent all the data
   {
      transmit( DATA_END );
      fclose( ulFile );
      ulState = UL_END;
   }
}

XmitCallUp::XmitCallUp( Object& obj ) : CallUp( obj )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void XmitCallUp::func() const
// -------------------------------------------------------------------------
// FTL0 transmit call up function
// -------------------------------------------------------------------------
{
   ((FTL0&) obj).tCall();
}

