//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FTL0_H
#include "ftl0.h"
#endif

#ifndef  _IO_H
#include <io.h>
#endif

#ifndef  __CHGHIGH_H
#include "chghigh.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __DIRDL_H
#include "dirdl.h"
#endif

#ifndef  __DIRECTRY_H
#include "directry.h"
#endif

#ifndef  __FTL0PKT_H
#include "ftl0pkt.h"
#endif

#ifndef  __FTL0USER_H
#include "ftl0user.h"
#endif

#ifndef  __AX25USER_H
#include "ax25User.h"
#endif

#ifndef  __LOG_H
#include "log.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __QUEUE_H
#include "queue.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

void FTL0::handleDlEvent( int eventType, FTL0Pkt& pkt )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   static int      select_count = 0;

   int oldState = dlState;
   char* old_name;
   char* new_name;
   switch (dlState)
   {
      case DL_UNINIT:
         switch (eventType)
         {
            case Event::Rcv_LOGIN_RESP:
               dlState = DL_CMD_OK;
               break;
            default:
               break;                            // ignore, login incomplete
         }
         break;

      case DL_CMD_OK:
         switch (eventType)
         {
            case Event::User_Requests_Download:
               log.write( "DOWNLOAD" );
               transmit( DL_CMD );
               dlState = DL_WAIT;
               break;
            case Event::User_Requests_Directory:
               log.write( "DIRECTORY" );
               if (dirLen == LONG)
                  transmit( DIR_LONG_CMD );
               else
                  transmit( DIR_SHORT_CMD );
               dlState = DL_DIR_WAIT;
               break;
            case Event::User_Requests_Selection:
               log.write( "SELECT" );
               transmit( SELECT_CMD );
               dlState = DL_SEL;
               break;
            case Event::User_Requests_Abort:     // note: fall through
               log.write( "ABORT" );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
            case Event::Data_Link_Terminated:
               dlState = DL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               dlState = DL_UNINIT;
         }
         break;

      case DL_WAIT:
         switch (eventType)
         {
            case Event::User_Requests_Download:
            case Event::User_Requests_Directory:
            case Event::User_Requests_Selection:
               break; // ignore
            case Event::Rcv_DL_ERROR_RESP:
               dlState = DL_CMD_OK;
               break;
            case Event::Rcv_DATA:
               storeData( pkt );
               dlState = DL_DATA;
               break;
            case Event::Rcv_DATA_END:
               if (fileOK())
               {
                  // change the filename extension
                  char* old_name = new char[ MAXPATH ];
                  char* new_name = new char[ MAXPATH ];
                  sprintf( old_name, "%s%-lx.PDL", cfg.dlDir, dlFileNumber );
                  sprintf( new_name, "%s%-lx.DL", cfg.dlDir, dlFileNumber );
                  rename( old_name, new_name );
                  delete old_name;
                  delete new_name;
                  sList.set( dlFileNumber, sList.DOWNLOADED );
                  dir.setStatus( dlFileNumber, sList.DOWNLOADED );
                  transmit( DL_ACK_CMD );
               }
               else
                  // incomplete file; leave with .PDL extension
                  transmit( DL_NAK_CMD );
               close( dlFile );
               dlState = DL_END;
               break;
            case Event::User_Requests_Abort:     // note: fall through
               log.write( "ABORT" );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
            case Event::Data_Link_Terminated:
               close( dlFile );
               dlState = DL_UNINIT;
               break;
            default:
               close( dlFile );
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               dlState = DL_UNINIT;
         }
         break;

      case DL_DATA:
         switch (eventType)
         {
            case Event::User_Requests_Download:
            case Event::User_Requests_Directory:
            case Event::User_Requests_Selection:
               break; // ignore
            case Event::Rcv_DATA:
               storeData( pkt );
               dlState = DL_DATA;
               break;
            case Event::Rcv_DATA_END:
               if (fileOK())
                  transmit( DL_ACK_CMD );
               else
                  transmit( DL_NAK_CMD );
               close( dlFile );
               dlState = DL_END;
               break;
            case Event::User_Requests_Abort:
               log.write( "ABORT" );
               close( dlFile );
               transmit( DL_NAK_CMD );
               dlState = DL_ABORT;
               break;
            case Event::Data_Link_Terminated:
               close( dlFile );
               dlState = DL_UNINIT;
               break;
            default:
               close( dlFile );
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               dlState = DL_UNINIT;
         }
         break;

      case DL_END:
         switch (eventType)
         {
            case Event::User_Requests_Download:
            case Event::User_Requests_Directory:
            case Event::User_Requests_Selection:
               break; // ignore
            case Event::Rcv_DL_ABORTED_RESP:
               dlState = DL_CMD_OK;
               break;
            case Event::Rcv_DL_COMPLETED_RESP:
               log.write( "Down successful" );
               frWin.print( "Down successful" );
               old_name = new char[ MAXPATH ];
               new_name = new char[ MAXPATH ];
               sprintf( old_name, "%s%-lx.PDL", cfg.dlDir, dlFileNumber );
               sprintf( new_name, "%s%-lx.DL", cfg.dlDir, dlFileNumber );
               rename( old_name, new_name );
               delete old_name;
               delete new_name;
               dlState = DL_CMD_OK;
               sList.set( dlFileNumber, sList.DOWNLOADED );
               dir.setStatus( dlFileNumber, sList.DOWNLOADED );
               break;
            case Event::User_Requests_Abort:            // note: fall through
               log.write( "ABORT" );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
            case Event::Data_Link_Terminated:
               dlState = DL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               dlState = DL_UNINIT;
         }
         break;

      case DL_ABORT:
         switch (eventType)
         {
            case Event::User_Requests_Download:
            case Event::User_Requests_Directory:
            case Event::User_Requests_Selection:
              break;  // ignore
            case Event::Rcv_DATA:
               dlState = DL_ABORT;
               break;
            case Event::Rcv_DATA_END:
               dlState = DL_END;
               break;
            case Event::User_Requests_Abort:     // note: fall through
               log.write( "ABORT" );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
            case Event::Data_Link_Terminated:
               dlState = DL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               dlState = DL_UNINIT;
         }
         break;

      case DL_DIR_WAIT:
         switch (eventType)
         {
            case Event::User_Requests_Download:
            case Event::User_Requests_Directory:
            case Event::User_Requests_Selection:
               break; // ignore
				case Event::Rcv_DATA :
				{
					int timeChanged = ddm.receive( pkt );
					if (timeChanged)
						hTime.update( selScope, cfg.workDir );
					dlState = DL_DIR_DATA;
					break;
				}
            case Event::Rcv_DL_ERROR_RESP:
               dlState = DL_CMD_OK;
               break;
            case Event::User_Requests_Abort:            // note: fall through
               log.write( "ABORT" );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
            case Event::Data_Link_Terminated:
               dlState = DL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               dlState = DL_UNINIT;
         }

      case DL_DIR_DATA:
         switch (eventType)
         {
            case Event::User_Requests_Download:
            case Event::User_Requests_Directory:
            case Event::User_Requests_Selection:
               break; // ignore
				case Event::Rcv_DATA:
				{
					int timeChanged = ddm.receive( pkt );
					if (timeChanged)
						hTime.update( selScope, cfg.workDir );
					dlState = DL_DIR_DATA;
					break;
				}
				case Event::Rcv_DATA_END:
               if (select_count > 0)
               {
                  select_count -= 10;
                  handleDlEvent( Event::User_Requests_Directory, NULPKT ); // recursive
               }
               else
                  hTime.updateToCurrentTime( selScope, cfg.workDir );
               dlState = DL_CMD_OK;
               break;
            case Event::User_Requests_Abort:     // doesn't terminate link
               log.write( "ABORT" );
               transmit( DL_NAK_CMD );
               select_count = 0;
               break;
            case Event::Data_Link_Terminated:
               dlState = DL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               dlState = DL_UNINIT;
         }
         break;

      case DL_SEL:
         switch (eventType)
         {
            case Event::User_Requests_Download:
            case Event::User_Requests_Directory:
            case Event::User_Requests_Selection:
               break; // ignore
            case Event::Rcv_DL_ERROR_RESP:
               dlState = DL_CMD_OK;
               break;
            case Event::Rcv_SELECT_RESP:
               select_count = *((unsigned*)(pkt.c + 2));
               sprintf( frWin.buf, "Selected %i files.", select_count );
               frWin.printColor( cfg.highlight2Fg, cfg.highlight2Bg, frWin.buf );
               if (select_count <= 0)
               {
                  hTime.updateToCurrentTime( selScope, cfg.workDir );
                  pQ.flush();                    // remove pending event
               }
               else
               {
                  select_count -= 10;            // server handles 10/rqst
                  Event e2;
                  if (pQ.next( &e2.i, &e2.m ))  // could be any FTL0 event
                     ftl0User->handleEvent( e2.i, *((MBuf*)e2.m) );
               }
               dlState = DL_CMD_OK;
               break;
            case Event::User_Requests_Abort:     // note: fall through
               log.write( "ABORT" );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
            case Event::Data_Link_Terminated:
               dlState = DL_UNINIT;
               break;
            default:
               Event::display( eventType, frWin, cfg );
               ftl0User->handleEvent( Event::Request_Disconnect, NULBUF );
               dlState = DL_UNINIT;
         }
   }
   if (cfg.debug && dlState != oldState)
   {
      const char* stateStr[9]   = {"DL_UNINIT   ",
                                   "DL_CMD_OK   ",
                                   "DL_WAIT     ",
                                   "DL_DATA     ",
                                   "DL_END      ",
                                   "DL_ABORT    ",
                                   "DL_DIR_WAIT ",
                                   "DL_SEL      ",
                                   "DL_DIR_DATA "};
      sprintf( frWin.buf, "[DL_OLD : %s] [DL_NEW : %s]",
                          stateStr[ oldState ], stateStr[ dlState ] );
      log.write( frWin.buf );
      frWin.print( frWin.buf );
   }
}

int FTL0::storeData( FTL0Pkt& pkt )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   int   result;
   float percent;

   if (tell( dlFile ) == 0 &&                    // get filesize at beginning
       (dlFileSize = ddm.getFileSize( pkt.c, pkt.l )) == 0 )
   {
      sprintf( frWin.buf, "storeData : error in header file size for file %-lx",
                          dlFileNumber );
      frWin.print( frWin.buf );
      return 1;
   }
   if ((result = write( dlFile, pkt.c + 2, pkt.l-2 )) != pkt.l-2)
   {
      sprintf( frWin.buf, "store_data *** error writing to %-lx; %i out of %u"
                          " chars written",
                          dlFileNumber, result, pkt.l - 2 );
      frWin.print( frWin.buf );
      return 1;
   }
   percent = 100.0*tell( dlFile )/dlFileSize;
   sprintf( frWin.buf, "Download of %-lx is now %li %lu %8.1f%% complete",
                       dlFileNumber, tell( dlFile ), dlFileSize,
                       percent );
   frWin.print( frWin.buf );
   return 0;
}


int FTL0::fileOK()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   // check file-header file size against actual file size

   lseek( dlFile, 0, SEEK_SET );                 // go to beginning
   char* dir = new char[ 256 ];
   int code;
   int len;
   if ((len = read( dlFile, dir, 255 )) < 0)
   {
      sprintf( frWin.buf, "file_OK : read error for file %-lx", dlFileNumber );
      code = 0;
   }
   else
   {
      dlFileSize = ddm.getFileSize( dir, len );
      if (dlFileSize == filelength( dlFile ))
      {
         sprintf( frWin.buf, "Download of file %-lx was successful",
                             dlFileNumber );
         code = 1;
      }
      else
      {
         sprintf( frWin.buf, "Download of file %-lx was NOT successful\r\n"
                             "Header file size / actual file size: %lu / %lu",
                             dlFileNumber, dlFileSize, filelength( dlFile ) );
         code = 0;
      }
   }
   frWin.print( frWin.buf );
   delete dir;
   return code;
}
