//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// This file contains "get user events" functions.

#ifndef  __GETUE_H
#include "getue.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __CTYPE_H
#include <ctype.h>           // isxdigit()
#endif

#ifndef  __DIR_H
#include <dir.h>
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __ACTLIST_H
#include "actlist.h"
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CHGHIGH_H
#include "chghigh.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __DIRBCST_H
#include "dirbcst.h"
#endif

#ifndef  __DIRECRTY_H
#include "directry.h"
#endif

#ifndef  __FILEBCST_H
#include "filebcst.h"
#endif

#ifndef  __FTL0_H
#include "ftl0.h"
#endif

#ifndef  __FTL0USER_H
#include "ftl0User.h"
#endif

#ifndef  __HELP_H
#include "help.h"
#endif

#ifndef  __LAPB_H
#include "lapb.h"
#endif

#ifndef  __MISC_H
#include "misc.h"
#endif

#ifndef  __TNCMGR_H
#include "tncmgr.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __QUEUE_H
#include "queue.h"
#endif

#ifndef  __SATLINK_H
#include "satlink.h"
#endif

#ifndef  __SCRWRITE_H
#include "scrwrite.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __TERMINAL_H
#include "terminal.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

#ifndef  __WIN_H
#include "win.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

UserMgr::UserMgr( Config&      cfg,
                  DirBcstMgr&  dbm,
                  FileBcstMgr& fbm,
                  Window&      fiWin,
                  Window&      iWin,
                  Window&      frWin,
                  CmdLine&     cLine,
                  StatusLine&  sLine,
                  int&         screenCount,
                  FTL0User&    ftl0User,
                  HighTime&    hTime,
                  Terminal&    terminal,
                  FTL0&        ftl0,
                  StatusList&  sList,
                  TncMgr&      tnc,
                  ActList&     actList,
                  Directory&   dir,
                  Timer&       exitAfterTimer,
                  EventQueue&  pQ,
                  Help&        help )
                :
                  cfg( cfg ),
                  dbm( dbm ),
                  fbm( fbm ),
                  fiWin( fiWin ),
                  ftl0( ftl0 ),
                  iWin( iWin ),
                  frWin( frWin ),
                  cLine( cLine ),
                  sLine( sLine ),
                  screenCount( screenCount ),
                  ftl0User( ftl0User ),
                  hTime( hTime ),
                  terminal( terminal ),
                  sList( sList ),
                  tnc( tnc ),
                  actList( actList ),
                  dir( dir ),
                  exitAfterTimer( exitAfterTimer ),
                  pQ( pQ ),
                  help( help ),
                  lastCommand( Event::No_Event ),
                  state( Normal )
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
{}

UserMgr::~UserMgr()
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
{}

void UserMgr::bcstCommand( unsigned command )
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
{
   lastCommand = command;
   switch( command )
   {
      case Event::User_Requests_Fill_Dir :
         iWin.print( "Man: Requesting directory fill." );
         dbm.rqstFill();
         break;
      case Event::User_Requests_Begin_File:
         sprintf( iWin.buf, "Man: Begin file %-lx.", fbm.bcstFileNumber);
         iWin.print( iWin.buf );
         fbm.send( fbm.BEGIN_BCST_CMD );
         break;
      case Event::User_Requests_Stop_File:
         sprintf( iWin.buf, "Man: Stop file %-lx.", fbm.bcstFileNumber);
         iWin.print( iWin.buf );
         fbm.send( fbm.STOP_BCST_CMD );
         break;
      case Event::User_Requests_Fill_File:
         sprintf( iWin.buf, "Man: Fill file %-lx, %u byte frames.",
                  fbm.bcstFileNumber, cfg.bcstPaclen );
         iWin.print( iWin.buf );
         fbm.send( fbm.FILL_FILE_CMD );
         break;
   }
}

int UserMgr::getFileNumber( char*          cp,
                            char           key,
                            unsigned long* file_number,
                            CmdLine&       cLine )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   static int  erase_file_str = 1;
   static char last_str[11] = {0};
   static char file_str[11] = {0};
   char               *endptr;

   switch (key)
   {
      case 13:                                   // CR
         erase_file_str = 1;                     // Reset the zap flag
         if (strlen( file_str ) == 0)            // if no input
            if (*file_number != 0)               //   if previous entry
               return 0;                         //      then use it
            else                                 //   else
               return 2;                         //      abort
         strcpy( last_str, "0x" );               // Add 0x prefix for
         strcat( last_str, file_str );           //   conversion
         *file_number = strtoul( last_str, &endptr, 16 );
         return 0;                               // Say we're done
      case 27:
         erase_file_str = 1;                     // Reset the zap flag
         return 2;                               // Say we cancelled
      default:                                   // Anything else
         if (erase_file_str)                     // Zap string to start
         {
            file_str[0] = 0;
            if (*file_number != 0)
               ultoa( *file_number, last_str, 16 );
            else
               last_str[0] = 0;
            erase_file_str = 0;
         }
         if (key == 8)                           // Backspace
            if (strlen( file_str ) > 0)
               file_str[strlen( file_str )-1] = 0;
            else
               ;
         else                                    // Make sure its hex
            if (isxdigit( key ) && strlen( file_str ) < 8)
               charcat( file_str, key );         // Concatenate character
         cLine.msg( cp, *file_number, file_str );// display it
         return 1;                               // Say keep going
   }
}

void UserMgr::kbRecv()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   int key;
   if (kbhit())
   {
      key = getch();                    // Get keyboard event
      if (key == 0)
         key = getch() + 128;
   }
   else
      return;

   if (cfg.simulate && key == 153)               // Alt-p - pause simulation
   {
      while (!kbhit());
      return;
   }
   processKey( key );
}

void UserMgr::processKey( const int key )
// --------------------------------------------------------------------------
   // Process keyboard event
// --------------------------------------------------------------------------
{
   enum Commands { Begin, Download, Fill, Automatic, Grab, Priority, Never,
                   OneDirectory, Stop};
   static enum Commands          command;
   static unsigned long          fileNumber = 0;
   static char*                  select = 0;
   static enum StatusList::sCode status;   
   static char*                  commandString = 0;
   static Window*                tWin = 0;
   static unsigned               len = 0;
   static int                    code = SatLink::USEREXIT;

   switch (state)
   {
      case Normal:
         switch (key)
         {
            case 1 :         // Ctrl-a
               ftl0User.toggleAutomode();
               break;
//          case 176:        // Alt-b
//             Send_Break;
//             break;
            case   7:        // Ctrl-g
               cfg.grabAll = !cfg.grabAll;
               info();
               break;
            case 163:        // Alt-h
               saveScreen();
               hTime.adjust( 0 );
               state = Hightime_Adjust;
               break;
//          case 164:        // Alt-j
//             if (!axp || axp->state == Disconnected)
//             exec_DOS ('SATLINK');
//             break;
            case 11 :        // Ctrl-k
               if (cfg.loggingStatus)
                  cfg.loggingStatus = 0;
               else
               {
                  cfg.loggingStatus = 1;
                  if (!cfg.logInFrames && !cfg.logOutFrames &&
                      !cfg.logDirFrames && !cfg.logFileFrames &&
                      cfg.logcall[ 0 ] == 0)
                     cfg.logInFrames = 1;
               }
               info();
               break;
            case 166:        // Alt-l
               Window::toggleCapture();
               if (Window::capture)
                  iWin.print( "Capture file opened" );
               else
                  iWin.print( "Capture file closed" );
               break;
//          case 153:        // Alt-p
//             Printer_Toggle;
//             break;
            case 144:        // Alt-q
            {
               static unsigned long saveIdleExitTime = 0;
               if (exitAfterTimer.getState() == Timer::Started)
               {
                  exitAfterTimer.stop();
                  exitAfterTimer.set( 0 );
                  iWin.print( "exitAfterTimer stopped" );
               }
               else
               {
                  exitAfterTimer.set( cfg.exitAfterMs );
                  exitAfterTimer.start();
                  iWin.print( "exitAfterTimer started" );
               }
               if (cfg.idleExitTime)
               {
                  saveIdleExitTime = cfg.idleExitTime;
                  cfg.idleExitTime = 0;
                  iWin.print( "idleExitTime canceled" );
               }
               else
                  if (saveIdleExitTime)
                  {
                     cfg.idleExitTime = saveIdleExitTime;
                     iWin.print( "idleExitTime reinstated" );
                  }
               break;
            }
            case 20 :        // Ctrl-t
               cfg.trace = !cfg.trace;
               info();
               break;
            case 24 :        // Ctrl-x
               cfg.showDataHex = !cfg.showDataHex;
               info();
               break;
            case  26 :       // Ctrl-z
               if (frWin.zoomed)
               {
                  restoreScreen( 2 );
                  frWin.zoom();
               }
               else
               {
                  saveScreen();
                  frWin.state = Window::Visible;
                  frWin.zoom();
               }
               break;
            case 257:        // Alt-0
               cfg.debug = 0;
               iWin.print( "Debugging is 0" );
               break;
            case 248:        // Alt-1
               cfg.debug = 1;
               iWin.print( "Debugging is 1" );
               break;
            case 249:        // Alt-2
               cfg.debug = 2;
               iWin.print( "Debugging is 2" );
               break;
            case 250:        // Alt-3
            {
               cfg.debug = 3;
               iWin.print( "Debugging is 3" );
               break;
            }
            case 187:        // F1
               saveScreen();
               if (help.processKey( "*MAIN", 0 ))
                  state = MainHelp;
               break;
//          case 189:       // F3
            default:
               switch (tnc.tncMode)
               {
                  case tnc.KissMode :
                     switch (key)
                     {
                        case  27:       // Esc
                           if (cfg.autoUpload)
                              frWin.print( "Automatic uploading deactivated" );
                           cfg.autoUpload = 0;
                           ftl0User.handleEvent( Event::User_Requests_Abort, NULBUF );
                           break;
                        case  13:       // CR
                           break;
                        case 158:       // Alt-a
                           strcpy( ftl0.selScope, "ALL" );
                           ftl0User.handleEvent( Event::Request_Connect, NULBUF );
                           pQ.add( Event::User_Requests_Selection, 0 );
                           pQ.add( Event::User_Requests_Directory, 0 );
                           break;
                        case 'a':       // a
                        case 'A':       // Shift-a
                           command = Automatic;
                           status = sList.AUTOMATIC;
                           select = "Auto";
                           fileNumber = fbm.bcstFileNumber;
                           cLine.msg( select, fileNumber, "\x0" );
                           state = FileSelect;
                           break;
                        case 176:       // Alt-b
                           strcpy( ftl0.selScope, "BUL" );
                           ftl0User.handleEvent( Event::Request_Connect, NULBUF );
                           pQ.add( Event::User_Requests_Selection, 0 );
                           pQ.add( Event::User_Requests_Directory, 0 );
                           break;
                        case 'b':
                        case 'B':       // Shift-b
                           command = Begin;
                           select = "Begin";
                           fileNumber = fbm.bcstFileNumber;
                           cLine.msg( select, fileNumber, "\x0" );
                           state = FileSelect;
                           break;
                        case 'd':       // d
                           bcstCommand( Event::User_Requests_Fill_Dir );
                           break;
                        case 160:       // Alt-d - download a file
                           command = Download;
                           select = "Download";
                           fileNumber = ftl0.dlFileNumber;
                           cLine.msg( select, fileNumber, "\x0" );
                           state = FileSelect;
                           break;
                        case 4:         // Ctrl-d
                           cfg.showData = !cfg.showData;
                           info();
                           break;
                        case 'e':       // e
                        case 'E':       // Shift-e
                           exitInfo( cfg.exitAfterMs, cfg.abortTime,
                                     cfg.idleExitTime );
                           break;
                        case 'f':       // f
                        case 'F':       // Shift-f
                           command = Fill;
                           select = "Fill";
                           fileNumber = fbm.bcstFileNumber;
                           cLine.msg( select, fileNumber, "\x0" );
                           state = FileSelect;
                           break;
                        case 'g':       // g
                        case 'G':       // Shift-g
                           command = Grab;
                           status = sList.GRAB;
                           select = "Grab";
                           fileNumber = fbm.bcstFileNumber;
                           cLine.msg( select, fileNumber, "\x0" );
                           state = FileSelect;
                           break;
                        case 'h' :      // h
                        case 'H' :      // Shift-h
                           saveScreen();
                           if (help.processKey( "*MAIN", 0 ))
                              state = MainHelp;
                           break;
                        case 8 :         // Ctrl-h, Backspace
                           cfg.showHeaders = !cfg.showHeaders;
                           info();
                           break;
                        case 'i':       // i
                        case 'I':       // Shift-i
                           info();
                           break;
                        case 'l':
                        case 'L':
                           sList.displayRequested();
                           break;
                        case 178:       // Alt-m
                           strcpy( ftl0.selScope, "MY" );
                           ftl0User.handleEvent( Event::Request_Connect, NULBUF );
                           pQ.add( Event::User_Requests_Selection, 0 );
                           pQ.add( Event::User_Requests_Directory, 0 );
                           break;
                        case 'n':       // n
                        case 'N':       // Shift-n
                           command = Never;
                           status = sList.NEVER;
                           select = "Never";
                           fileNumber = fbm.bcstFileNumber;
                           cLine.msg( select, fileNumber, "\x0" );
                           state = FileSelect;
                           break;
                        case 152:       // Alt-o
                           strcpy( ftl0.selScope, "ONE" );
                           command = OneDirectory;
                           select = "Dir";
                           fileNumber = ftl0.dirFileNumber;
                           cLine.msg( select, fileNumber, "\x0" );
                           state = FileSelect;
                           break;
                        case 'p':       // p
                        case 'P':       // Shift-p
                           command = Priority;
                           status = sList.PRIORITY;
                           select = "Priority";
                           fileNumber = fbm.bcstFileNumber;
                           cLine.msg( select, fileNumber, "\x0" );
                           state = FileSelect;
                           break;
                        case 188:       // F2
                        case 'q' :      // q
                        case 'Q' :      // Shift-q
                        case  17:       // Ctrl-q
                           cfg.autoUpload = 0;            // so we don't try to connect
                           satLink->exitProgram( code );  // again while exiting
                           break;
                        case 'r':       // r
                        case 'R':       // Shift-r
                           bcstCommand( lastCommand );
                           break;
                        case 's':       // s
                        case 'S':       // Shift-s
                           command = Stop;
                           select = "Stop";
                           fileNumber = fbm.bcstFileNumber;
                           cLine.msg( select, fileNumber, "\x0" );
                           state = FileSelect;
                           break;
                        case 159:       // Alt-s - select directory/download
                           cLine.dirSelect();
                           state = Directory_Select;
                           break;
                        case 148 :      // Alt-t
                           if (cfg.kissTnc)      // inhibit for KISS TNCs
                              break;
                           if (!ftl0User.bbsAxp || ftl0User.bbsAxp->state() == LAPB::DISCONNECTED)
                           {
                              cfg.autoUpload = 0;// so we don't try to connect
                              tnc.kissToTerm();
                              sLine.currentMode( tnc.tncMode );
                              commandString = new char[ 80 ];
                              *commandString = 0;// make it a null string
                              len = 0;
                              tWin = new Window( 1, 1, 80, 1, LIGHTGRAY, cfg.cmdLineBg );
                              tWin->clear();
                           }
                           break;
                        case 150:       // Alt-u - upload files
                           if ((ftl0.numToUpload = ftl0.filesToUpload()) != 0)
                           {
                              if (!cfg.autoUpload)
                                 frWin.print( "Automatic uploading activated" );
                              cfg.autoUpload = 1;
                           }
                           break;
                        case 'v' :      // v
                        case 'V' :      // Shift-v
                           saveScreen();
                           dir.displayContents( 0 );
                           state = Review_Directory;
                           break;
                        case 'w':
                        case 'W':
                           actList.display();
                           break;
                     }
                     break;
                  case tnc.TermMode :
                     switch (key)
                     {
                        case  27:       // Esc
                           terminal.send( *(new MBuf( "\x03\r", 2 )) );
                           break;
                        case  13:       // CR
                           charcat( commandString, key );
                           len = strlen( commandString );
                           terminal.send( *(new MBuf( commandString, len )) );
                           strcat( commandString, "\r\n" ); // add CRLF
                           frWin.printALFD( commandString );// echo
                           *commandString = 0;
                           len = 0;
                           tWin->clear();
                           break;
                        case 165:       // Alt-k
                           if (!ftl0User.bbsAxp || ftl0User.bbsAxp->state() == LAPB::DISCONNECTED)
                           {
                              tnc.termToKiss();
                              sLine.currentMode( tnc.tncMode );
                              delete commandString;
                              delete tWin;
                              cLine.init();
                           }
                           break;
                        case 8 :         // Ctrl-h, Backspace
                           if (len)
                           {
                              len--;
                              commandString[ len ] = 0;
                           }
                           tWin->clear();
                           tWin->print( commandString );
                           break;
                        case 188:       // F2
                        case  17:       // Ctrl-q
                           if (!strlen( commandString ))
                           {
                              satLink->exitProgram( code );
                              break;
                           }
                           // else fall through; assumes commands don't
                           // start with 'q'
                        default:
                           if (len >= 79)        // don't exceed allocation
                              break;
                           len++;
                           charcat( commandString, key );
                           tWin->clear();
                           tWin->print( commandString );
                     }
               }
         }
         break;

      case MainHelp:
         if ( key  == 'q' || key == 'Q')
            satLink->exitProgram( code );
         else
            if (!help.processKey( "*MAIN", key ))
            {
               restoreScreen( 1 );
               state = Normal;
            }
         break;

      case Review_Directory:
         switch (key)
         {
            case 'q' :       // x
            case 'Q' :       // Shift-q
               satLink->exitProgram( code );
               break;
            default  :
               if (dir.displayContents( key ) != 0)
               {
                  restoreScreen( 1 );
                  state = Normal;
               }
         }
         break;

      case Directory_Select:
         switch (toupper( key ))
         {
            case 13: case 'A': case 'B': case 'M':
               switch (toupper( key ))
               {
                  case 'A':
                     strcpy( ftl0.selScope, "ALL" );
                     break;
                  case  13:
                  case 'B':
                     strcpy( ftl0.selScope, "BUL" );
                     break;
                  case 'M':
                     strcpy( ftl0.selScope, "MY" );

               }
               cLine.init();
               ftl0User.handleEvent( Event::Request_Connect, NULBUF );
               pQ.add( Event::User_Requests_Selection, 0 );
               pQ.add( Event::User_Requests_Directory, 0 );
               state = Normal;
               break;
            case 'O':
               strcpy( ftl0.selScope, "ONE" );
               command = OneDirectory;
               select = "Dir";
               fileNumber = ftl0.dirFileNumber;
               cLine.msg( select, fileNumber, "\x0" );
               state = FileSelect;
               break;
            case 27:
               cLine.init();
               state = Normal;
         }
         break;

      case Hightime_Adjust:
         switch (toupper( key ))
         {
            case 'A':
               hTime.adjust( "ALL" );
               break;
            case 'B':
               hTime.adjust( "BUL" );
               break;
            case 'M':
               hTime.adjust( "MY" );
               break;
         }
         restoreScreen( 1 );
         state = Normal;
         break;

      case FileSelect:
         switch (getFileNumber( select, key, &fileNumber, cLine ))
         {
            case 0:
               cLine.init();
               switch (command)
               {
                  case Begin:
                     fbm.bcstFileNumber = fileNumber;
                     bcstCommand( Event::User_Requests_Begin_File );
                     break;
                  case Download:
                     ftl0.dlFileNumber = fileNumber;
                     ftl0User.handleEvent( Event::Request_Connect, NULBUF );
                     pQ.add( Event::User_Requests_Download, 0 );
                     break;
                  case Fill:
                     fbm.bcstFileNumber = fileNumber;
                     bcstCommand( Event::User_Requests_Fill_File );
                     break;
                  case Automatic:
                  case Grab:
                  case Priority:
                  case Never:
                     fbm.bcstFileNumber = fileNumber;
                     sList.set( fbm.bcstFileNumber, status );
                     dir.setStatus( fbm.bcstFileNumber, status );
                     break;
                  case OneDirectory:
                     ftl0.dirFileNumber = fileNumber;
                     ftl0User.handleEvent( Event::Request_Connect, NULBUF );
                     pQ.add( Event::User_Requests_Directory, 0 );
                     break;
                  case Stop:
                     fbm.bcstFileNumber = fileNumber;
                     bcstCommand( Event::User_Requests_Stop_File );
                     break;
               }
               state = Normal;
               break;
            case 1:
               state = FileSelect;
               break;
            case 2:
               cLine.init();
               state = Normal;
         }
         break;
   }
}

void UserMgr::info() const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   sprintf( iWin.buf, "COM%u at %u baud", cfg.port, cfg.speed );
   iWin.print( iWin.buf );
   sprintf( iWin.buf, "Mycall: %s   Bdcstcall: %s", cfg.mycall, cfg.bcstcall );
   iWin.print( iWin.buf );
   *iWin.buf = 0;
   if (cfg.trace)
      strcat( iWin.buf, "Trace" );
   if (cfg.silent)
      strcat( iWin.buf, "Silent" );
   if (cfg.grabAll)
      strcat( iWin.buf, "Graball " );
   if (cfg.showDataHex)
      strcat( iWin.buf, "heX " );
   if (cfg.showData)
      strcat( iWin.buf, "Data " );
   if (cfg.showHeaders)
      strcat( iWin.buf, "Headers " );
   if (cfg.loggingStatus)
      strcat( iWin.buf, "SlipLog" );
   if (*iWin.buf != 0)
      iWin.print( iWin.buf );
   sprintf( iWin.buf, "Upload dir:   %s", cfg.ulDir );
   iWin.print( iWin.buf );
   sprintf( iWin.buf, "Download dir: %s", cfg.dlDir );
   iWin.print( iWin.buf );
   sprintf( iWin.buf, "Working dir:  %s", cfg.workDir );
   iWin.print( iWin.buf );
   sprintf( iWin.buf, "Alias: %s", cfg.alias ? cfg.alias : cfg.mycall );
   iWin.print( iWin.buf );
   sprintf( iWin.buf, "bcstPacLen: %u  txd: %u ms.  multikiss: %u",
                 cfg.bcstPaclen, cfg.txd * 10, cfg.tncId );
   iWin.print( iWin.buf );
}

void UserMgr::exitInfo( unsigned long exitAfterMs, unsigned long abortTime,
                        unsigned long idleExitTime ) const
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   struct time t;
   gettime( &t );
   sprintf( iWin.buf, "Current time:    %02d:%02d:%02d",
                 t.ti_hour, t.ti_min, t.ti_sec );
   iWin.print( iWin.buf );
   sprintf( iWin.buf, "Exit after:      %li mins", exitAfterMs / 60000L );
   iWin.print( iWin.buf );
   sprintf( iWin.buf, "Until exit:      %-.2f mins",
            satLink->exitAfterTimer->msLeft() / 60000.0 );
   iWin.print( iWin.buf );
   struct date d;
   unixtodos( abortTime, &d, &t);
   if (!abortTime)
   {
      t.ti_hour = 0;
      t.ti_min = 0;
      t.ti_sec = 0;
   }
   sprintf( iWin.buf, "Abort time:      %02d:%02d:%02d",
                 t.ti_hour, t.ti_min, t.ti_sec );
   iWin.print( iWin.buf );
   unixtodos( idleExitTime, &d, &t);
   if (!idleExitTime)
   {
      t.ti_hour = 0;
      t.ti_min = 0;
      t.ti_sec = 0;
   }
   sprintf( iWin.buf, "Idle exit time:  %02d:%02d:%02d",
                 t.ti_hour, t.ti_min, t.ti_sec );
   iWin.print( iWin.buf );
}

void UserMgr::saveScreen()
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   screenCount++;
   create_screen( screenCount, 24 );
   save_screen( screenCount );
   fiWinStateSave[ screenCount ] = fiWin.state;
   iWinStateSave[ screenCount ] = iWin.state;
   frWinStateSave[ screenCount ] = frWin.state;
   fiWin.state = Window::NotVisible;
   iWin.state = Window::NotVisible;
   frWin.state = Window::NotVisible;
}

void UserMgr::restoreScreen( int scope )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   if (scope == 1)
      restore_screen( screenCount );
   else
      part_restore_screen( screenCount, 1, 2, 80, 13, 1, 2 );
   _setcursortype( _NOCURSOR );
   fiWin.state = fiWinStateSave[ screenCount ];
   iWin.state = iWinStateSave[ screenCount ];
   frWin.state = frWinStateSave[ screenCount ];
   dispose_screen( screenCount );
   screenCount--;
}
