//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FTL0USER_H
#define  __FTL0USER_H

#ifndef  __AX25USER_H
#include "ax25user.h"
#endif

#ifndef  __OBJECT_H
#include "object.h"
#endif

class Ax25ConnTbl;
class Config;
class ErrCallUp;
class EventQueue;
class FTL0;
class LinkTable;
class MBuf;
class L1Protocol;
class Log;
class Rotor;
class StatusLine;
class UserMgr;
class Window;

class FTL0User : public Ax25User
{
public:
          Ax25*          bbsAxp;
          Ax25*          bcstAxp;

                         FTL0User( Config&     cfg,
                                   Window&     iWin,
                                   Window&     frWin,
                                   StatusLine& sLine,
                                   FTL0&       ftl0,
                                   L1Protocol& loProto,
                                   char&       bbsAddr,
                                   char&       bcstAddr,
                                   char&       myAddr,
                                   char&       logAddr,
                                   Log&        log,
                                   LinkTable&  link,
                                   CallUp&     eCallUp,
                                   EventQueue& pQ,
                                   Rotor&      antennaControl );
                         ~FTL0User();
          void           checkQ();
          void           handleEvent( unsigned i, MBuf& mb );
          void           toggleAutomode();

private:
          Rotor&         antennaControl;
          char&          bbsAddr;
          char&          bcstAddr;
          Config&        cfg;
          Window&        frWin;
          FTL0&          ftl0;
          Window&        iWin;
          Log&           log;
          L1Protocol&    loProto;
          char&          logAddr;
          LinkTable&     link;
          char&          myAddr;
          EventQueue&    pQ;
          StatusLine&    sLine;

          void           rCall( Ax25& ax );
          void           sCall( Ax25& ax );
};

#endif  __FTL0USER_H
