//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FTL0USER_H
#include "ftl0user.h"
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STDLIB_H
#include "stdlib.h"
#endif

#ifndef  __STRING_H
#include "string.h"
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __FTL0_H
#include "ftl0.h"
#endif

#ifndef  __FTL0PKT_H
#include "ftl0pkt.h"
#endif

#ifndef  __GETUE_H
#include "getue.h"
#endif

#ifndef  __LAPB_H
#include "lapb.h"
#endif

#ifndef  __LOG_H
#include "log.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __PKTQUEUE_H
#include "pktqueue.h"
#endif

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

#ifndef  __QUEUE_H
#include "queue.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

FTL0User::FTL0User( Config&     cfg,
                    Window&     iWin,
                    Window&     frWin,
                    StatusLine& sLine,
                    FTL0&       ftl0,
                    L1Protocol& loProto,
                    char&       bbsAddr,
                    char&       bcstAddr,
                    char&       myAddr,
                    char&       logAddr,
                    Log&        log,
                    LinkTable&  link,
                    CallUp&     eCallUp,
                    EventQueue& pQ,
                    Rotor&      antennaControl )
                  :
                    Ax25User( cfg, iWin, frWin, sLine, loProto, logAddr, log,
                              link, eCallUp, antennaControl ),
                    cfg( cfg ),
                    iWin( iWin ),
                    frWin( frWin ),
                    sLine( sLine ),
                    ftl0( ftl0 ),
                    loProto( loProto ),
                    bbsAddr( bbsAddr ),
                    bcstAddr( bcstAddr ),
                    myAddr( myAddr ),
                    logAddr( logAddr ),
                    log( log ),
                    link( link ),
                    pQ( pQ ),
                    antennaControl( antennaControl ),
                    bbsAxp( 0 ),
                    bcstAxp( 0 )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{}

FTL0User::~FTL0User()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   if (bbsAxp)
   {
      if (bbsAxp->rCallUp)
         delete bbsAxp->rCallUp;
      if (bbsAxp->sCallUp)
         delete bbsAxp->sCallUp;
      delete bbsAxp;
   }
   if (bcstAxp != bbsAxp)                        // in case the user made the
      delete bcstAxp;                            // callsigns the same
}

void FTL0User::checkQ()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   Event e;
   if (pQ.next( &e.i, &e.m ))                     // if pending event
      handleEvent( e.i, *((MBuf*)e.m) );          // handle it
   else                                           // else disconnect
      handleEvent( Event::Request_Disconnect, NULBUF );
}

void FTL0User::handleEvent( unsigned i, MBuf& mb )
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   char* callPtr;                                // ptr to our call sign
   switch (i)
   {
      case Event::User_Requests_Upload :         // handle FTL0 upload events
         ftl0.handleUlEvent( i, NULPKT );
         return;
      case Event::User_Requests_Download :
      case Event::User_Requests_Directory :
      case Event::User_Requests_Selection :
         ftl0.handleDlEvent( i, NULPKT );
         return;
      case Event::Data_Link_Terminated:
         ftl0.handleUlEvent( i, NULPKT );        // stop state machines
         ftl0.handleDlEvent( i, NULPKT );
         return;
      case Event::User_Requests_Abort :
         if (ftl0.dlState == FTL0::DL_UNINIT)
            handleEvent( Event::Request_Disconnect, NULBUF ); // recursive
         else                                    // handles abort rqst
            ftl0.handleDlEvent( i, NULPKT );     // for both ul & dl
         return;
      case Event::Rcv_Sat_Full_Frame:            // print whats printable
      case Event::Rcv_Sat_Open_Frame:
         mb.data[ mb.cnt ] = 0;                  // make it a string;
         callPtr = strstr( mb.data, (char*) &cfg.mycall );
         if (!cfg.trace)
         {
            frWin.print( mb.data, mb.cnt );      // display the text
                                                 // check for mycall
            if (callPtr)                         // if we're in queue
            {                                    // highlight our callsign
               unsigned offset = (unsigned)(callPtr - mb.data);
               frWin.highlight( strlen( mb.data ), offset, strlen( cfg.mycall ),
                                cfg.highlight1Fg, cfg.highlight1Bg );
            }
         }
         break;
      case Event::Request_Passive:
         if (!bcstAxp)
            bcstAxp = &open( myAddr, bcstAddr, AX_PASSIVE, cfg.axWindow,
                             NULCALLUP, eCallUp );
         if (!bcstAxp)
            frWin.print( "Error: cannot open passive connection" );
         return;
      case Event::Request_Connect:               // ignore here
      case Event::Request_Disconnect:
         break;
      default:
         delete &mb;                             // deallocate any message
         sprintf( frWin.buf, "FTL0User error: invalid event <%i>", i );
         frWin.print( frWin.buf );
         return;
   }

          enum sessionState { Inactive, Active };
   static enum sessionState sState = Inactive;
   switch (sState)
   {
      case Inactive:
         switch (i)
         {
            case Event::Rcv_Sat_Full_Frame:
               delete &mb;
               if (cfg.autoUpload && ftl0.numToUpload)        // if we need to upload
                  if (callPtr)                                 // if we're still in the queue
                     handleEvent( Event::Request_Connect, NULBUF ); // recursive call
               break;
            case Event::Rcv_Sat_Open_Frame:
               delete &mb;
               if (!cfg.autoUpload || !ftl0.numToUpload) // if we don't need to upload
                  break;
               pQ.add( Event::User_Requests_Upload, 0 );  // note fall through
            case Event::Request_Connect:
               if (cfg.backOffSlot)
                  delay( (random( cfg.maxBackOff ) + 1) * cfg.backOffSlot );
               frWin.print( "Initiating connection" ); // display on monitor
               log.write( "Initiating connection" );   // add to log file
               bbsAxp = &open( myAddr, bbsAddr, AX_ACTIVE, cfg.axWindow,
                               ftl0.tCallUp, eCallUp );
               if (!bbsAxp)
               {
                  frWin.print( "Error: cannot open active connection" );
                  pQ.flush();
                  break;
               }
               sState = Active;
               break;
            case Event::Request_Disconnect:
               bbsAxp->disconnect();
               pQ.flush();
               break;
         }
         break;
      case Active:
         switch (i)
         {
            case Event::Rcv_Sat_Full_Frame:
               delete &mb;
               if (callPtr)                      // if we're in the BBS queue
                  break;                         // do nothing, otherwise
               reset( *bbsAxp );                 // abruptly terminate
               delete bbsAxp;                    // delete because it's no
               bbsAxp = 0;                       // longer in connection tbl
               sState = Inactive;                // reset state
               break;
            case Event::Rcv_Sat_Open_Frame:
               delete &mb;
               if (callPtr)                      // if we're in BBS queue
                  break;                         // do nothing, otherwise
               if (bbsAxp->state() == LAPB::SETUP) // if trying to connect
                  break;                         // do nothing, otherwise
               reset( *bbsAxp );                 // abruptly terminate
               delete bbsAxp;                    // delete because it's no
               bbsAxp = 0;                       // longer in connection tbl
               sState = Inactive;                // reset state
               break;
            case Event::Request_Disconnect:
               frWin.print( "Terminating connection" ); // display on monitor
               log.write( "Terminating connection" );   // add to log file
               bbsAxp->disconnect();
               pQ.flush();
               sState = Inactive;
               break;
         }
   }
}

void FTL0User::rCall( Ax25& ax )
// -------------------------------------------------------------------------
// AX.25 receive callup function
// -------------------------------------------------------------------------
{
   MBuf* bp = &ax.rxDequeue();                   // in this implementation
   ftl0.recv( *bp );                             // ftl0 doesn't vary with
                                                 // the connection
}

void FTL0User::sCall( Ax25& ax )
// --------------------------------------------------------------------------
// AX.25 status change callup function
// --------------------------------------------------------------------------
{

// The following variables should be a part of Ax25 because they should
// be different for each separate connection

   static unsigned automodeDefer = 0;
   static unsigned monitorDefer = 0;

// static Ax25* = oldAxp;                        // if more than one connection
// oldAxp = bbsAxp;                              // we need to use the right
// bbsAxp = &ax;                                 // one

                                                 // need the right one
   int newState = ax.state();
   switch (ax.oldState())
   {
      case LAPB::DISCONNECTED:
         switch (newState)
         {
            case LAPB::SETUP:
               if (cfg.automode)
               {
                  toggleAutomode();
                  automodeDefer = 1;
               }
               break;
         }
         if (cfg.monitor)
         {
            monitorDefer = 1;
            cfg.monitor = 0;
         }
         break;
      case LAPB::SETUP:
      case LAPB::DISCPENDING:
         switch (newState)
         {
            case LAPB::DISCONNECTED:
               pQ.flush();
               handleEvent( Event::Data_Link_Terminated, NULBUF );
               if (monitorDefer)
               {
                  cfg.monitor = 1;
                  monitorDefer = 0;
               }
               if (automodeDefer)
               {
                  toggleAutomode();
                  automodeDefer = 0;
               }
               break;
         }
         break;
      case LAPB::RECOVERY:
      case LAPB::CONNECTED:
         switch (newState)
         {
            case LAPB::SETUP:
               handleEvent( Event::Data_Link_Terminated, NULBUF );
               break;
            case LAPB::DISCONNECTED:
               pQ.flush();
               handleEvent( Event::Data_Link_Terminated, NULBUF );
               if (monitorDefer)
               {
                  cfg.monitor = 1;
                  monitorDefer = 0;
               }
               if (automodeDefer)
               {
                  toggleAutomode();
                  automodeDefer = 0;
               }
               break;
         }
   }
// bbsAxp = oldAxp;
}

void FTL0User::toggleAutomode()
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
{
   cfg.automode = !cfg.automode;
   if (cfg.automode)
      sLine.autoStatus( "Idle" );
   else
      sLine.autoStatus( "Disabled" );
}

