//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __FILENTF_H
#define  __FILENTF_H

#ifndef  __DIR_H
#include <dir.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __HWDEVICE_H
#include "hwdevice.h"
#endif

class FileIntf : public HwDevice
{
private:
          FILE*         inFile;
   const  char*         dir;
          struct ffblk  fileBlock;
          unsigned      fileOpen;
          char*         iBuffer;
          unsigned      recvOutSize;

public:
                        FileIntf( unsigned& showDataHex, const char* dir );
                        ~FileIntf();
          int           close();
          int           dataReady();
          int           flush( const char ) const;
          int           open();
          int           open( const unsigned recvOutSize );
          int           openNext();
                            // trigger the receiver to execute the
                            // receive function
          void          poll();
                            // get from the receiver a pointer to an MBuf that
                            // the receiver created and filled with input
          int           recvOut( MBuf*& );
                            // get back from the receiver the input filled
                            // MBuf that the caller provides
          int           recvOut( MBuf& );
                            // get from the receiver a character of input
          int           recvOut( char& );
                            // get back from the receiver the input filled
                            // character array that the caller provides
          int           recvOut( char*, const unsigned len, unsigned &cnt );

          int           send( MBuf& );
          int           send( const char ) { return 1; }
          int           send( const char*, const unsigned );
          int           set( enum devVal param, const unsigned long );
};

#endif  __FILEINTF_H
