//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __DIRFILE_H
#include "dirfile.h"
#endif

#ifndef  __IO_H
#include <io.h>
#endif

#ifndef  __MEM_H
#include <mem.h>
#endif

#ifndef  __PROCESS_H
#include <process.h>
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

DirFileMgr::DirFileMgr( char*         workDir,
                        unsigned long maxDirFileSize,
                        unsigned      nDupeSearch,
                        Window&       frWin )
                        :
                        workDir( workDir ), maxDirFileSize( maxDirFileSize ),
                        nDupeSearch( nDupeSearch ), frWin( frWin ),
                        seqNum( 0 )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{
   dirblk.ff_reserved[0] = 0;
   dirblk.ff_attrib = 0;
   dirblk.ff_ftime = 0;
   dirblk.ff_fdate = 0;
   dirblk.ff_fsize = 0;
   dirblk.ff_name[0] = 0;
}

DirFileMgr::~DirFileMgr()
// --------------------------------------------------------------------------
//  Destructor
// --------------------------------------------------------------------------
{
   fclose( file );
}

void DirFileMgr::checkFiles()
// --------------------------------------------------------------------------
//  Check if directory files exist.  Create one if they do not.  Open the
//  file with the highest sequence number.
// --------------------------------------------------------------------------
{
   sprintf( fileName, "%sPB__????.PFH", workDir );
   if (findfirst( fileName, &dirblk, 0 ) == 0)   // find first PB__xxxx.PFH
   {
      sscanf( dirblk.ff_name, "PB__%u", &seqNum );// get sequence number
      while (findnext( &dirblk ) == 0)            // find the next one
      {
         int seq;
         sscanf(dirblk.ff_name, "PB__%u", &seq);
         if (seq > seqNum)
            seqNum = seq;                         // keep highest seq number
      }
   }
   sprintf( fileName, "%sPB__%04i.PFH", workDir, seqNum ); // use highest
   findfirst( fileName, &dirblk, 0 );             // get attributes
   if ((file = fopen( fileName, "a+b" )) == 0)
   {
      printf( "cannot create directory file <%s>\n", fileName );
      exit( 1 );
   }
}

void DirFileMgr::ckDirSize( unsigned cnt )
// --------------------------------------------------------------------------
//  Check the current PB__xxxx.PFH file to determine if it has
//  reached the maximum size.  If it has, close it and open a new
//  file with an incremented sequence number.
// --------------------------------------------------------------------------
{
   if (dirblk.ff_fsize + cnt > maxDirFileSize)   // if file will be too big
   {
      fclose( file );                            // close it
      seqNum++;                                  // build next sequential name
      sprintf( fileName, "%sPB__%04i.PFH", workDir, seqNum );
      if ((file = fopen( fileName, "a+b" )) == 0)
      {
         sprintf( frWin.buf, "cannot create directory file %s", fileName );
         frWin.printFatal( frWin.buf );
      }
      else
         dirblk.ff_fsize = filelength( fileno( file ) );
   }
   dirblk.ff_fsize += cnt;                       // track file size without
                                                 // getting it from DOS
}

unsigned DirFileMgr::onDirList( const unsigned long fileNumber )
// -------------------------------------------------------------------------
//  Check whether or not a file number is on the recent directories heard
//  list.  If it is, return 1, otherwise, return 0.  If it isn't on the list
//  but is within the range to check, then put it on the list;
//
//  This function is to keep track of recent entries added to the directory
//  from broadcast directory entries, entries extracted from broadcast
//  files, and downloaded directory files.
// -------------------------------------------------------------------------
{
   static unsigned long *dupeList = 0;
   if (!dupeList)
   {                                             // create the list
      dupeList = new unsigned long[ nDupeSearch ];
      memset( dupeList, 0, sizeof( unsigned long )*nDupeSearch );
   }
   for (unsigned i = 0; i < nDupeSearch; i++)
   {
      if (fileNumber == dupeList[ i ])
         return 1;                               // is on the list
      if (fileNumber > dupeList[ i ])
      {
         memmove( &dupeList[ i+1 ], &dupeList[ i ],
                  sizeof( unsigned long )*(nDupeSearch - i - 1) );
         dupeList[ i ] = fileNumber;
         return 0;
      }                                          // wasn't on the list
   }
   return 0;                                     // not within search limit
}

void DirFileMgr::saveData( const char* bp, const unsigned len )
// --------------------------------------------------------------------------
// Save directory entry (i.e., pacsat file header)
// --------------------------------------------------------------------------
{
   ckDirSize( len );                             // make sure there's room
   if (fwrite( bp, 1, len, file) != len)
      frWin.print( "error writing to .PFH file ");
}
