//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef   __DIRDL_H
#include "dirdl.h"
#endif

#ifndef  __CTYPE_H
#include <ctype.h>
#endif

#ifndef  __DIR_DEF
#include <dir.h>
#endif

#ifndef  _IO_H
#include <io.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __CHGHIGH_H
#include "chghigh.h"
#endif

#ifndef __DIRBCST_H
#include "dirbcst.h"
#endif

#ifndef  __DIRFILE_H
#include "dirfile.h"
#endif

#ifndef  __FTL0_H
#include "ftl0.h"
#endif

#ifndef  __FTL0PKT_H
#include "ftl0pkt.h"
#endif

#ifndef  __PFHEADER_H
#include "pfheader.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

DirDlMgr::DirDlMgr( Window&     win,
                    DirFileMgr& dfm,
                    HighTime&   hTime,
                    unsigned    maxPfhSize )
                  :
                  win( win ),
                  dfm( dfm ),
                  hTime( hTime ),
                  maxPfhSize( maxPfhSize ),
                  accumLen( 0 )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{
   accumSize = 2 * maxPfhSize;
   accum = new char[ accumSize ];
}

DirDlMgr::~DirDlMgr()
// --------------------------------------------------------------------------
//  Destructor
// --------------------------------------------------------------------------
{
   delete accum;
}

int DirDlMgr::receive( FTL0Pkt& pkt )
// --------------------------------------------------------------------------
//  Return 1 if time changed, otherwise 0
// --------------------------------------------------------------------------
{
   int timeChanged = 0;

   if (pkt.len != 0)
   {
      // Append new packet to directory data accumulator.  This is necessary
      // because the file headers can span ftl0 packets.

      accumLen += pkt.len;
      if (accumLen > accumSize)
      {
         win.print( "directory accumulator overflow");
         accumLen = 0;                           // zero data length
         return 0;
      }
      memcpy( &accum[ accumLen ], &pkt.c[ 2 ], pkt.len);
      char *cp = accum;

      int hdrlen;
      PFileHeader fl( win );

      while (accumLen > 0)
      {
         // The buffer may contain corrupted pfh's so the following line
         // skips over the bad data.

         while (*cp != 0xAA && *(cp + 1) != 0x55 && accumLen > 0)
         {
            cp++;
            accumLen--;
         }
         if (!accumLen || (hdrlen = fl.get( cp, accumLen )) == 0)
            break;
         fl.display();                           // display on screen
         if (fl.header_checksum != fl.csum)
            win.print( "Directory checksum error." );
         else
            dfm.saveData( cp, hdrlen );         // put in directory file
         cp += hdrlen;                           // jump past this header
         accumLen -= hdrlen;                     // and point to the next one
         if (fl.upload_time > hTime.hightime)
         {
            hTime.hightime = fl.upload_time;
            timeChanged = 1;
         }
      }
      if (accumLen < 0)
      {
         win.print( "directory accumulator underflow");
         accumLen = 0;                           // zero data length
         return 0;
      }
      memmove( accum, cp, accumLen );        // move remainder to beginning
   }
   return timeChanged;
}

unsigned long DirDlMgr::getFileSize( char* data, unsigned cnt )
// --------------------------------------------------------------------------
//  Get file size from a pacsat file header in the accumulator array.
//  Return file size if found; otherwise 0;
// --------------------------------------------------------------------------
{
   char* cp = data;                              // point to first data byte
   char* last = data + cnt - 1;                  // point to last data byte

   while ((cp < last) && (*cp != 0xAA) && (*(cp + 1) != 0x55))
      cp++;
   if (cp >= last - 1)
      return 0;
   cp += 2;

   // read header items

   while (1)                                     // for all header fields
   {
      if (cp + 2 > last)                         // if not complete id and len
         return 0;

      unsigned id  = *cp++;
      unsigned id2 = *cp++;
      unsigned len = *cp++;
      id |= id2 << 8;

      if (id == 0 && len == 0)                   // if end of header
         return 0;                               //   yes, exit loop
      if (cp + len - 1 > last)                   // if out of data
         return 0;                               //   yes, exit function

      if (id == 0x04)
      {
         if (len <= 4)
         {
            unsigned long val = 0;
            for (int i = 0; i < len; i++)           // reverse the bytes
               val |= (unsigned long) *cp++ << (8 * i);
            return val;
         }
         else
            return 0;
      }
      cp += len;
   }
}
