//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __CTPYE_H
#include <ctype.h>
#endif

#ifndef  __FCNTL_H
#include <fcntl.h>
#endif

#ifndef  __IO_H
#include <io.h>
#endif

#ifndef  __STAT_H
#include <sys//stat.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

Config::Config()
         :
          abortTime( 0 ),                        // time to abort program
          actDays( 3 ),                          // inactivity purge interval
          aeaDelay( 55 ),                        // AEA TNC additional delay
          automode( 1 ),
          autoSelect( 1 ),                       // auto message selection
          autoUpload( 1 ),                       // automaticly upload files
          axIRTT( 1500 ),                        // initial round trip estimate, ms
          axPacLen( 256 ),                       // 256-byte I fields
          axVersion( 2 ),                        // protocol version
          axWindow( 2048 ),                      // 2K incoming text before RNR'ing
          backOffSlot( 0 ),                      // size of a backoff slot
                                                 // 1st string POSTPASS.BAT
          bats1( "call dofile" ),
          bats2( "" ),                           // 2nd string POSTPASS.BAT
          bcstPaclen( 244 ),
          bLimit( 0 ),                           // retransmission backoff limit
          blockLogs( 0 ),                        // block all log files
          breakDelay( 500 ),                     // delay getting out of KISS
          charDelay( 0 ),                        // ms. delay bytes to TNC
          capture( 0 ),                          // capture screen
          databits( 8 ),                         // serial port data bits
          debug( 0 ),                            // amt of debug info
          debugPortDataHex( 0 ),                 // show serial port data
          delayInterval( 1 ),                    // delay after "n" chars
          dirUpdateMs( 900000L )
//--------------------------------------------------------------------------
//  The strings must be explicitly initialized.  The other variables are
//  initialized below because of compiler limitations.
//--------------------------------------------------------------------------
{
   commandDelay = 165;                           // delay after command to TNC
   strcpy( alias, "!@#$%\0" );                   // user alias
   *bbscall = 0;                                 // satellite BBS call sign
   *bcstcall = 0;                                // satellite bcst call sign
   *currentSat = 0;                              // bbs call w/o SSID
   strcpy( defaultSel, "F1" );                   // default select equation
   *dlDir = 0;                                   // loc of downloaded files
   debugAx25 = 0;                                // show AX.25 headers in hex
   exitAfterMs = 0;                              // idle mins until exiting
   exitCode = 0;                                 // reason for program exit
   exitInfoFile = 0;                             // file of exit times
   exitOnSatCallError = 0;                       // exit if another heard
   ftl0Paclen = 254;                             // optimum for 256 byte ax25 packets
   fullDuplex = 1;                               // AX.25 fullduplex
   fullDupCmdInterval = 0;                       // fulldup command interval
   grabAll = 1;                                  // grab all files
   idleExitTime = 0;                             // exit time if idle
   kissTnc = 0;                                  // flag for a KISS TNC
   *logcall = 0;
   logDirFrames = 0;                             // log broadcast dir frames
   logFileFrames = 0;                            // log broadcast file frames
   loggingStatus = 0;                            // SLIP frame logging status
   logInFrames = 0;                              // log incoming SLIP frames
   logOutFrames = 0;                             // log outgoing SLIP frames
   makeBat = 0;                                  // batch file generation
   maxBackOff = 2;                               // maximum backoff slots
   maxDirArchLoad = 35000L;                      // max archive bytes
   maxDirFileSize = 25000;                       // maximum dir file size
   maxDirLoad = 100000L;                         // max directory bytes
   maxFrame = 1;                                 // stop and wait
// maxHandleCount = 0;                           // max DOS file handles
   maxPfhSize = 500;                             // max pfh size people create
   monitor = 1;                                  // monitor packet activity
   n2 = 10;                                      // 10 retries
   nDupeSearch = 100;
   numCallsToHide = 0;                           // number of callsigns to hide
   numTypesBlocked = 0;                          // number blocked file types
   orbitDrvInterrupt = 0;                        // OrbitDRV interrupt vector
   parity = 'N';                                 // serial port parity
   persistence = 0;                              // AX.25 persistence
   port = 1;                                     // serial port to TNC
   portAddr = 0;                                 // serial port address
   portIrq = 0;                                  // serial port IRQ
   pThresh = 128;                                // send polls for packets larger than this
   purgeN = 0;                                   // purge "NEVER" files
   responseDelay = 110;                          // ms delay for TNC to respond
   restartDelay = 3333;                          // delay going into KISS mode
   screenMode = 0;
   setClockToSat = 0;                            // set CPU time from sat time
   *mycall = 0;                                  // user call sign
   *select = 0;                                  // select equation file name
   showData = 0;                                 // show frame data
   showDataHex = 0;                              // show data in hex
   showGrabs = 0;
   showHeaders = 0;                              // ax25 headers to screen
   showMemory = 0;                               // don't show memory
   showTimerActivity = 0;                        // show timer starting / stopping
   silent = 0;                                   // no bells
   simulate = 0;                                 // receive from sim file
   simulationDelay = 0;                          // delay input from file
   slotTime = 0;                                 // AX.25 slottime
   speed = 19200;                                // serial port speed
   stopbits = 1;                                 // serial port stop bit time
   t3Init = 0;                                   // no keep-alive polling
   tncStartMode = KissMode;                      // TNC startup mode
   tncId = 0;                                    // multi drop KISS address
   *tncInitFile = 0;                             // TNC initialization file
   *tncTermFile = 0;                             // TNC termination file
   trace = 0;                                    // trace connected mode
   txd = 0;                                      // AX.25 txdelay
   *ulDir = 0;                                   // loc of uploadable files
   *workDir = 0;                                 // loc of working files
   borderFg       = WHITE;
   borderBg       = BLACK;
   cmdLineFg      = YELLOW;
   cmdLineBg      = RED;
   dataWinFg      = WHITE;
   dataWinBg      = BLUE;
   directoryFg    = WHITE;
   directoryBg    = BLUE;
   fileWinFg      = BLACK;
   fileWinBg      = GREEN;
   helpFg         = WHITE;
   helpBg         = BLUE;
   highlight1Fg   = WHITE;
   highlight1Bg   = RED;
   highlight2Fg   = GREEN;
   highlight2Bg   = BLACK;
   highlight3Fg   = WHITE;
   highlight3Bg   = BLUE;
   hightimeBorFg  = BLACK;
   hightimeBorBg  = LIGHTGRAY;
   hightimeHighFg = RED;
   hightimeHighBg = LIGHTGRAY;
   hightimeTextFg = BLUE;
   hightimeTextBg = LIGHTGRAY;
   infoWinFg      = BLACK;
   infoWinBg      = GREEN;
   msgLineFg      = YELLOW;
   msgLineBg      = RED;
   statusLineFg   = BLUE;
   statusLineBg   = LIGHTGRAY;
}

unsigned Config::blockedFType( const char fileType ) const
// ------------------------------------------------------------------------
// Indicate whether or not the file type is blocked.
// Return 1 if bolcked, otherwise 0;
// ------------------------------------------------------------------------
{
   int i;

   for (i = 0; i < numTypesBlocked; i++)
      if (fileType == blockFType[i])
         return 1;
   if (blockLogs && ( (fileType >= 201 && fileType <= 210) ||
                      (fileType >= 212 && fileType <= 214)    ) )
      return 1;
   return 0;
}

void Config::getExitInfo()
// -------------------------------------------------------------------------
//  Read program exit information from file.  This file contains two times
//  in decimal numbers consistent with the time() function.  Convert the
//  abortTime to an interval in millisecs from the current time.
// -------------------------------------------------------------------------
{
   abortTime = 0;
   abortInterval = 0;
   idleExitTime = 0;
   struct
   {
      unsigned long abortTime;
      unsigned long idleExitTime;
   } rec = {0, 0};

   int handle = open( exitInfoFile, O_RDWR|O_BINARY );
   if (handle == -1)
      return;
   ::read( handle, &rec, sizeof( rec ) );
   close( handle);

   if (rec.abortTime)
      abortInterval = (rec.abortTime - time( 0 )) * 1000;
   abortTime = rec.abortTime;
   idleExitTime = rec.idleExitTime;
}

void Config::putExitInfo()
// -------------------------------------------------------------------------
//  Write program exit information to file.  Append the exit code to the
//  data in the file.  Read the data first so that repetitive executions
//  maintain the same data structure.
// -------------------------------------------------------------------------
{
   int handle = open( exitInfoFile, O_CREAT|O_RDWR|O_BINARY, S_IWRITE );
   if (handle == -1)
      return;

   struct
   {
      unsigned long abortTime;
      unsigned long idleExitTime;
      char          birdName[ 7 ];
      unsigned      exitCode;
   } rec = {0, 0};

   lseek( handle, 0, SEEK_SET );
   ::read( handle, &rec, sizeof( rec ) );
   lseek( handle, 0, SEEK_SET );
   rec.exitCode = exitCode;
   write( handle, &rec, sizeof( rec ) );
   close( handle );
}

void Config::read( char* argv[] )
// --------------------------------------------------------------------------
//  Read and process configuration file
// --------------------------------------------------------------------------
{
   FILE* config;
   if ((config = fopen( argv[ 1 ], "r" )) == 0)  // check for config file
   {
      printf( "Configuration file <%s> not found\n", argv[1] );
      exit( 1 );
   }
   const unsigned MAXREC = 130;
   char* c_record = new char[ MAXREC ];
   char* copy = new char[ MAXREC ];
   if (!c_record || !copy)
   {
      puts( "Out of memory\n" );
      exit( 1 );
   }
   unsigned config_errors = 0;
   int   i = 0;
   char* recID;
   char* recVal;
   while (fgets( c_record, MAXREC, config ) != 0)
   {
      i++;
      strcpy( copy, c_record );
      if (!strchr( c_record, '\n' ))
      {
         printf( "Invalid configuration record;"
                 " exceeds %u characters:\n%s\n", MAXREC - 2, copy );
         config_errors = 1;
         continue;
      }
      char* semiColon = strchr( c_record, ';' ); // locate any comments
      *semiColon = 0;                            // truncate the string
      if (*c_record == 0 || *c_record == '\n' )  // if empty string/blank line
         continue;
      char *quoted = strchr( c_record, '\'');    // is value single quoted?
      recID = strtok( c_record, " \n" );         // get parameter label
      if (quoted)
      {
         recVal = strtok( 0, "'" );              // locate single quotes value
         if (quoted+ 1 != recVal)                // if we got leading garbage
         recVal = strtok( 0, "'" );              // try it again
      }
      else
         recVal = strtok( 0, " \n" );            // look for 1 token value
      int len = strlen( recVal );                // get length of the value
      unsigned uVal = atoi( recVal );
      unsigned long ulVal = strtoul( recVal, 0, 10);
      if (stricmp( recID, "ActDays" ) == 0)
      {
         actDays = uVal;
         continue;
      }
      if (stricmp( recID, "AeaDelay" ) == 0)
      {
         aeaDelay = uVal;                       // in millisecs
         continue;
      }
      if (!stricmp( recID, "Alias" ) || !stricmp( recID, "MYADDR" ))
         if (len <= 40)
         {
            strcpy( alias, recVal );
            for (char * cp = alias; *cp != 0; cp++)
               *cp = toupper( *cp );
            continue;
         }
      if (stricmp( recID, "AutoMode" ) == 0)
      {
         automode = uVal;
         continue;
      }
      if (stricmp( recID, "AutoSelect" ) == 0)
      {
         autoSelect = uVal;
         continue;
      }
      if (stricmp( recID, "AutoUpload" ) == 0)
      {
         autoUpload = uVal;
         continue;
      }
      if (stricmp( recID, "AxPacLen" ) == 0)
      {
         axPacLen = uVal;
         if (axPacLen <= 256 )
            continue;
      }
      if (stricmp( recID, "AxVersion" ) == 0)
      {
         axVersion = uVal;
         continue;
      }
      if (stricmp( recID, "AxWindow" ) == 0)
      {
         axWindow = uVal;
         continue;
      }
      if (stricmp( recID, "BackOffSlot" ) == 0)
      {
         backOffSlot= uVal;
         continue;
      }
      if (stricmp( recID, "Bats1" ) == 0)
         if (len + 10 + strlen( bats2 ) < 80 )
            {
               bats1 = new char[ len + 1 ];
               strcpy( bats1, recVal );
               continue;
            }
      if (stricmp( recID, "Bats2" ) == 0)
         if (strlen( bats1 ) + 10 + len < 80 )
            {
               bats2 = new char[ len + 1 ];
               strcpy( bats2, recVal );
               continue;
            }
      if (stricmp( recID, "BBSCall" ) == 0)
         if (strlen( recVal ) <= 9)
         {
            strcpy(bbscall, recVal );
            continue;
         }
      if (stricmp( recID, "BcstCall" ) == 0)
         if (strlen( recVal ) <= 9)
         {
            strcpy(bcstcall, recVal );
            continue;
         }
      if (stricmp( recID, "BcstPacLen" ) == 0)
      {
         bcstPaclen = uVal;
         continue;
      }
      if (stricmp( recID, "BLimit" ) == 0)
      {
         bLimit = ulVal;
         continue;
      }
      if (stricmp( recID, "BlockFType" ) == 0)
      {
         if (numTypesBlocked < 20)
         {
            blockFType[ numTypesBlocked ] = char( uVal );
            numTypesBlocked++;
         }
         continue;
      }
      if (stricmp( recID, "BlockLogs" ) == 0)
      {
         blockLogs = uVal;
         continue;
      }
      if (stricmp( recID, "BreakDelay" ) == 0)
      {
         breakDelay = uVal;           // in millisecs
         continue;
      }
      if (stricmp( recID, "Capture" ) == 0)
      {
         capture = uVal;
         continue;
      }
      if (stricmp( recID, "CharDelay" ) == 0)
      {
         charDelay = uVal;
         continue;
      }
      if (stricmp( recID, "CommandDelay" ) == 0)
      {
         commandDelay = uVal;
         continue;
      }
      if (stricmp( recID, "DataBits" ) == 0)
      {
         databits = uVal;
         continue;
      }
      if (stricmp( recID, "Debug" ) == 0)
      {
         debug = uVal;
         continue;
      }
      if (stricmp( recID, "DebugAx25" ) == 0)
      {
         debugAx25 = uVal;
         continue;
      }
      if (stricmp( recID, "DebugPortDataHex" ) == 0)
      {
         debugPortDataHex = uVal;
         continue;
      }
      if (stricmp( recID, "DefaultSel" ) == 0)
      {
         strncpy( defaultSel, recVal, 3 );
         defaultSel[ 3 ] = 0;
         continue;
      }
      if (stricmp( recID, "DelayInterval" ) == 0)
      {
         delayInterval = uVal;
         continue;
      }
      if (stricmp( recID, "DirUpdateMins" ) == 0)
      {
         dirUpdateMs = ulVal * 60000L;           // convert to millisecs
         continue;
      }
      if (stricmp( recID, "DlDir" ) == 0)
         if (strlen( recVal ) <= MAXPATH - 13)
         {
            strcpy( dlDir, recVal );
            if (dlDir[ strlen( dlDir ) - 1 ] != '\\' )
               strcat( dlDir,  "\\" );           // include backslash
            continue;
         }
      if (stricmp( recID, "ExitAfter" ) == 0)
      {
         exitAfterMs = ulVal * 60000L;           // convert to millisecs
         continue;
      }
      if (stricmp( recID, "ExitInfoFile" ) == 0 && len <= 80 )
      {
         exitInfoFile = new char[ len + 1 ];
         strcpy( exitInfoFile, recVal );
         continue;
      }
      if (stricmp( recID, "ExitOnSatCallError" ) == 0)
      {
         exitOnSatCallError= uVal;
         continue;
      }
      if (stricmp( recID, "Ftl0PacLen" ) == 0)
      {
         ftl0Paclen = uVal;
         if (ftl0Paclen <= 256)
            continue;
      }
      if (stricmp( recID, "Frack" ) == 0)
      {
         axIRTT = ulVal * 500;
         continue;
      }
      if (stricmp( recID, "FullDupCmdInterval" ) == 0)
      {
         fullDupCmdInterval = ulVal;
         continue;
      }
      if (stricmp( recID, "FullDuplex" ) == 0)
      {
         fullDuplex = uVal;
         continue;
      }
      if (stricmp( recID, "GrabAll" ) == 0)
      {
         grabAll = uVal;
         continue;
      }
      if (stricmp( recID, "HideDataForCall" ) == 0)
      {
         if (numCallsToHide < 20)
         {
            if (Ax25::setCall( hideCalls[ numCallsToHide ], recVal) == 0)
            {
               numCallsToHide++;
               continue;
            }
            else
               printf( "Invalid callsign" );
         }
         continue;
      }
      if (stricmp( recID, "KissTnc" ) == 0)
      {
         kissTnc = uVal;;
         continue;
      }
      if (stricmp( recID, "LogCall" ) == 0)
         if (strlen( recVal ) <= 9)
         {
            strcpy( logcall, recVal );
            for (char* cp = logcall; *cp != 0; cp++)
               *cp = toupper( *cp );
            loggingStatus = 1;
            continue;
         }
      if (stricmp( recID, "LogDirFrames" ) == 0)
      {
         logDirFrames = uVal;
         loggingStatus = 1;
         continue;
      }
      if (stricmp( recID, "LogFileFrames" ) == 0)
      {
         logFileFrames = uVal;
         loggingStatus = 1;
         continue;
      }
      if (stricmp( recID, "LogInFrames" ) == 0)
      {
         logInFrames = uVal;
         loggingStatus = 1;
         continue;
      }
      if (stricmp( recID, "LogOutFrames" ) == 0)
      {
         logOutFrames = uVal;
         loggingStatus = 1;
         continue;
      }
      if (stricmp( recID, "MakeBat" ) == 0)
      {
         makeBat = uVal;
         continue;
      }
      if (stricmp( recID, "MaxBackOff" ) == 0)
      {
         maxBackOff= uVal;
         continue;
      }
      if (stricmp( recID, "MaxFrame" ) == 0)
         if ((maxFrame = uVal) <= 7)
            continue;
      if (stricmp( recID, "MaxDirArchLoad" ) == 0)
      {
         maxDirArchLoad = ulVal;
         continue;
      }
      if (stricmp( recID, "MaxDirFileSize" ) == 0)
      {
         maxDirFileSize = ulVal;
         continue;
      }
      if (stricmp( recID, "MaxDirLoad" ) == 0)
      {
         maxDirLoad = ulVal;
         continue;
      }
//    if (stricmp( recID, "MaxHandleCount" ) == 0)
//    {
//       maxHandleCount = uVal;
//       continue;
//    }
      if (stricmp( recID, "MaxPfhSize" ) == 0)
      {
         maxPfhSize = uVal;
         if (maxPfhSize > 0)
            continue;
      }
      if (stricmp( recID, "Monitor" ) == 0)
      {
         monitor = uVal;
         continue;
      }
      if (stricmp( recID, "MyCall" ) == 0)
         if (strlen( recVal ) <= 9)
         {
            strcpy( mycall, recVal );
            for (char * cp = mycall; *cp != 0; cp++)
               *cp = toupper( *cp );
            continue;
         }
      if (stricmp( recID, "NDupeSearch" ) == 0)
      {
         nDupeSearch = uVal;
         continue;
      }
      if (stricmp( recID, "OrbitDrvInterrupt" ) == 0)
      {
         orbitDrvInterrupt = int( strtoul( recVal, 0, 16) );
         continue;
      }
      if (stricmp( recID, "Parity" ) == 0)
      {
         parity = *recVal;
         continue;
      }
      if (stricmp( recID, "Persistence" ) == 0)
      {
         persistence = uVal;
         continue;
      }
      if (stricmp( recID, "Port" ) == 0)
      {
         port = uVal;
         continue;
      }
      if (stricmp( recID, "PortAddr" ) == 0)
      {
         portAddr = int( strtoul( recVal, 0, 16) );
         continue;
      }
      if (stricmp( recID, "PortIrq" ) == 0)
      {
         portIrq = uVal;
         continue;
      }
      if (stricmp( recID, "PThresh" ) == 0)
      {
         pThresh = uVal;
         continue;
      }
      if (stricmp( recID, "PurgeN" ) == 0)
      {
         purgeN = uVal;
         continue;
      }
      if (stricmp( recID, "RestartDelay" ) == 0)
      {
         restartDelay = uVal;                    // in millisecs
         continue;
      }
      if (stricmp( recID, "Retries" ) == 0)
      {
         n2 = uVal;
         continue;
      }
      if (stricmp( recID, "ScreenMode" ) == 0)
      {
         if (stricmp( recVal, "Dir" ) == 0)
            screenMode = ReviewDirectory;
         else
            if (stricmp( recVal, "Zoom" ) == 0)
               screenMode = NoFileWindow;
         continue;
      }
      if (stricmp( recID, "Select" ) == 0)
      {
         strncpy( select, recVal, 80 );
         select[ 80 ] = 0;
         continue;
      }
      if (stricmp( recID, "SetClockToSat" ) == 0)
      {
         setClockToSat = uVal;
         continue;
      }
      if (stricmp( recID, "ShowGrabs" ) == 0)
      {
         showGrabs = uVal;
         continue;
      }
      if (stricmp( recID, "ShowHeaders" ) == 0)
      {
         showHeaders = uVal;
         continue;
      }
      if (stricmp( recID, "ShowLoopSpeed" ) == 0)
      {
         showLoopSpeed = uVal;
         continue;
      }
      if (stricmp( recID, "ShowMemory" ) == 0)
      {
         showMemory = uVal;
         continue;
      }
      if (stricmp( recID, "ShowTimerActivity" ) == 0)
      {
         showTimerActivity = uVal;
         continue;
      }
      if (stricmp( recID, "Silent" ) == 0)
      {
         silent = uVal;
         continue;
      }
      if (stricmp( recID, "Simulate" ) == 0)
      {
         simulate = uVal;
         continue;
      }
      if (stricmp( recID, "SimulationDelay" ) == 0)
      {
         simulationDelay = uVal;
         continue;
      }
      if (stricmp( recID, "SlotTime" ) == 0)
      {
         slotTime = uVal;
         continue;
      }
      if (stricmp( recID, "Speed" ) == 0)
      {
         speed = uVal;
         continue;
      }
      if (stricmp( recID, "StopBits" ) == 0)
      {
         stopbits = uVal;
         continue;
      }
      if (stricmp( recID, "T3Init" ) == 0)
      {
         t3Init = ulVal;
         continue;
      }
      if (stricmp( recID, "TncId" ) == 0)
      {
         tncId = uVal;
         continue;
      }
      if (stricmp( recID, "TncInitFile" ) == 0)
         if (strlen( recVal ) <= MAXPATH)
         {
            strcpy( tncInitFile, recVal );
            continue;
         }
      if (stricmp( recID, "TncStartMode" ) == 0)
      {
         tncStartMode = uVal;
         continue;
      }
      if (stricmp( recID, "TncTermFile" ) == 0)
         if (strlen( recVal ) <= MAXPATH)
         {
            strcpy( tncTermFile, recVal );
            continue;
         }
      if (stricmp( recID, "Trace" ) == 0)
      {
         trace = uVal;
         continue;
      }
      if (stricmp( recID, "Txd" ) == 0)
      {
         txd = uVal / 10;                        // make multiples of 10 ms
         continue;
      }
      if (stricmp( recID, "UlDir" ) == 0)
         if (strlen( recVal ) <= MAXPATH - 13)
         {
            strcpy( ulDir, recVal );
            if (ulDir[ strlen( ulDir ) - 1 ] != '\\' )
               strcat( ulDir,  "\\" );           // include backslash
            continue;
         }
      if (stricmp( recID, "WorkDir" ) == 0)
         if (strlen( recVal ) <= MAXPATH - 13)
         {
            strcpy( workDir, recVal );
            if (workDir[ strlen( workDir ) - 1 ] != '\\' )
               strcat( workDir,  "\\" );         // include backslash
            continue;
         }
      if (stricmp( recID, "BorderFg" ) == 0)
      {
         borderFg = uVal;
         continue;
      }
      if (stricmp( recID, "BorderBg" ) == 0)
      {
         borderBg = uVal;
         continue;
      }
      if (stricmp( recID, "CmdLineFg" ) == 0)
      {
         cmdLineFg = uVal;
         continue;
      }
      if (stricmp( recID, "CmdLineBg" ) == 0)
      {
         cmdLineBg = uVal;
         continue;
      }
      if (stricmp( recID, "DataWinFg" ) == 0)
      {
         dataWinFg = uVal;
         continue;
      }
      if (stricmp( recID, "DataWinBg" ) == 0)
      {
         dataWinBg = uVal;
         continue;
      }
      if (stricmp( recID, "DirectoryFg" ) == 0)
      {
         directoryFg = uVal;
         continue;
      }
      if (stricmp( recID, "DirectoryBg" ) == 0)
      {
         directoryBg = uVal;
         continue;
      }
      if (stricmp( recID, "FileWinFg" ) == 0)
      {
         fileWinFg = uVal;
         continue;
      }
      if (stricmp( recID, "FileWinBg" ) == 0)
      {
         fileWinBg = uVal;
         continue;
      }
      if (stricmp( recID, "Highlight1Fg" ) == 0)
      {
         highlight1Fg = uVal;
         continue;
      }
      if (stricmp( recID, "Highlight1Bg" ) == 0)
      {
         highlight1Bg = uVal;
         continue;
      }
      if (stricmp( recID, "Highlight2Fg" ) == 0)
      {
         highlight2Fg = uVal;
         continue;
      }
      if (stricmp( recID, "Highlight2Bg" ) == 0)
      {
         highlight2Bg = uVal;
         continue;
      }
      if (stricmp( recID, "Highlight3Fg" ) == 0)
      {
         highlight3Fg = uVal;
         continue;
      }
      if (stricmp( recID, "Highlight3Bg" ) == 0)
      {
         highlight3Bg = uVal;
         continue;
      }
      if (stricmp( recID, "HightimeBorFg" ) == 0)
      {
         hightimeBorFg = uVal;
         continue;
      }
      if (stricmp( recID, "HightimeBorBg" ) == 0)
      {
         hightimeBorBg = uVal;
         continue;
      }
      if (stricmp( recID, "HightimeHighFg" ) == 0)
      {
         hightimeHighFg = uVal;
         continue;
      }
      if (stricmp( recID, "HightimeHighBg" ) == 0)
      {
         hightimeHighBg = uVal;
         continue;
      }
      if (stricmp( recID, "HightimeTextFg" ) == 0)
      {
         hightimeTextFg = uVal;
         continue;
      }
      if (stricmp( recID, "HightimeTextBg" ) == 0)
      {
         hightimeTextBg = uVal;
         continue;
      }
      if (stricmp( recID, "InfoWinFg" ) == 0)
      {
         infoWinFg = uVal;
         continue;
      }
      if (stricmp( recID, "InfoWinBg" ) == 0)
      {
         infoWinBg = uVal;
         continue;
      }
      if (stricmp( recID, "MsgLineFg" ) == 0)
      {
         msgLineFg = uVal;
         continue;
      }
      if (stricmp( recID, "MsgLineBg" ) == 0)
      {
         msgLineBg = uVal;
         continue;
      }
      if (stricmp( recID, "StatusLineFg" ) == 0)
      {
         statusLineFg = uVal;
         continue;
      }
      if (stricmp( recID, "StatusLineBg" ) == 0)
      {
         statusLineBg = uVal;
         continue;
      }
      printf( "Invalid configuration record:\n%s\n", copy );
      config_errors = 1;
   }
   fclose(config);
   delete c_record;
   delete copy;
   if (config_errors)
      exit( 1 );

   if (kissTnc)
      tncStartMode = KissMode;
   strcpy( currentSat, bbscall );                // get sat callsign
   strtok( currentSat, "-" );                    // delete ssid
}
