//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __CHGHIGH_H
#include "chghigh.h"
#endif

#ifndef  __TIME_H
#include <time.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __STRING_H
#include "string.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __SCRWRITE_H
#include "scrwrite.h"
#endif

#ifndef  __WIN_H
#include "win.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

void HighTime::adjust( char* ext )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   if (!ext)
      cLine.printRev( "Set hightime: [A]ll, [B]ulletin, [M]ine"
                      " (CR for cancel)" );
   else
   {
      win = new Window( 10, 5, 70, 19, cfg.hightimeTextBg, cfg.hightimeTextFg );
      unsigned long hightime;
      unsigned long systime = time( 0 );
      if (get( &hightime, ext, cfg.workDir ) != 0)
      {
         hightime = systime;
			update( ext, cfg.workDir );
      }
      boxf( 10, 5, 70, 19, cfg.hightimeBorFg, cfg.hightimeBorBg, 2 );
      attrib( 12, 20, 72, 20, LIGHTGRAY, BLACK );
      attrib( 71, 6, 72, 20, LIGHTGRAY, BLACK );
      char * msgBuf = new char[ 80 ];
      sprintf( msgBuf, " Mode: %s.%s ", cfg.currentSat, ext );
      writeat( 31, 5, cfg.hightimeBorFg, cfg.hightimeTextBg, msgBuf );
      writeat( 13, 7, cfg.hightimeBorFg, cfg.hightimeTextBg, "Time Now   :" );
      strcpy( msgBuf, ctime((time_t *) &systime) );
      msgBuf[ strlen( msgBuf )-1 ] = 0;
      writeat( 26, 7, cfg.hightimeTextFg, cfg.hightimeTextBg, msgBuf );
      sprintf( msgBuf, "%s.%s:", cfg.currentSat, ext );
      writeat( 13, 9, cfg.hightimeBorFg, cfg.hightimeTextBg, msgBuf );
      strcpy( msgBuf, ctime((time_t *) &hightime) );
      msgBuf[ strlen( msgBuf )-1 ] = 0;
      writeat( 26, 9, cfg.hightimeTextFg, cfg.hightimeTextBg, msgBuf );
      writeat( 13, 11, cfg.hightimeBorFg, cfg.hightimeTextBg, "Difference :" );
      long hr_diff = difftime( systime, hightime ) / 3600;
      sprintf( msgBuf, "%li Hours", hr_diff );
      writeat( 26, 11, cfg.hightimeTextFg, cfg.hightimeTextBg, msgBuf );
      _setcursortype( _NORMALCURSOR );
      writeat( 13, 13, cfg.hightimeBorFg, cfg.hightimeTextBg,
               "Enter a new ""Difference"" in hours (CR to Quit): " );

      poscursor( 61, 13 );
      msgBuf[ 0 ] = 7;
      cgets( msgBuf );
      hr_diff = 0;
      sscanf( &msgBuf[ 2 ], " %d", &hr_diff );
      if (hr_diff != 0)
      {
         hightime = systime - hr_diff*3600;
         sprintf( msgBuf, "New %s.%s is:", cfg.currentSat, ext );
         writeat( 13, 15, cfg.hightimeBorFg, cfg.hightimeTextBg, msgBuf );
         strcpy( msgBuf, ctime(( time_t *) &hightime) );
         msgBuf[ strlen( msgBuf )-1 ] = 0;
         writeat( 32, 15, cfg.hightimeHighFg, cfg.hightimeHighBg, msgBuf );
         writeat( 11, 18, cfg.hightimeTextBg, cfg.hightimeTextFg,
                  "               <Press Any Key to continue>                 " );
         getch();
         update( ext, cfg.workDir );
      }
      delete msgBuf;
      delete win;
   }
}

void HighTime::update( char* ext, const char* workDir )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   char time_file_name[93];

   sprintf( time_file_name, "%sHIGHTIME.%s", workDir, ext );
   if ((time_file = fopen(time_file_name, "w")) == NULL)
   {
      sprintf( frWin.buf, "Cannot create hightime file <%s>\n", time_file_name);
      frWin.printFatal( frWin.buf );
   }
   fprintf(time_file, "%08lx", hightime);
   fclose(time_file);
}

int HighTime::get( unsigned long* hightime, char* ext, const char* workDir )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   char time_file_name[ MAXPATH ];

   sprintf( time_file_name, "%sHIGHTIME.%s", workDir, ext );
   if ((time_file = fopen(time_file_name, "r")) == NULL)
   {
      sprintf( frWin.buf, "File %s not found", time_file_name );
      frWin.print( frWin.buf );
      return 1;
   }
   if (fscanf(time_file, "%8X", hightime) == 0)
   {
      sprintf( frWin.buf, "get_hightime *** fscanf error for file %s",
                       time_file_name );
      frWin.print( frWin.buf );
      fclose(time_file);
      return 1;
   }
   fclose(time_file);
   return 0;
}

void HighTime::updateToCurrentTime( char* ext, char* workDir )
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
{
   hightime = time(NULL);
   update( ext, workDir );
}
