//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __AXSOCK_H
#include "axsock.h"
#endif

#ifndef  __CONFIG_H
#include "config.h"
#endif

#ifndef  __CONIO_H
#include <conio.h>
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __FTL0USER_H
#include "ftl0user.h"
#endif

#ifndef  __DIRBCST_H
#include "dirbcst.h"
#endif

#ifndef  __FILEBCST_H
#include "filebcst.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

#ifndef  __MSGLINE_H
#include "msgline.h"
#endif

#ifndef  __QUEUE_H
#include "queue.h"
#endif

#ifndef  __SATLINK_H
#include "satlink.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __TIMER_H
#include "timer.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

BeaconMgr::BeaconMgr      ( Config&      cfg,
                            Window&      iWin,
                            Window&      frWin,
                            FTL0User&    ftl0User,
                            char&        bbsAddr,
                            char&        bcstAddr,
                            char&        myAddr,
                            DirBcstMgr&  dbm,
                            FileBcstMgr& fbm,
                            StatusLine&  sLine,
                            StatusList&  sList )
                          :
                            L3Protocol(),
                            iWin( iWin ),
                            frWin( frWin ),
                            ftl0User( ftl0User ),
                            bbsAddr( bbsAddr ),
                            bcstAddr( bcstAddr ),
                            myAddr( myAddr ),
                            dbm( dbm ),
                            fbm( fbm ),
                            sLine( sLine ),
                            sList( sList )
// --------------------------------------------------------------------------
//  Constructor
// --------------------------------------------------------------------------
{
   automode = &cfg.automode;
   bcstPacLen = cfg.bcstPaclen;
   dataWinBg = cfg.dataWinBg;
   exitOnSatCallError = cfg.exitOnSatCallError;
   hideCalls = cfg.hideCalls;
   highlightBg = cfg.highlight1Bg;
   highlightFg = cfg.highlight1Fg;
   idleExitTime = &cfg.idleExitTime;
   monitor = &cfg.monitor;
   mycall = cfg.mycall;
   numCallsToHide = cfg.numCallsToHide;
   setClockToSat = cfg.setClockToSat;
   showData = &cfg.showData;
   showDataHex = &cfg.showDataHex;
   trace = &cfg.trace;
}

void BeaconMgr::recvQFrame( MBuf& mb )
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
{
   mb.data[ mb.cnt ] = 0;                        // make it a string
   char* callPtr = strstr( mb.data, mycall );    // check for mycall

   if (!*trace && *monitor)
   {
      frWin.print( mb.data, mb.cnt );            // display the text
      if (callPtr)                               // if we're in queue
      {                                          // highlight our callsign
         unsigned offset = (unsigned)(callPtr - mb.data);
         frWin.highlight( mb.cnt, offset, strlen( mycall ), highlightFg, highlightBg );
      }
   }

   static Timer* idleTimer = 0;
   static IdleCallUp idleCallUp( *satLink, SatLink::IDLETIMER );
   if (!*automode)                               // if not automatic
   {                                             // downloading
      sLine.autoStatus( "Disabled" );
      delete &mb;

      // If the directory is up-to-date && the exit-when-idle-time is not
      // zero && we haven't already created the idle-timer, then create a
      // timer to hang around for the specifid interval.  Exit the program
      // when the timer expires.

      if (dbm.upToDate && *idleExitTime && !idleTimer)
      {
         long interval = (*idleExitTime - time( 0 )) * 1000;
         if (interval < 5000)
            interval = 5000;
         idleTimer = new Timer( "IdleTimer", idleCallUp, interval );
         idleTimer->start();
      }
      return;
   }
                                                  // if we're not in queue
   unsigned long fileNumber;
   if (!callPtr)
      if ((fileNumber = sList.nextToDownload()) != 0)
      {
         fbm.bcstFileNumber = fileNumber;
         fbm.send( fbm.FILL_FILE_CMD );        // send file request
         sprintf( iWin.buf, "Auto: Fill file %-lx, %u byte frames.",
                            fbm.bcstFileNumber, bcstPacLen );
         iWin.print( iWin.buf );
         sLine.autoStatus( (char*)ultoa( fbm.bcstFileNumber, iWin.buf, 16 ) );
      }
      else
         if (dbm.upToDate)                       // if dir up-to-date
         {
            sLine.autoStatus( "Idle" );

            // If the exit-when-idle-time is not zero && we haven't
            // already created the idle-timer, then create a timer to hang
            // around for the specifid interval.  Exit the program when the
            // timer expires.


            if (*idleExitTime && !idleTimer)
            {
               long interval = (*idleExitTime - time( 0 )) * 1000;
               if (interval < 5000)
                  interval = 5000;
               idleTimer = new Timer( "IdleTimer", idleCallUp, interval );
               idleTimer->start();
            }
         }
         else
            if (dbm.dirRqstWaitTimer->getState() != Timer::Started)
            {                                    // wait tmr not started
               dbm.rqstFill();                  // send dir request
               sLine.autoStatus( "Dir" );
               iWin.print( "Auto: Requesting directory fill." );
            }
            else
               sLine.autoStatus( "Idle" );
   delete &mb;
}

void BeaconMgr::recvIn( Level3Iface& l3If )
// --------------------------------------------------------------------------
// Handle UI and I frames with PID == No Level 3 Protocol
// --------------------------------------------------------------------------
{
   static char PBLIST[] =
   {'P'<<1, 'B'<<1, 'L'<<1, 'I'<<1, 'S'<<1, 'T'<<1, '0'<<1};
   static char PBFULL[] =
   {'P'<<1, 'B'<<1, 'F'<<1, 'U'<<1, 'L'<<1, 'L'<<1, '0'<<1};
   static char BBSTAT[] =
   {'B'<<1, 'B'<<1, 'S'<<1, 'T'<<1, 'A'<<1, 'T'<<1, '0'<<1};
   static clockUpdated = 0;

   MBuf* bp = l3If.bp;                           // data buffer pointer

   // If you want to process the status frames, then this is the place
   // to do it.  Process the data if a flag is set for each type of
   // processing desired.  Trigger the screen to display based on keystrokes
   // allocated to various screens.

   // We need to process PBLIST and BBSTAT frames.  The PID is not set in
   // these frames (there is no Level 3 protocol in use).  To direct the
   // correct higher-level process we use the destination callsign.

   if (Ax25::addrEq( l3If.dest, PBLIST ))
      if (!Ax25::addrEq( l3If.src, &bcstAddr ))
      {
         char call[ 11 ];
         Ax25::pAx25( call, l3If.src );
         sprintf( iWin.buf, "ERROR - Broadcasts from %s heard but ignored.",
                          call );
         iWin.print( iWin.buf );
         delete bp;
         if (exitOnSatCallError)
         {
            iWin.print( "Program exit requested." );
            satLink->exitProgram( SatLink::EXITONSATERROR );
         }
         return;
      }
      else
         recvQFrame( *bp );
   else
   if (Ax25::addrEq( l3If.dest, PBFULL ))
   {
      bp->data[ bp->cnt ] = 0;                   // make it a string
      char *callPtr = strstr( bp->data, mycall );// check for mycall
      if (!*trace && *monitor)
      {
         frWin.print( bp->data, bp->cnt );       // display the text
         frWin.highlight( bp->cnt, 0, bp->cnt, DARKGRAY, dataWinBg );
         if (callPtr)                            // if we're in queue
         {                                       // highlight our callsign
            unsigned offset = (unsigned)(callPtr - bp->data);
            frWin.highlight( bp->cnt, offset, strlen( mycall ), highlightFg, highlightBg );
         }
      }
   }
   else
   if (Ax25::addrEq( l3If.dest, BBSTAT ))
   {
      if (!Ax25::addrEq( l3If.src, &bbsAddr ))
      {
         char call[ 11 ];
         Ax25::pAx25( call, l3If.src );
         sprintf( iWin.buf, "ERROR - BBS from %s heard but ignored.", call );
         iWin.print( iWin.buf );
         delete bp;
         if (exitOnSatCallError)
         {
            iWin.print( "Program exit requested." );
            satLink->exitProgram( SatLink::EXITONSATERROR );
         }
      }
      else
      if (strstr( bp->data, "FULL" ) != NULL)    // BBS queue full
         ftl0User.handleEvent( Event::Rcv_Sat_Full_Frame, *bp );
      else
      if (strstr( bp->data, "Open" ) != NULL)    // BBS queue has space
         ftl0User.handleEvent( Event::Rcv_Sat_Open_Frame, *bp );
      else
      if (strstr( bp->data, "CTRL" ) != NULL)    // BBS not available
         delete bp;
      else
      {
         frWin.print( " ***** unknown BBSTAT frame *****" );
         frWin.print( bp->data, bp->cnt );       // display the text
         delete bp;
      }
   }
   else
   if (strncmp( bp->data, "EIS:<", 5 ) == 0)
   {
      bp->data[ 13 ] = 0;
      long t = strtoul( bp->data + 5, 0, 16 );
      sprintf( iWin.buf, "Sat time - DOS time = %li secs", t - time( 0 ) );
      iWin.print( iWin.buf );
      if (setClockToSat && !clockUpdated)        // set CPU time from sat time
      {
         struct time tm;
         struct date dt;
         unixtodos( t, &dt, &tm );
         setdate( &dt );
         settime( &tm );
         iWin.print( "Clocks set to satellite time." );
         clockUpdated = 1;
      }
      delete bp;
   }
   else
   if (!*trace && *monitor)
   {
      for (int i = 0; i < numCallsToHide; i++)
         if (Ax25::addrEq( l3If.dest, hideCalls[ i ] ))
            break;
      if (i >= numCallsToHide)                // if not a call to hide
         frWin.print( bp->data, bp->cnt );    // display data
      else
         if (*showDataHex)
            frWin.printHex( bp->data, bp->cnt ); // display data in hex
         else
         if (*showData)
            frWin.print( bp->data, bp->cnt );    // display data in non-hex
      delete bp;                                 // deallocate data buffer
   }
   else
      delete bp;                                 // delete it if can't show it
   delete &l3If;                                 // deallocate interface
}

IdleCallUp::IdleCallUp( Object& obj, int exitCode )
                      :
                        CallUp( obj ), exitCode( exitCode )
// -------------------------------------------------------------------------
//  Constructor
// -------------------------------------------------------------------------
{}

void IdleCallUp::func() const
// -------------------------------------------------------------------------
// program exit function
// -------------------------------------------------------------------------
{
   ((SatLink&) obj).exitProgram( exitCode );
}
