//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __AX25OBJ_H
#define  __AX25OBJ_H

#ifndef  __PROTOCOL_H
#include "protocol.h"
#endif

class Level3Iface;

// AX.25 link object.  These are created and destroyed dynamically,
// and are indexed through a connection table.  One exists for each logical
// AX.25 Level 2 connection.  They also exist for non-connected mode service
// but don't appear in the connection table.

class Ax25;
class Ax25ConnTbl;
class Ax25Hdr;
class Ax25User;
class Config;
class Kiss;
class LAPB;
class LinkTable;
class Log;
class MBuf;
class PktQueue;
class Rotor;
class StatusLine;
class Timer;
class FTL0;
class Window;

// AX.25 Connection Table

class Ax25ConnTbl
{
public:
                         Ax25ConnTbl();
                         ~Ax25ConnTbl();
          void           add( Ax25& ax );
          void           del( const Ax25& conn );
          Ax25*          find( char& addr );
          int            validate( Ax25& ax );

private:
          Ax25*          list;
};

class Ax25 : public L2Protocol
{
public:
          // AX.25 Level 3 Protocol IDs (PIDs)

   static enum         { PID_X25        = 0x01,  // CCITT X.25 PLP
                         PID_SEGMENT    = 0x08,  // segmentation fragment
                         PID_BCSTFILE   = 0xbb,  // pacsat file broadcast
                         PID_BCSTDIR    = 0xbd,  // pacsat directory broadcast
                         PID_TEXNET     = 0xc3,  // TEXNET datagram protocol
                         PID_LQ         = 0xc4,  // link quality protocol
                         PID_APPLETALK  = 0xca,  // Appletalk
                         PID_APPLEARP   = 0xcb,  // Appletalk ARP
                         PID_IP         = 0xcc,  // ARPA Internet Protocol
                         PID_ARP        = 0xcd,  // ARPA Address Resolution Protocol
                         PID_NETROM     = 0xcf,  // NET/ROM
                         PID_NO_L3      = 0xf0 };// no level 3 protocol

   static enum         { AX_LOCAL       = 1,     // set by local ax25 route command
                         AX_AUTO        = 2 };   // set by incoming packet

   static enum         { V1             = 1,     // AX.25 Version 1
                         V2             = 2 };   // AX.25 Version 2

          // AX.25 datagram (address) sub-layer definitions

   static enum         { MAXDIGIS       = 7,     // maximum number of digipeaters
                         ALEN           = 6,     // number of chars in callsign field
                         AXALEN         = 7 };   // total AX.25 address length, including SSID
   static enum         { AXBUF          = 10};   // buffer size for maximum-length ascii call

          // Bits within SSID field of AX.25 address

   static enum         { SSID           = 0x1e,  // sub station ID
                         REPEATED       = 0x80,  // has-been-repeated bit in repeater field
                         E              = 0x01,  // address extension bit
                         C              = 0x80 };// command/response designation

          // Link quality report packet header, internal format

   static enum         { LINKVERS       = 1,
                         LQHDR          = 6,
                         LQENTRY        = 11 };

          unsigned       pacLen;
          Config&        cfg;
          char           clone;                  // server-type cb, will be cloned
   static Ax25ConnTbl    connTbl;
          char           local[ AXALEN ];
          Ax25*          next;                   // linked list pointer
          char           remote[ AXALEN ];
          CallUp*        rCallUp;                // receive call up
          CallUp*        sCallUp;                // status change call up
          Ax25User&      user;                   // user pointer
   static Ax25*          ZERO;

                         Ax25( Config&     cfg,
                               Window&     iWin,
                               Window&     frWin,
                               StatusLine& sLine,
                               Ax25User&   user,
                               char&       myAddr,
                               char&       logAddr,
                               Log&        log,
                               Rotor&      antennaControl );
                         ~Ax25();
   static int            addrEq( char* a, char* b );
          unsigned       bytesToSend() const;
          void           connect() const;
   static Ax25&          create( Config&     cfg,
                                 Window&     iWin,
                                 Window&     frWin,
                                 StatusLine& sLine,
                                 L1Protocol& loPro,
                                 char&       myAddr,
                                 char&       addr,
                                 char&       logAddr,
                                 Log&        log,
                                 LinkTable&  linkTbl,
                                 unsigned    window,          // window size in bytes
                                 CallUp&     rCallUp,         // receive call up function
                                 CallUp&     sCallUp,         // status change call up function
                                 CallUp&     tCallUp,         // transmit call up fuction
                                 CallUp&     eCallUp,         // error call up fuction
                                 Ax25User&   user,            // user linkage area
                                 Rotor&      antennaControl );
          void           disconnect() const;
   static unsigned       ftype( unsigned control );
          void           link( L1Protocol& loPro, LinkTable& tbl );
          int            oldState() const;
          int            output() const;
          int            output ( char* dest,   // destination AX.25 address (7 bytes, shifted)
                                  char* source, // source AX.25 address (7 bytes, shifted)
                                  int   pid,    // protocol ID
                                  MBuf& mb );   // data field (follows PID)
   static char*          pAx25( char* e, char* addr );
          void           recvIn( MBuf& mb );
          void           reset() const;
          MBuf&          rxDequeue() const;
          void           rxEnqueue( MBuf& mb ) const;
          int            sendFrame( int cmdrsp, int ctl, MBuf& data );
   static int            setCall( char* out, char* call );
          void           setState( const int state ) const;
   inline int            state() const;
          void           txEnqueue( MBuf& mb ) const;

private:
          Rotor&         antennaControl;
          CallUp*        eCallUp;                // error call up
          Window&        frWin;
          Window&        iWin;
          LAPB*          lapb;
          LinkTable*     linkTbl;
          Log&           log;
          char&          logAddr;
          char*          logCall;
          unsigned*      loggingStatus;
          L1Protocol*    loProto;
          unsigned*      monitor;
          char&          myAddr;
          unsigned       showGrabs;
          unsigned       simulate;
          StatusLine&    sLine;
          CallUp*        tCallUp;                // transmit call up
          unsigned*      trace;

                         // List of AX.25 multicast addresses, e.g.,
                         // "QST   -0" in shifted ASCII

   static char           multi[ 19 ][ AXALEN ];

          int            send( char*   dest,     // destination AX.25 address (7 bytes, shifted)
                               char*   source,   // source AX.25 address (7 bytes, shifted)
                               int     cmdrsp,   // command/response indication
                               int     ctl,      // control field
                               MBuf&   mb     ); // data field (follows PID)

          friend class   LAPB;
          friend class   NoL3FrameMgr;
};

#define  NULAX25 *(Ax25::ZERO);

// Internal representation of an AX.25 header

class Window;

class Ax25Hdr
{
public:
          char           dest[ Ax25::AXALEN ];  // destination address
          char           source[ Ax25::AXALEN ];// source address
          char           digis[ Ax25::MAXDIGIS ][ Ax25::AXALEN ]; // digi string
          int            ndigis;                // number of digipeaters
          int            nextdigi;              // index to next digi in chain
          int            cmdrsp;                // command/response

          void           dump( MBuf& mb, Window& win );
          int            nToH( MBuf& bp );
          MBuf&          hToN( MBuf& bp );
};

// AX.25 routing table entry

class AxRoute
{
public:
          AxRoute*        next;                  // linked list pointer
          char            target[ Ax25::AXALEN ];
          char            digis[ Ax25::MAXDIGIS ][ Ax25::AXALEN ];
          int             ndigis;
          char            type;
   static AxRoute*        ZERO;
};

#define   NULLAXR       *(AxRoute::ZERO)

// Link quality entry, internal format

class lqEntry
{
public:
          char            addr[ Ax25::AXALEN ];  // address of heard station
          long            count;                 // count of packets heard from that station
};

// Link quality database record format.  Currently used only by AX.25
// interfaces

class Lq
{
public:
          Lq*             next;
          char            addr[ Ax25::AXALEN ];  // hardware address of station heard
          long            time;                  // time station was last heard
          long            currxcnt;              // current # of packets heard from this station
          Lq*             ZERO;
};

#define   NULLLQ         *(Lq::ZERO)

class LqHdr {
          int              version;              // version number of protocol
          long             ipAddr;               // sending station's IP address
};

// Structure used to keep track of monitored destination addresses

class Ld
{
          Ld*             next;                  // linked list pointers
          char            addr[ Ax25::AXALEN ];  // hardware address of destination overheard
          long            time;                  // time station was last mentioned
          long            currxcnt;              // current # of packets destined to this station
   static Ld*             ZERO;
};

#define   NULLLD *(Ld::ZERO)

#endif __AX25OBJ_H