//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// AX25 header conversion routines

#ifndef  __ALLOC
#include <alloc.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __AX25OBJ_H
#include "ax25obj.h"
#endif

#ifndef  __LAPB_H
#include "lapb.h"
#endif

#ifndef  __MSGBUF_H
#include "msgbuf.h"
#endif

MBuf& Ax25Hdr::hToN( MBuf& mb )
// -------------------------------------------------------------------------
//  Convert a host-format AX.25 header into a MBuf ready for transmission
// -------------------------------------------------------------------------
{
   if (ndigis > Ax25::MAXDIGIS)
      return NULBUF;

   int i = Ax25::AXALEN * (2 + ndigis);          // allocate space for
   mb.pushDown( i );                             // return buffer

   char* cp = mb.data;                           // now convert cp -> dest field

   memcpy( cp, dest, Ax25::AXALEN );             // generate destination field
   if (cmdrsp == LAPB::COMMAND)
      cp[ Ax25::ALEN ] |= Ax25::C;               // command frame sets C bit in dest
   else
      cp[ Ax25::ALEN ] &= ~Ax25::C;
   cp[ Ax25::ALEN ] &= ~Ax25::E;                 // dest E-bit is always off

   cp += Ax25::AXALEN;                           // cp -> source field

   memcpy( cp, source, Ax25::AXALEN );           // generate source field
   if (cmdrsp == LAPB::RESPONSE)
      cp[ Ax25::ALEN ] |= Ax25::C;
   else
      cp[ Ax25::ALEN ] &= ~Ax25::C;
   if (ndigis == 0)                              // set E bit on source address if no digis
   {
      cp[ Ax25::ALEN ] |= Ax25::E;
      return mb;
   }

   cp += Ax25::AXALEN;                           // cp -> first digi field

   // All but last digi get copied with E bit off

   for (i = 0; i < ndigis; i++)
   {
      memcpy(cp, digis[i], Ax25::AXALEN);
      if (i < ndigis - 1)
         cp[Ax25::ALEN] &= ~Ax25::E;
      else
         cp[Ax25::ALEN] |= Ax25::E;              // last digipeater has E bit set
      if(i < nextdigi)
         cp[Ax25::ALEN] |= Ax25::REPEATED;
      else
         cp[Ax25::ALEN] &= ~Ax25::REPEATED;
      cp += Ax25::AXALEN;                        // cp -> next digi field
   }
   return mb;
}

int Ax25Hdr::nToH( MBuf& mb )
// -------------------------------------------------------------------------
//  Convert a network-format AX.25 header into a host format structure.
//  Return -1 if error, number of addresses if OK
// -------------------------------------------------------------------------
{
   if (mb.pullUp( dest, Ax25::AXALEN ) < Ax25::AXALEN)   // pull off destination
      return -1;
   if (mb.pullUp( source, Ax25::AXALEN ) < Ax25::AXALEN) // pull off source
      return -1;

   // Process C bits to get command/response indication

   if ((source[ Ax25::ALEN ] & Ax25::C) == (dest[ Ax25::ALEN ] & Ax25::C))
      cmdrsp = LAPB::UNKNOWN;
   else
      if(source[ Ax25::ALEN ] & Ax25::C)
         cmdrsp = LAPB::RESPONSE;
      else
         cmdrsp = LAPB::COMMAND;

   ndigis = 0;
   nextdigi = 0;
   if (source[ Ax25::ALEN ] & Ax25::E)
      return 2;                                  // no digis

   // Count and process the digipeaters

   char* axp = digis[ 0 ];
   while (ndigis < Ax25::MAXDIGIS)
   {
      if (mb.pullUp( axp, Ax25::AXALEN  ) < Ax25::AXALEN)
         return -1;
      ndigis++;
      if(axp[ Ax25::ALEN ] & Ax25::REPEATED)
         nextdigi++;
      if(axp[ Ax25::ALEN ] & Ax25::E)            // last one
         return ndigis + 2;
      axp += Ax25::AXALEN;
   }
   return -1;                                    // too many digis
}
