//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

// --------------------------------------------------------------------------
//  Asynchronous Interface Object Class
//
//  This object class is derived from a hardware interface object class.
//  AsyncIntf provides a stand interface between SatLink and callable serial
//  port driver functions.  The purpose of this class is to permit anyone to
//  readily adapt different driver functions without having to dig into the
//  SatLink proper functions.
//
//  The current version of SatLink uses serial port functions that I developed.
//  The callable functions are contained in the files ASY.*.  All that was
//  necessary to do to switch from the commercial library to my functions was
//  to modify the code in ASYINTF.CPP to call different functions.
//
//  I originally developed SatLink using a commercial serial port library.
//  The AsyncIntf class implementation using this library is contained in
//  ASYINTF.CP0.  To use this version you need the library from Blaise
//  Communications.  The functions in this library are more comprehensive,
//  robust, and efficient than my own, but my functions are good enough.
//  My TNC doesn't talk to the computer at 155 kilobaud!
//
//  Arguably, there is some calling overhead from AsyncIntf class functions
//  to the lower level callable functions.  However, at the speeds SatLink
//  will be operating, this shouldn't be a problem.  I could have written
//  some of the underlying code in assembler, but don't really have the
//  performance improvement need to justify the effort.
// --------------------------------------------------------------------------

#ifndef  __ASYINTF_H
#define  __ASYINTF_H

#ifndef  __HWDEVICE_H
#include "hwdevice.h"
#endif

class Asy;

class AsyncIntf : public HwDevice
{
public:
            unsigned    overflowErr;
            unsigned    overrunErr;
            unsigned    parityErr;
            unsigned    framingErr;

                        AsyncIntf( unsigned& showDataHex, const unsigned port);
                        ~AsyncIntf();
            unsigned    bufLeft( const char io ) const;
            int         close();
            int         dataReady();
            unsigned    errCnt();
            int         flush( const char ) const;
            int         open();
            int         open( const unsigned inSize,
                              const unsigned outSize,
                              const unsigned irq,
                              const unsigned addr,
                              const unsigned recvOutSize );
            int         params( const unsigned baud,
                                const char pty,
                                const unsigned data,
                                const unsigned stop);
                           // trigger the receiver to execute the
                           // receive function
            void        poll();
                           // get from the receiver a pointer to an MBuf that
                           // the receiver created and filled with input
            int         recvOut( MBuf*& );
                           // get from the receiver a character of input
            int         recvOut( char& );
                           // get back from the receiver the input filled
                           // character array that the caller provides
            int         recvOut( char*, const unsigned, unsigned & );
            int         recvOutW( char& ) const;
            int         set( enum devVal param, const unsigned long value );
            void        waitForClear();
            int         send( MBuf& );
            int         send( const char );
            int         send( const char*, const unsigned );
            int         sendW( const char );

private:
            Asy*        asy;
            int         inQSize;
            int         outQSize;
            char*       ioBuffer;
            unsigned    recvOutSize;
   const    unsigned    speed;                   // defaults
   const    char        parity;
   const    unsigned    dataBits;
   const    unsigned    stopBits;
};

#endif  __ASYNINTF_H
