//
// This file contains proprietary information of Jesse Buckwalter.
// Copying or reproduction without prior written approval is prohibited.
//
// Copyright (c) 1993, 1994, 1995
// Jesse Buckwalter
// 525 Third Street
// Annapolis, MD 21403
// (410) 263-8652
//

#ifndef  __ACTLIST_H
#include "actlist.h"
#endif

#ifndef  __DIR_H
#include <dir.h>
#endif

#ifndef  __DOS_H
#include <dos.h>
#endif

#ifndef  __ERRNO_H
#include <errno.h>
#endif

#ifndef  __STDIO_H
#include <stdio.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __ACTFILE_H
#include "actfile.h"
#endif

#ifndef  __DIRECTRY_H
#include "directry.h"
#endif

#ifndef  __FILEBCST_H
#include "filebcst.h"
#endif

#ifndef  __MISC_H
#include "misc.h"
#endif

#ifndef  __PFHEADER_H
#include "pfheader.h"
#endif

#ifndef  __SLIST_H
#include "slist.h"
#endif

#ifndef  __WINDOW_H
#include "window.h"
#endif

ActList::ActList( Window&     fiWin,
                  Window&     iWin,
                  Window&     frWin,
                  char*       dlDir,
                  Directory*  dir,
                  StatusList* sList,
                  unsigned    makeBat,
                  char*       bats1,
                  char*       bats2,
                  unsigned    silent,
                  unsigned    maxPfhSize )
                :
                  fiWin( fiWin ),
                  iWin( iWin ),
                  frWin( frWin ),
                  accessesCounter( 0 ),
                  bats1( bats1 ),
                  bats2( bats2 ),
                  dir( dir ),
                  dlDir( dlDir ),
                  makeBat( makeBat ),
                  maxPfhSize( maxPfhSize ),
                  silent( silent ),
                  sList( sList )
// --------------------------------------------------------------------------
//  Constructor; create an ActList object
// --------------------------------------------------------------------------
{
	theList = new ActFile*[ 10 ];
   if (!theList)
      frWin.printFatal( "Out of memory" );
   for (int i = 0; i < 10; i++)
      theList[ i ] = 0;
}

ActList::~ActList()
// --------------------------------------------------------------------------
//  Destructor
// --------------------------------------------------------------------------
{
   ActFile* file;
   for (int i = 0; i < 10; i++)
      if ((file = theList[ i ]) != 0)
      {
         unsigned long fileNumber = file->fileNumber;
         int action = removeFile( file->position );
         switch (action)
         {
            case ActFile::PURGE:
               sprintf( iWin.buf, "Purging file %-lx", fileNumber );
               break;
            case ActFile::SAVE:
               sprintf( iWin.buf, "Writing HOL file for %-lx", fileNumber );
         }
         iWin.print( iWin.buf );
      }
   delete theList;
}

ActFile* ActList::addFile( const unsigned long fileNumber )
// --------------------------------------------------------------------------
//  Add a file to the activity list
// --------------------------------------------------------------------------
{
   ActFile* file = onList( fileNumber, 0 );
   if (file)
      return file;
   int position = nextSpace();
   file = new ActFile( dlDir, fileNumber, position, dir, silent,
                       maxPfhSize, fiWin, iWin, frWin );
   if (!file)
      frWin.printFatal( "Out of memory" );
   theList[ position ] = file;
   file->accessCount = ++accessesCounter;        // track its accesses
   file->open();                                 // open the file
   return file;
}

void ActList::addToBatchFile( const unsigned long fileNumber )
// -------------------------------------------------------------------------
//  Add the file to the post-program batch file
// -------------------------------------------------------------------------
{
   static char* batchFileName = 0;
   if (!batchFileName)
   {
      batchFileName = new char[ 80 ];
      if (batchFileName)
         sprintf( batchFileName, "%sPOSTPASS.BAT", dlDir );
   }
   FILE* batchFile;
   if ((batchFile = fopen( batchFileName, "at" )) == 0)
   {
      sprintf( frWin.buf, "Cannot open file %s, %s", batchFileName,
                                                  sys_errlist[ errno ] );
      frWin.print( frWin.buf );
      return;
   }
   sprintf( frWin.buf, "%s %-lx%s\n", bats1, fileNumber, bats2 );
   fputs( frWin.buf, batchFile );
   fclose( batchFile );
}

void ActList::completionCheck( ActFile* file )
// -------------------------------------------------------------------------
// check if file is complete and process it if it is
// -------------------------------------------------------------------------
{
   if (!file->complete())
      return;
   unsigned long fileNumber = file->fileNumber;
   if (removeFile( file->position ) == ActFile::COMPLETE)
   {
      sprintf( iWin.buf, "File %-lx downloaded", fileNumber );
      iWin.print( iWin.buf );
      if (makeBat)
         addToBatchFile( fileNumber );
      sList->set( fileNumber, sList->DOWNLOADED );  // indicate downloaded
      dir->setStatus( fileNumber, sList->DOWNLOADED );
   }
}

void ActList::display()
// --------------------------------------------------------------------------
//  Display the directory headers of the files on the file list in the info
//  window;
// --------------------------------------------------------------------------
{
   iWin.clear();
   for (int i = 0; i < 10; i++)
      if (theList[ i ])
         theList[ i ]->display();
}

int ActList::nextSpace()
// --------------------------------------------------------------------------
//  If there is not space on the activity list, delete the least active file.
//  Return an index to the vacant space.
// --------------------------------------------------------------------------
{
   unsigned long lowCount = 0xffffffffL;
   int mostIdleIndex = -1;

   ActFile* file;
   for (int i = 0; i < 10; i++)
   {
      file = theList[ i ];
      if (!file)                                 // if there's space
         return i;
      if (file->accessCount < lowCount)          // if it's more idle
      {
         mostIdleIndex = i;
         lowCount = file->accessCount;           // make it the new lowest
      }
   }
   removeFile( mostIdleIndex );
   return mostIdleIndex;
}

ActFile* ActList::onList( const unsigned long fileNumber,
                          const unsigned      errMsg      )
// --------------------------------------------------------------------------
//  Determine if a file is on the activity list.  Return a pointer to it if
//  it is, otherwise return 0.  If it is not on the list and the errMsg flag
//  is raised, display the error message.
// --------------------------------------------------------------------------
{
   ActFile* file;
   for (int i = 0; i < 10; i++)
      if ((file = theList[ i ]) != 0)
         if (file->fileNumber == fileNumber)
         {
            file->accessCount = ++accessesCounter;  // track its accesses
            return file;
         }
   if (errMsg)
   {
      sprintf( frWin.buf, "ActList missing file <%lx> entry", fileNumber );
      frWin.print( frWin.buf );
   }
   return 0;
}

int ActList::removeFile( const unsigned index )
// --------------------------------------------------------------------------
//  Remove a file from the activity list.
// --------------------------------------------------------------------------
{
   if (index >= 10)
      frWin.printFatal( "Index exceeds list size" );
   ActFile* file = theList[ index ];
   if (!file)
      frWin.printFatal( "Attempting to remove null file from list" );
   int status;
   int blockedFlag;
   sList->status( file->fileNumber, status, blockedFlag );
   int action;
   if (status != StatusList::AUTOMATIC && status != StatusList::PRIORITY &&
       blockedFlag > 0)
      action = ActFile::PURGE;                   // purge if blocked file type
   else                                          
      if (file->complete())
         action = ActFile::COMPLETE;
      else
         action = ActFile::SAVE;
   file->close( action );
   delete file;
   theList[ index ] = 0;
   fiWin.clearLine( index + 2 );
   return action;
}

void ActList::purgeFiles( const char* dir )
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
{
   char* fileName = new char[ MAXPATH ];
   if (!fileName)
      frWin.printFatal( "Out of memory" );
   for (int i = 0; i < 1000; i++)
   {
      StatusRec* rp = sList->theArray[ i ];
      if (rp->status == StatusList::NEVER)
      {
         sprintf( fileName, "%s%-lx.*", dir, rp->fileNumber);
         int done;
         struct ffblk ffblk;
         if ((done = findfirst( fileName, &ffblk, 0 )) != 0)
            continue;
         sprintf( iWin.buf, "Purging file %-lx", rp->fileNumber );
         iWin.print( iWin.buf );
         while (!done)
         {
            strcpy( fileName, dir );
            strcat( fileName, ffblk.ff_name );
            if (remove( fileName ) != 0)
            {
               sprintf( frWin.buf, "Error deleting <%s>, %s", fileName,
                        sys_errlist[errno]) ;
               frWin.print( frWin.buf );
            }
            done = findnext( &ffblk );
         }
      }
   }
   delete fileName;
}

void ActList::purgeOldFiles( const char*       dlDir,
                             const unsigned    actDays,
                             const StatusList* sList   )
// -------------------------------------------------------------------------
//  Write holes from hole list to .HOL file.
// -------------------------------------------------------------------------
{
   // Purge incomplete files that are older than the activity date interval

   struct date d;
   getdate( &d );
   struct time t;
   gettime( &t );
   long curTime = dostounix( &d, &t );

   char         fileName1[ MAXPATH ];
   char         fileName2[ MAXPATH ];
   struct ffblk ffblk;
   strcpy( fileName1, dlDir );
   strcat( fileName1, "*.ACT");

   char* buf = new char[ 64 ];
   if (!buf)
      frWin.printFatal( "Out of memory" );
   if (findfirst( fileName1, &ffblk, 0 ) == 0)
      do
      {
         d.da_year = (ffblk.ff_fdate >> 9) + 1980;
         d.da_mon =  (ffblk.ff_fdate & 0x01E0) >> 5;
         d.da_day =  (ffblk.ff_fdate & 0x001F);
         t.ti_hour = (ffblk.ff_ftime >> 11);
         t.ti_min =  (ffblk.ff_ftime & 0x07E0) >> 5;
         t.ti_sec =  (ffblk.ff_ftime & 0x001F);
         long dosTime = dostounix( &d, &t );
         if (curTime > dosTime + actDays * 86400L)         // compare secs
         {
            int status = sList->status( strtoul( ffblk.ff_name, 0, 16 ) );
            if (status != StatusList::AUTOMATIC &&
                status != StatusList::PRIORITY)
            {
               sprintf( iWin.buf, "Removing file %s", ffblk.ff_name );
               iWin.print( iWin.buf );
               strcpy( fileName2, dlDir );
               strcat( fileName2, ffblk.ff_name );
               remove( fileName2 );
               memcpy( fileName2 + strlen( fileName2 ) - 3, "HOL", 3 );
               remove( fileName2 );
               memcpy( fileName2 + strlen( fileName2 ) - 3, "OLH", 3 );
               remove( fileName2 );
            }
         }
      } while (findnext( &ffblk ) == 0);
   delete buf;
}

void ActList::save( const FileFrInfo& fr )
// --------------------------------------------------------------------------
//  Save the data in an activity file.
// --------------------------------------------------------------------------
{
   ActFile* file = addFile( fr.file_number );     // make sure it's on the list
   if (!file)
      return;
   if (file->needData( fr.offset, fr.dlen, fr.flag )) // is the data needed?
      file->update( fr.offset, fr.data, fr.dlen );// save the data
   file->display( fr.offset );                   // display the activity
   completionCheck( file );                      // process completed files
}

