/*****************************************************************************/
/*	         							     */
/*									     */
/*    *****			  ***** 				     */
/*	 *****			*****					     */
/*	   *****	      *****					     */
/*	     *****	    *****					     */
/*  ***************	  ***************				     */
/*  *****************	*****************				     */
/*  ***************	  ***************				     */
/*	     *****	    *****	   TheNet       		     */
/*	   *****	      *****	   Portable. Compatible.	     */
/*	 *****			*****	   Public Domain		     */
/*    *****			  *****    NORD><LINK	 		     */
/*									     */
/* This software is public domain ONLY for non commercial use                */
/*                                                                           */
/*									     */
/*****************************************************************************/

/* Level 7, Utilities							     */
/* Version 1.01								     */
/* Hans Georg Giese, DF2AU, Hinter dem Berge 5, 3300 Braunschweig	     */
/* 14-MAY-88								     */

/* G8KBB April 1991 - add register keyword to compress code
 *                  - use all.h header file
 *                  - use putnum_and_space optionally on MODIFIED
 *                  - make putnbr() optionally show alias:callsign
 *
 * September 1993 - released as TheNet X-1J
 *
 * Add optional support for TexNet on declaration of TEXNET
 */

#include "all.h"
#include "tntyp.h"		/* Definition der Typen			     */
#include "tnl7ue.h"		/* externe Definitionen			     */

/*---------------------------------------------------------------------------*/
VOID	kilusr()		/* User abwerfen			     */
  {
  register mhtyp *bufpoi;	/* MBHD fuer Meldungen			     */

  if ((bufpoi = userpo->mbhd) != 0) /* noch Info im Buffer?		     */
    dealmb(bufpoi);		/* dann vernichten			     */

  dealoc(unlink(userpo));	/* User Kontrollblock auch wieder frei	     */
  userpo = 0;			/* Userpointer ungueltig machen		     */
  }

/*---------------------------------------------------------------------------*/
VOID	invcal()		/* ungueltiges Rufzeichen melden	     */
  {
  putmsg("Invalid Call");
  }

/*---------------------------------------------------------------------------*/
VOID	makcon(usrp)		/* Verbindung melden, Eintrag herstellen     */
register usrtyp *usrp;				/* Userkontrollblock		     */
  {
  msgfrm('U', (ptcrdp->luserl = usrp->cblk_u),
              (ptcrdp->lusert = usrp->typ_u), conmsg);
  }

/*---------------------------------------------------------------------------*/
VOID	msgfrm(seite, link, user, msg) /* Systemstatus melden		     */
unsigned seite;			/* Uplink - Downlink			     */
register unsigned user;		/* Usertyp: 0=Host, 2=Level2, 4=Circuit	     */
register ctyp *link;		/* Kontrollblock des Users		     */
char	 *msg;			/* Meldung				     */
  {
  register mhtyp *bufpoi;			/* MBHD der Meldung	     */

  bufpoi = putals(msg);				/* Meldung ausgeben	     */
  if (seite == 'D')				/* Downlink?		     */
   {
    if (user == 4)				/* User ist Circuit?	     */
      putalt(link->l3blk.l3node->nodide, bufpoi);	/* dann Ident vorweg	     */
    else					/* Level2 oder Host?	     */
     if (user == 0)
       putalt(alias, bufpoi);			/* bei Host auch Ident	     */
   }
  putid(calofs(seite, link, user), bufpoi);	/* Call immer ausgeben	     */
  seteom(bufpoi);				/* Ende Kennung dazu	     */
  }

/*---------------------------------------------------------------------------*/
VOID	puttfu(name)		/* Tabelle voll melden			     */
char	*name;			/* Tabellenname				     */
  {
  register mhtyp *bufpoi;	/* MBHD der Meldung			     */

  putstr(" table full", (bufpoi = putals(name))); /* Meldung		     */
  seteom(bufpoi);		/* Ende Kennung dazu			     */
  }

/*---------------------------------------------------------------------------*/
VOID	putmsg(string)		/* Meldung an User ausgeben		     */
char	*string;
  {
  seteom(putals(string));	/* Meldung mit Endekennung raus		     */
  }

/*---------------------------------------------------------------------------*/
mhtyp	*putals(string)		/* String nach Nodeident in neuen Buffer     */
char	*string;		/* Rueckgabe: Pointer auf neuen Buffer	     */
  {
  register mhtyp *bufpoi;	/* neuer Buffer				     */

  bufpoi = (mhtyp *) allocb();		/* neuen Buffer holen		     */
  bufpoi->l2lnk = userpo->cblk_u; /* Level2 Kontrollblock in Buffer eintragen*/
  bufpoi->usrtyp = userpo->typ_u; /* Usertyp				     */

  putalt(alias, bufpoi);	/* Ident schreiben			     */
  putid(myid, bufpoi);		/* Call schreiben			     */
  putstr("} ", bufpoi);		/* Trennzeichen				     */
  putstr(string, bufpoi);	/* String dazu				     */
  return(bufpoi);
  }

/*---------------------------------------------------------------------------*/
VOID	putrou(neigbp, mbhdp)	/* Weg zu einem Nachbarn ausgeben	     */
nbrtyp  *neigbp;			/* Pointer auf den Nachbarn	     */
mhtyp   *mbhdp;				/* Buffer fuer die Meldung	     */
  {
  register nbrtyp  *neigb;		/* Pointer auf den Nachbarn	     */
  register mhtyp   *mbhd;		/* Buffer fuer die Meldung	     */

  neigb = neigbp;
  mbhd = mbhdp;
  putstr((neigb->nbrl2l == NULL)? "\015 " : "\015>", mbhd); /* aktiver Weg?  */
  putnbr(neigb, mbhd);				/* Nachbarn ausgeben	     */
  putchr(' ', mbhd);				/* Leerraum		     */
#ifdef MODIFIED
  putnum_and_space((neigb->pathqu & 0xff), mbhd); /* Qualitaet des Weges     */
#else
  putnum((neigb->pathqu & 0xff), mbhd);		/* Qualitaet des Weges	     */
  putchr(' ', mbhd);				/* Leerraum		     */
#endif
  putnum(neigb->nbrrou, mbhd);			/* Zahl der Links	     */
  if (neigb->locked == TRUE)			/* Eintrag blockiert?	     */
    putstr(" !", mbhd);				/* dann markieren	     */
  }

/*---------------------------------------------------------------------------*/
VOID	putnbr(neigbp, mbhdp)	/* Daten eines Nachbarn ausgeben	     */
nbrtyp  *neigbp;			/* Pointer auf den Nachbarn	     */
mhtyp   *mbhdp;				/* Buffer fuer die Meldung	     */
  {
  register nbrtyp  *neigb;		/* Pointer auf den Nachbarn	     */
  register mhtyp   *mbhd;		/* Buffer fuer die Meldung	     */
#ifdef MODIFIED
  register nodtyp  *despoi;		/* pointer for finding alias */
#endif

  neigb = neigbp;
  mbhd = mbhdp;
  putchr(' ', mbhd);			/* Trennzeichen			     */
#ifndef MODIFIED
  putnum(neigb->nbrpor, mbhd);		/* Port Nummer			     */
  putchr(' ', mbhd);			/* Trennzeichen			     */
#else
  putnum_and_space(neigb->nbrpor, mbhd);	/* Port Nummer		     */
  if( hlpflg & 0x10 )				/* if node alias display on */
    for( despoi = (nodtyp *)destil.lnext;	/* step thru node table until*/
         (nodtyp *)&destil != despoi;		/* match found. */
         despoi = (nodtyp *)despoi->nodlnk.lnext )
      if( cmpid( neigb->nbrcal, despoi->nodcal )) /* If match found, then */
      {
        putalt( despoi->nodide, mbhd );		  /* display alias */
        break;
      }
#endif
  putid(neigb->nbrcal, mbhd);		/* Call				     */
  putdil(neigb->nbrdil, mbhd);		/* Digiliste			     */
  }

/*---------------------------------------------------------------------------*/
VOID	putuse(seite, linkp, typ, mbhdp) /* User Daten in MBHD legen	     */
mhtyp	 *mbhdp;			/* Kopf der Messageliste		     */
unsigned typ;			/* Usertyp: 0=Host, 2=Level2, 4=Circuit	     */
ctyp	 *linkp;			/* Kontrollblock			     */
unsigned seite;			/* L=uplink, R=downlink			     */
  {

  register ctyp *link;
  register mhtyp *mbhd;
  register unsigned i;

  mbhd = mbhdp;
  link = linkp;

  switch (typ) {
/*==============================*/
  case 4:			/* User ist Circuit			     */
    putstr("Circuit(", mbhd);
    putalt(link->l3blk.l3node->nodide, mbhd); /* Node ID			     */
    putid_and_space(link->l3blk.downca, mbhd);	/* Node Call				     */
    putid(link->l3blk.upcall, mbhd);	/* User Call				     */
    putchr(')', mbhd);		/* Ende dieser Seite			     */
    break;

/*==============================*/
  case 2:			/* User ist Level2			     */
    if (seite == 'L') {		/* Uplink oder Downlink?		     */
#ifdef TEXNET
      i = link->l2blk.realid[0] & 0xff;
      i = ( i != 0 && i != 0xff );
      putstr( i ? "TexNet(" : "Uplink(", mbhd);
      putid(link->l2blk.dstid, mbhd);	/* User Call				     */
      if( i )
      {
        putchr( ' ', mbhd );
        putid( link->l2blk.realid, mbhd );
      }
#else
      putstr("Uplink(", mbhd);	/* Uplink:				     */
      putid(link->l2blk.dstid, mbhd);	/* User Call				     */
#endif
      putchr(')', mbhd);
      }
    else {			/* Downlink:				     */
      putstr("Downlink(", mbhd);
      putid_and_space(link->l2blk.srcid, mbhd);	/* User Call				     */
      putid(link->l2blk.dstid, mbhd);	/* Gegenstation				     */
      putchr(')', mbhd);
      }
    break;

/*==============================*/
  default:			/* User ist Host			     */
    putstr("Host(", mbhd);
    putalt(alias, mbhd);	/* Host ID				     */
    putid(myid, mbhd);		/* Host Call				     */
    putchr(')', mbhd);
    break;
    }
  }

/*---------------------------------------------------------------------------*/
VOID	putdil(liste, mbhd)	/* Digiliste in MBHD legen		     */
register mhtyp	*mbhd;		/* Kopf der Messageliste		     */
register char	*liste;		/* Digiliste, 0 am Ende			     */
{
  if (*liste != 0) {		/* existiert die Liste?			     */
    putstr(" via", mbhd);
    while (*liste != 0) {	/* so lange der Vorrat reicht		     */
      putchr(' ', mbhd);	/* Trennzeichen				     */
      putid(liste, mbhd);	/* Digi ausgeben			     */
      liste += 7;		/* naechster Digi			     */
    }
  }
}

/*---------------------------------------------------------------------------*/
VOID	putid(call, mbhd)	/* Call mit SSID in MBHD legen		     */
register mhtyp	*mbhd;		/* Kopf der Messageliste		     */
char	*call;			/* Call					     */
  {
  register char	   zeichen;	/* Scratch bei Ausgabe			     */
  register unsigned cnt;	/* zaehlt Zeichen			     */
  char	   ssid;		/* SSID des Calls			     */

  for (cnt = 6; cnt != 0; --cnt) { /* 6 Zeichen Call			     */
    zeichen = *call++;		/* naechstes Zeichen holen		     */

    if (zeichen > ' ')		/* druckbar?				     */
      putchr(zeichen, mbhd);	/* dann raus				     */

    else {			/* nicht druckbar:			     */
      if (zeichen < ' ') {	/* Leerzeichen uebergehen		     */
        putchr('^', mbhd);	/* Kontrollzeichen mit Prefix		     */
        putchr((zeichen + '@'), mbhd);
        }
      }
    }
  ssid = (*call >> 1) & 0x0f;	/* SSID passend schieben		     */
  if (ssid != 0) {		/* nur SSID != 0 ausgeben		     */
    putchr('-', mbhd);		/* mit Trennstrich			     */
    putnum(ssid, mbhd);
    }
  }

/*---------------------------------------------------------------------------*/
VOID	putnod(mbhd)		/* Knoten Info in MBHD legen		     */
register mhtyp	*mbhd;		/* Kopf der Messageliste		     */
{
  putalt(despoi->nodide, mbhd);	/* Ident ausgeben			     */
  putid(despoi->nodcal, mbhd);	/* und Call				     */
}

/*---------------------------------------------------------------------------*/
VOID	putalt(ident, mbhd)	/* Ident in Buffer MBHD legen		     */
register mhtyp	*mbhd;		/* Kopf der Messageliste		     */
register char	*ident;		/* auszugebender Ident			     */
{
  if (*ident != ' ') {		/* ueberhaupt definiert?		     */
    putcal(ident, mbhd);	/* dann ausgeben			     */
    putchr(':', mbhd);		/* Trennzeichen hinterher		     */
  }
}

/*---------------------------------------------------------------------------*/
VOID	putcal(call, mbhd)	/* Call in Buffer MBHD legen		     */
mhtyp	*mbhd;			/* Kopf der Messageliste		     */
char	call[];			/* auszugebendes Call			     */
  {
  register char	   zeichen;	/* Scratch fuer aktuelles Zeichen	     */
  register unsigned cnt;	/* Zaehler fuer Zeichen im Call		     */

  for (cnt = 0; cnt < 6; ++cnt) { /* Call ist immer 6 Zeichen lang	     */
    zeichen = call[cnt];
    if (zeichen == ' ')		/* Leerzeichen nicht ausgeben		     */
      break;
    putchr(zeichen, mbhd);
    }
  }

/*---------------------------------------------------------------------------*/
VOID	putnum(zahl, mbhd)	/* Zahl in Buffer MBHD legen		     */
mhtyp	 *mbhd;			/* Kopf der Messageliste		     */
unsigned zahl;			/* auszugebende Zahl			     */
  {
  unsigned notnul;		/* fuehrende Null j/n			     */
  register unsigned diviso;	/* Stellenwert der aktuellen Stelle	     */
  register unsigned ziffer;	/* aktuelle Ziffer			     */
  register unsigned numcnt;	/* Zahl der ausgegebenen Ziffern	     */

  notnul = 0;
  diviso = 10000;
  for(numcnt = 5; numcnt != 0; --numcnt) {
    ziffer = zahl / diviso;
    if ((ziffer != 0) || (notnul /*== 1*/) || (diviso == 1)) {
      putchr((ziffer + '0'), mbhd); /* Stelle ausgeben			     */
      notnul = 1;
      }
    zahl %= diviso;
    diviso /= 10;
    }
  }

/*---------------------------------------------------------------------------*/
VOID	putstr(string, mbhd)	/* String in Buffer MBHD legen		     */
register char	*string;	/* auszugebender String			     */
register mhtyp	*mbhd;		/* Kopf der Messageliste		     */
  {
  while (*string != 0) {	/* so lange der Vorrat reicht		     */
    putchr(*string++, mbhd);	/* weg damit				     */
    }
  }

/*---------------------------------------------------------------------------*/
VOID	putspa(stop, mbhd)	/* bis stop die Zeile mit Space fuellen	     */
unsigned stop;				/* Ende der Leerraeume		     */
register mhtyp    *mbhd;		/* Buffer der Meldung		     */
  {
  register unsigned cnt;		/* Scratch Zaehler		     */

  cnt = mbhd->l4time + stop - mbhd->putcnt;
  if( cnt > 128 ) 
    return;
  while (cnt--)
   {
    putchr(' ', mbhd);
   }
  }

/*---------------------------------------------------------------------------*/
unsigned skipspace()
{
	return( skipsp( &clicnt, &clipoi ) );
}

/*---------------------------------------------------------------------------*/
unsigned nextnumber()
{
	return( nxtnum(&clicnt, &clipoi) );
}

/*---------------------------------------------------------------------------*/
BOOLEAN getqua()
  {
   return (
              (skipspace() )
           && ((nquali = nextnumber() ) <= 255)
          );
  }


/*---------------------------------------------------------------------------*/
BOOLEAN getpar()		/* Parameter fuer Ziel holen		     */
  {
   return (
             (skipspace() )
           && ((nport = nextnumber() ) < NUMPORTS)
           && (getcal(&clicnt, &clipoi, VCpar, ncall) == TRUE)
           && (getdig(&clicnt, &clipoi, FALSE, ndigi) != ERROR)
           );
  }

/*---------------------------------------------------------------------------*/
getdig(laenge, inbuf, pflag, outbuf)          /* Digiliste aus Buffer holen  */
unsigned *laenge;		/* Laenge des Eingabebuffers		     */
char	 *(*inbuf);		/* Eingabebuffer			     */
char     pflag;			/* Call-pruefen Flag			     */
char	 *outbuf;		/* Ziel fuer das Call			     */
  {
  char	   liste[8*7 +1];	/* Zwischenspeicher			     */
  char	   *ibufer;		/* Kopie von inbuf			     */
  unsigned ilaeng;		/* Kopie von laenge			     */
  register unsigned zeichen;	/* Scratch				     */
  register char	   *lispoi;	/* Pointer in liste			     */
  register unsigned cnt;	/* Zaehler, Scratch			     */
  unsigned caltyp;		/* Typ des letzten Call: 0=leer, -1=niO, 1=OK*/

  ibufer = *inbuf;		/* eine Indirektion weniger		     */
  ilaeng = *laenge;
  if (getcal(&ilaeng, &ibufer, 0, liste) == 1) { /* Call da?		     */
    lispoi = liste;		/* koennte "VIA" vorher sein		     */
    if (*lispoi++ == 'V') {	/* stimmt erstes Zeichen?		     */
      for (cnt = 0; cnt < 5; ++cnt) { /* ja: max 5 Zeichen testen	     */
        zeichen = *lispoi++;	/* naechstes Zeichen			     */
        if (zeichen != ' ') {	/* Ende von "VIA"?			     */
          if (!((cnt == 0) && (zeichen == 'I') ||
              (cnt == 1) && (zeichen == 'A')))
            break;		/* Rechtschreibung muss stimmen		     */
          }
        }
      if (cnt == 5) {		/* VIA + ' ' = 4			     */
        *inbuf = ibufer;	/* wenn nicht VIA gefunden, korrigieren	     */
        *laenge = ilaeng;
        }
      }
    }

  for (cnt = 8, lispoi = liste; cnt != 0; --cnt, lispoi +=7)
   {						/* maximal 8 Digis	     */
    if (*laenge != 0)
     {
      if (((zeichen = *(*inbuf)) == '+')
         ||(zeichen == '-'))
        break;
     }
    if ((caltyp = getcal(laenge, inbuf, pflag, lispoi)) == -1) /* ungueltig? */
      return(-1);				/* Abbruch		     */
    if (caltyp == 0) break;			/* nichts mehr da: Ende	     */
   }

  *lispoi = 0;					/* Endekennung		     */
  cpyidl(outbuf, liste);			/* in Ziel kopieren	     */
  return(*outbuf != 0);				/* Erfolg melden	     */
  }

/*---------------------------------------------------------------------------*/
getcal(laenge, inbuf, pflag, outbuf) /* Call aus Buffer holen		     */
unsigned *laenge;		/* Laenge des Eingabebuffers		     */
char	 *(*inbuf);		/* Eingabebuffer			     */
char	 pflag;			/* Call-pruefen Flag			     */
char	 *outbuf;		/* Ziel fuer das Call			     */
  {
  char	   call[7];		/* Zwischenspeicher			     */
  register char	   binsid;	/* SSID, binaer				     */
  register char	   *bufpoi;	/* Pointer in Call			     */
  register char	   zeichen;	/* Scratch				     */
  unsigned cnt;			/* Zaehler, Scratch			     */

  bufpoi = call;		/* auf Anfang				     */
#ifdef MODIFIED
  cpy6ch( bufpoi, nulide );
  bufpoi[6] = 0x60;
#else
  for (cnt = 0; cnt < 6; ++cnt)	/* Zwischenspeicher loeschen		     */
    *bufpoi++ = ' ';
  *bufpoi = 0x60;		/* kein SSID				     */
#endif

  skipsp(laenge, inbuf);	/* auf erstes Zeichen != ' '		     */

  bufpoi = call;		/* wieder nach vorn			     */
  cnt = 0;			/* gelesene Zeichen = 0			     */
  while (*laenge != 0) {	/* so lange Zeichen da sind		     */
    if (((zeichen = upcase(*(*inbuf)))/* und gueltig			     */
       == ' ' ) || (zeichen == ',')) break;
    if (zeichen < ' ') return(ERROR);
    if (zeichen == '-') {	/* Trennung zum SSID?			     */
      if ((cnt == 0) || (*laenge == 0))
        return(ERROR);		/* Fehler: kein Call oder SSID		     */
      ++(*inbuf);		/* Trennung uebergehen			     */
      --(*laenge);
      if (*laenge == 0) return (ERROR); /* SSID angesagt, kommt aber nicht   */
      zeichen = *(*(inbuf));	/* erste Ziffer SSID holen		     */
      if ((zeichen < '0') || (zeichen > '9'))
        return(ERROR);		/* ungueltige Ziffer			     */
      ++(*inbuf);
      --(*laenge);		/* Ziffer ist verbraucht		     */
      binsid = (zeichen + 0xffd0); /* Binaer merken			     */
      if (*laenge != 0) {	/* noch Zeichen da?			     */
        zeichen = *(*inbuf);	/* holen				     */
        if ((zeichen >= '0') && (zeichen <= '9')) { /* gueltige Ziffer?	     */
          binsid *= 10;		/* erste Ziffer eine Stelle nach links	     */
          binsid += (zeichen + 0xffd0) ; /* + neue Ziffer		     */
          if (binsid > 15)
            return(ERROR);		/* ungueltiger SSID		     */
          ++(*inbuf);		/* letzte Ziffer verbrauchen		     */
          --(*laenge);
          }
        }
      call[6] = (binsid << 1) | 0x60; /* SSID merken			     */
      break;
      }
    else {			/* kein SSID, anderes Zeichen		     */
      if (cnt++ == 6)
        return(ERROR);		/* Call zu lang				     */
      *bufpoi++ = zeichen;	/* Zeichen merken			     */
      ++(*inbuf);		/* Lesepointer rauf			     */
      --(*laenge);
      }
    }
				/* Call ist im Buffer			     */
  while (*laenge != 0) {	/* Rest des Buffers ansehen		     */
    zeichen = *(*inbuf);	/* Zeichen holen			     */
    if ((zeichen != ' ') && (zeichen != ','))
      break;			/* kein Trennzeichen, stop		     */
    ++(*inbuf);			/* naechstes Zeichen			     */
    --(*laenge);
    if (zeichen == ',') break;	/* Leerraum uebergehen			     */
    }
  if (cnt == 0) return(0);	/* Call war leer			     */
  if (fvalca(pflag, call) == ERROR)
    return(ERROR);			/* Call war ungueltig		     */
  cpyid(outbuf, call);		/* Call kopieren			     */
  return(1);			/* ok melden				     */
  }

/*---------------------------------------------------------------------------*/
unsigned getide(buffer)		/* Ident aus cli-Buffer holen		     */
char	buffer[];		/* -1=kein Erfolg, 0=leer, 1=Erfolg	     */
  {
  char	   ident[6];		/* Zwischenspeicher			     */
  register char	   zeichen;	/* Scratch				     */
  register unsigned cnt;	/* Zaehler, Scratch			     */

  cpy6ch(ident, nulide);			/* Zwichenspeicher loeschen  */

  for (cnt = 0; (cnt < 6) && (clicnt != 0); ++cnt)
    {
      zeichen = *clipoi;/* Zeichen aus CLI-Buffer holen	     */
      nxtcli();
#ifdef MODIFIED
      if( !(hlpflg & 0x40 ))
#endif
        zeichen = upcase( zeichen );
      if (zeichen != ' ')		/* Schluss bei Trennzeichen	     */
        {
          if (((zeichen >= 'A') && (zeichen <= 'Z'))
             || ((zeichen >= '0') && (zeichen <= '9'))
#ifdef MODIFIED
             || ((zeichen >= 'a') && (zeichen <= 'z'))
#endif
             || ((cnt == 0) && (zeichen == '#'))) /* gueltiges Zeichen?	     */
            {
              ident[cnt] = zeichen;
              continue;
            }
          if ((cnt != 0) || (zeichen != '*')) return(-1); /* '*' als Ident   */
        }
      break;
    }

  if ((cnt == 6) && (clicnt != 0) && (*clipoi) != ' ')
    return(-1);			/* Ident zu lang? Fehler melden		     */

  if (valcal(ident) == 1)
    return(-1);			/* Ident darf kein Call sein		     */

  cpy6ch(buffer, ident);			/* umkopieren		     */

  return(ident[0] != ' ');
  }

/*---------------------------------------------------------------------------*/
unsigned nxtnum(laenge, buffer)	/* Zahl aus Buffer holen		     */
register char	 *(*buffer);	/* Buffer				     */
register unsigned *laenge;	/* Laenge des Buffers			     */
  {
  register unsigned temp;	/* Scratch				     */

  skipsp(laenge, buffer);	/* auf erstes Zeichen != ' '		     */
  temp = 0;			/* Ergebniss = 0			     */
  while ((*laenge != 0) && (*(*buffer) >= '0') && (*(*buffer) <='9')) {
    --*laenge;			/* mitzaehlen				     */
    temp *= 10;			/* Ergebniss eine Stelle weiter		     */
    temp += (*(*buffer)++ + 0xffd0);/* + naechstes Digit		     */
    }
  return (temp);		/* mit Ergebniss zurueck		     */
  }

/*---------------------------------------------------------------------------*/
fvalca(pflag, call)		/* Call pruefen: 0=leeres call, ohne Flag    */
register char	*call;			/* -1=niO (m. Flag), 1=ok oder o. Flag	     */
BOOLEAN pflag;
  {
  if (*call == ' ' ) return(0);	/* leer					     */
  if (!pflag) return (1);	/* nicht pruefen			     */
  return (valcal(call));	/* pruefen, valcal liefert Ergebniss	     */
  }

/*---------------------------------------------------------------------------*/
valcal(call)			/* Call auf Gueltigkeit pruefen		     */
char	*call;			/* -1=ungueltiges Zeichen, 1=Call ist ok     */
  {
  char	   *numpos;		/* Position der Zahl im Call		     */
  register char	   *actual;	/* Pointer auf aktuelles Zeichen	     */
  register char	   zeichen;	/* aktuelles Zeichen			     */
  register unsigned cnt;	/* gepruefte Zeichen			     */
  unsigned zahl;		/* Zahlen im Call			     */

  for (
    zahl = 0,			/* keine Zahl gefunden			     */
    cnt = 6,			/* nichts geprueft			     */
    actual = call;		/* auf Anfang				     */
    cnt != 0;			/* maximal 6 Zeichen Call		     */
    --cnt, ++actual) {
    if ((zeichen = *actual) == ' ') /* Ende des Calls?			     */
      break;
    if (!((zeichen >= 'A') && (zeichen <= 'Z'))){ /* Alfa ist immer gut	     */
      if ((zeichen >= '0') && (zeichen <= '9')) {
        zahl += 1;		/* Zahlen zaehlen			     */
        numpos = actual;	/* Position merken			     */
      }
      else return(-1);		/* ungueltiges Zeichen im Call		     */
      }
    }
  if (
       ((actual - call) < 4)	/* minimal 4 Zeichen			     */
    || (zahl == 0)		/* mindestens 1 Zahl			     */
    || (zahl > 2)		/* maximal 2 Zahlen			     */
    || (numpos == call)		/* keine Zahl an erster Stelle		     */
    || (numpos == (actual -1)))	/* mindestens 2 Buchstaben Suffix	     */
    return(-1);			/* Call ist ungueltig			     */
  else return(1);		/* Call ist gueltig			     */
  }

/*---------------------------------------------------------------------------*/
BOOLEAN ismemr()		/* Test auf genuegend freien Speicher	     */
  {
  if((nmbfre < 256) && (!userpo->sysflg))	/* Platz oder Sysop?	     */
   {
    putmsg("Node busy");
    return(FALSE);
   }
#ifdef MODIFIED
  cpyid(usrcal, this_station() );
#else
  cpyid(usrcal, calofs('U', userpo->cblk_u, userpo->typ_u));
#endif
  return(TRUE);
  }

/*---------------------------------------------------------------------------*/
VOID setl2b()			/* User Kontrollblock aufbauen		     */
  {
  userpo->cblk_p = lnkpoi;			/* Pointer auf L2-Block	     */
  userpo->typ_p = 2;				/* Partner ist L2	     */
  userpo->status = 2;				/* Status: connect laeuft    */
  cpyid(lnkpoi->srcid, usrcal);			/* Call eintragen	     */
  }

/*---------------------------------------------------------------------------*/
char *calofs(seite, link, user)	/* Offset Call-String im Kontrollblock	     */
unsigned user;			/* Usertyp: 0=Host, 2=L2-User, 4=Circuit     */
register ctyp	 *link;			/* Linkkontrollblock			     */
unsigned seite;			/* Seite der Verbindung: U=uplink, D=downlink*/
  {
  register unsigned char i;

  if (user == 4) {		/* Circuit?				     */
    return ((seite == 'D') ?	/* welche Seite?			     */
      link->l3blk.downca : link->l3blk.upcall);
    }
  if (user == 2)		/* L2-User?				     */
  {
#ifdef TEXNET
    if( seite != 'D' )
      return( ( i = link->l2blk.realid[0] ) != 0 && i != 0xff ?
              link->l2blk.realid : link->l2blk.dstid );
    else
#endif
    return(link->l2blk.dstid);
  }
  else return(myid);		/* muss Host sein			     */
  }

/*---------------------------------------------------------------------------*/
BOOLEAN getlin(mbhdp)		/* Zeile im Messagebuffer verfuegbar?	     */
mhtyp	*mbhdp;
  {
register char	 *nextch;	/* naechstes Zeichen			     */
register unsigned getcou;	/* verfuegbare Zeichen			     */
BOOLEAN  found;			/* Flag: Ueberlauf			     */
unsigned laenge;		/* Laenge der Zeile			     */
register mhtyp	*mbhd;
  
  mbhd = mbhdp;

  nextch = mbhd->nxtchr;	/* Pointer auf naechstes Zeichen	     */
  getcou = mbhd->getcnt;	/* verfuegbare Zeichen			     */
  found = FALSE;		/* default: Zeile nicht da		     */
  laenge = 0;			/* Laenge initialisieren		     */
  while (mbhd->getcnt < mbhd->putcnt) { /* so lange Vorrat reicht	     */
    if (((getchr(mbhd) & 0x7f) == 0x0d) /* Zeichen = Zeilenende?	     */
      || (++laenge == 81)){	/* Zeile zu lang?			     */
      found = TRUE;		/* markieren				     */
      break;
     }
    }
  mbhd->nxtchr = nextch;	/* MBHD auf alte Werte zurueck		     */
  mbhd->getcnt = getcou;
  return (found);
  }

/*---------------------------------------------------------------------------*/
invsid()			/* SSID umdrehen			     */
  {
  usrcal[6] = 0x7e - (usrcal[6] & 0x1e);
  }

/*---------------------------------------------------------------------------*/
BOOLEAN issyso()		/* Test auf Sysop Attribut		     */
  {
  return (
             (userpo->sysflg == TRUE )
          && (skipspace() ) /* kein Sysop ohne Eingabe   */
         );
  }

/*---------------------------------------------------------------------------*/
unsigned skipsp(laenge, string)	/* in String auf naechstes Zeichen != ' '    */
register unsigned *laenge;	/* Laenge des String, wird korrigiert	     */
register char	 *(*string);	/* die Adresse des Kandidaten		     */
  {
  while ((*laenge != 0) && (*(*string) == ' ')) {
    ++*string;
    --*laenge;
    }
  return (*laenge != 0);
  }

/*---------------------------------------------------------------------------*/
#ifndef BANKED
VOID timer()			/* alle 10ms Uhrzeit erhoehen		     */
  {
  ++tic10;
  }
#endif

/*---------------------------------------------------------------------------*/
unsigned skipnext(laenge, string)	/* skip over != ' ' & to char != ' ' */
register unsigned *laenge;		/* Laenge des String, wird korrigiert*/
register char	 *(*string);		/* die Adresse des Kandidaten	     */
  {
  while ((*laenge != 0) && (*(*string) != ' ')) {
    ++*string;
    --*laenge;
    }
  return ( skipsp( laenge, string ) );
  }

/*---------------------------------------------------------------------------*/
/* small utility to save some space - bump line pointer counters
 */
#ifdef PORTABLE
VOID nxtcli()
{
	clicnt--;
	clipoi++;
}

#else
#asm
	public nxtcli_
nxtcli_: lhld clipoi_		; clipoi++
	inx h
	shld clipoi_
	lhld clicnt_		; clicnt--
	dcx h
	shld clicnt_
	ret
#endasm
#endif


/*---------------------------------------------------------------------------*/

VOID putid_and_space( ident, bufpoi )
register mhtyp *bufpoi;
char *ident;
{
			putid( ident, bufpoi );
			putchr( ' ', bufpoi );
}

/* -----------------------------------------------------------------------
 * Block_code is used tro replace the '-' characters in <--> if one
 * or other patchcord entry is choked.
 */
 
#ifdef CHOKE_FLAGS

block_code( link, type, mbhd )
ctyp *link;
unsigned type;
mhtyp *mbhd;
{
	register unsigned i = '-';
	
	switch( type )
	{
		case 2:
			if( link->l2blk.flag & L2FBUSY )
				i = 'C';
			break;
		case 4:
			switch( link->l3blk.l4flag & 0x60 )
			{
				case 0x40:
					i = 'L';
					break;
				case 0x20:
					i = 'R';
					break;
				case 0x60:
					i = 'C';
			}
	}
	putchr( i, mbhd );
}

#endif
