/*****************************************************************************/
/*	         							     */
/*									     */
/*    *****			  ***** 				     */
/*	 *****			*****					     */
/*	   *****	      *****					     */
/*	     *****	    *****					     */
/*  ***************	  ***************				     */
/*  *****************	*****************				     */
/*  ***************	  ***************				     */
/*	     *****	    *****	   TheNet       		     */
/*	   *****	      *****	   Portable. Compatible.	     */
/*	 *****			*****	   Public Domain		     */
/*    *****			  *****    G8KBB	 		     */
/*									     */
/* This software is public domain ONLY for non commercial use                */
/*                                                                           */
/*									     */
/*****************************************************************************/

/* 
 * released as TheNet X-1J September 1993
 */
 
#ifdef BANKED
#define EXTERN
#define VARIABLES
#include "all.h"
#include "tntyp.h"
#include "tnl3v.h"
#include "tnl4v.h"
#include "miscv.h"
#include "tnl7av.h"
#ifdef IPROUTE
#include "ip.h"
#include "ipv.h"
#endif

char	nulide[] =				/* leerer Ident		     */
                   {' ',' ',' ',' ',' ',' '};

char	beades[] = { 'I','D',' ',' ',' ',' ','\140' }; /* Call fuer Bake     */
char	cqdest[] = { 'C','Q',' ',' ',' ',' ','\140' }; /* Call fuer CQ-Ruf   */
char	cqdil[]  = "";				    /* Digiliste fuer CQ-Ruf */
char    L4audit[] = "L4    `";
char    L2audit[] = "L2    `";

#ifdef MANAGED
char AudCon[] = "C ";
char AudConAcc[] = "CA";
char AudDisc[] = "D ";
char AudDiscAcc[] = "DA";
#endif

#ifdef PORTABLE

/* The timer() routine is called every 10 milliseconds.
 * The portable version does NOT support the ancilliary
 * functions of l1 stats and cwid
 */

VOID timer()
{
	++tic10;
}

/* The stop() routine is used to halt the system upon
 * closedown. WARNING - the portable version does not
 * correctly initialise the SIO - so it may stop with
 * the ptt enabled !!!!!!
 */

VOID stop()
{
	DIinc();
loop: goto loop;
}

#else
#asm
	.z80
SIADAT	equ	0
SIACTL	equ	1
SIBDAT	equ 2
SIBCTL	equ 3

	extrn SIAIW5, SIBIW5
	public stop_
stop_:
	di
	ld	A,5
	out	(SIACTL),A
	ld	A,(SIAIW5)
	out	(SIACTL),A
	ld	A,5
	out	(SIBCTL),A
	ld	A,(SIBIW5)
	out	(SIBCTL),A
	halt
	jr stop_

	public timer_
	extrn tic10_, SIAWR5, SIARR0, txon_, dcdon_
	extrn cwtimr_

timer_:	
	ld hl,(tic10_)		; bump the 10 millisecond counter
	inc hl
	ld (tic10_), hl
#endasm
#ifdef STATSCMD
#asm
	ld	a,(SIAWR5)	; test for RTS on HDLC port, ie PTT is ON
	bit	1,a		; ( ie the rig is on xmit )
	jr	z,td		; If not, go try the receiver
	ld	hl,(txon_)	; If so, bump the TX on counter
	inc	hl
	ld	(txon_),hl	; Just in case we have digital DCD a la BSX,
	jr	rd		; skip over RX test coz it is off if TX is on.
td:	ld	a,(SIARR0)	; Now check the DCD line
	bit	3,a		; to see if the RX is on
	jr	z,rd		; If not, skip over
	ld	hl,(dcdon_)	; If so, bump DCD counter
	inc	hl
	ld	(dcdon_),hl
rd:
#endasm
#endif
#ifdef CWID
#asm
	ld	A,(cwtimr_)	; ckeck CW timer. Zero means it is not running
	or	A		; so if it tests zero, just skip over.
	jr	z,timer0
	dec	A		; If it is not zero, then decrement it and
	ld	(cwtimr_),A	; store the new value. Also, if it has
	call 	Z,cwidbit	; reached zero, then go get the next bit
#endasm
#endif
#asm
timer0:	ret
#endasm

#endif	/* PORTABLE */

#endif	/* BANKED */

#ifdef CWID
#asm
	.z80
	extrn	cwstate_, cwbit_, cwofs_, cwdat_, cwch_, cwtimr_, cwspeed_
	extrn	xFpar_, Dpar_, HRXRES, HTXSTA, SIAINI, SIAIEN

	global calper_,1
	global caltog_,1
	global caltog,1

cwidbit:
	ld	HL,cwstate_	; POINT TO STATE REGISTER
	ld	A,(HL)		; CHECK CURRENT STATE
	cp	80h		; if 80h, then we are calibrating
	jp	z, calib
	cp	0		; if 0, fall thru the next jumps...
	jp	M,cwbitx	; If '-1', awaiting start of send
	jr	NZ,cwbit2	; If not zero ( 1 or 2 ) sending a delay
	ld	A,(cwbit_)	; read current char bits remaining counter
	or	A		; check if at end ( ie zero )
	jr	NZ,cwbit0	; if not, continue sending this char
	ld	A,(cwofs_)	; otherwise we need the next char, so get offs
	inc	A		; and point to the next character
	ld	(cwofs_),A	; store new offset for next time
	ld	HL,cwdat_	; now add offset to start of data table
	ld	E,A
	ld	D,0
	add	HL,DE		; so HL now points to next data entry
	ld	A,(HL)		; and read from it the character data,
	and	1fh		; which is in the lower 5 bits only.
	ld	(cwch_),A	; and store it in the char holding variable
	ld	A,(HL)		; get character again for the bits variable
	rla			; move the contents of the top 3 bits to
	rla			; the bottom 3 bits of the accumulator
	rla			; so that the number of bits is in
	rla			; the low 3 bits of A.
	and	7		; Now select only the 3 bits
	ld	(cwbit_),A	; store bit count
	or	A		; If zero, we are at the end of the callsign
	ld	A,0		; (just extend the delay if end of character)
	jr	NZ,cwbit7	; if not end of call, send inter char delay
	ld	A,2		; signal end of callsign by setting state to 2
cwbit7:	ld	(cwstate_),A	; and dropping thru into the delay anyway.
	ld	A,(cwspeed_)	; send a two bit delay period by reading speed
	sla	A		; doubling it and setting the tick timer
	jr	cwbit3

cwbit0:	dec	A		; continue sending this char, decrement bit
	ld	(cwbit_),A	; counter and store it
	ld	A,1		; set state to '1' for next time round
	ld	(HL),A
	ld	HL,cwspeed_	; point to CWID speed bit value
	ld	A,(cwch_)	; read current character data
	ld	E,A		; store it in E temporarily
	bit	0,E		; check if LSB set. If so DASH not DOT
	ld	A,(HL)		; set speed as for a dot
	jr	Z,cwbit1	; and if it was a dash fall thru and treble it
	sla	A		; by doubling and
	add	A,(HL)		; adding the original again
cwbit1:	ld	D,A		; put delay period value in D temorarily
	ld	A,0feh
	out	(SIADAT),A
	ld	A,E		; get current character data back again
	srl	A		; move to the next bit
	ld	(cwch_),A	; and restore the character data
	ld	A,D		; get delay period back again
	jr	cwbit3

cwbit2:	push	AF		; save state number whilst toggling tone
	ld	A,0feh		; send a single zero bit to toggle tone
	out	(SIADAT),A	; by writing out a data byte
	pop	AF		; restore state
	dec	A		; A contains state. If it was 1, go to cwbit4
	jr	Z,cwbit4	; otherwise fall thru to 'stop'
; cwstop
cwstop:	ld	A,3		; state 3 means 'i have finished'.
	ld	(cwstate_),A
	ld	HL,SIAINI	; reset and initialise the channel.
	ld	BC,SIACTL or ((SIAIEN-SIAINI)<<8)
	otir
	xor	A		; next state of the HDLC Tx is 'idle'
	ld	(HTXSTA),A
	ld	A,5		; access write register 5
	out	(SIACTL),A
	ld	HL,SIAWR5
	res	1,(HL)		; and kill the PTT signal
	ld	A,(xFpar_)
	or	A
	jr	NZ,cwbit9
	res	3,(HL)
cwbit9:	ld	A,(HL)
	out	(SIACTL),A
	ld	A,(Dpar_)
	or	A
	call	Z,HRXRES
	jr	cwbitx

; delay sending routine

cwbit4:	ld	(HL),A		; set next state from A register
	ld	A,(cwspeed_)	; read cw speed value to give single dot delay
cwbit3:	ld	(cwtimr_),A	; set the timer count to required delay
cwbitx:	ret

; This is the TNC calibrate routine

calib:	ld	hl,calper_	; decrement the 1 second counter
	dec	(hl)		; If it is zero, then stop sending
	jr	z,cwstop	; Otherwise, continue another second
	ld	hl,caltog	; Now decrement the toggle period counter
	dec	(hl)		; and if it is zero
	jr	nz,calib0
	ld	a,(caltog_)	; then reset the counter to the start value
	ld	(hl),a
	ld	a,0feh		; and toggle the o/p tone
	out	(SIADAT),a
calib0:	ld	a,100		; and wake me in 10ms * 100, ie 1 second
	jr	cwbit3

SIACWI:	db	018h,4,0,5,0e2h,3,0d9h,6,0ffh,7,0ffh,1,19h,10h
SIACIX:

	public	cwkick

cwkick:	ld	A,11
	ld	(HL),A
	ld	HL,SIACWI
	ld	BC,SIACTL or ((SIACIX-SIACWI)<<8)
	otir
	ld	A,5
	out	(SIACTL),A
	ld	A,(SIAWR5)
	res	0,A
	out	(SIACTL),A
	in	A,(SIACTL)
	ld	(SIARR0),A
	ld	A,(cwstate_)	; see if we are to calibrate or cwid
	cp	-2		; state of (-2) means calibrate
	jr	nz, cwkik0
	ld	a,(caltog_)	; initialise toggle period to the value
	ld	(caltog),a	; set by the sysop
	ld	A,80h		; set next state to 80h ( calibrating )
	jr	cwkik1
cwkik0:	xor	A
cwkik1:	ld	(cwstate_),A
	ld	A,50
	ld	(cwtimr_),A
	ret

#endasm
#endif


/**************************************************************************\
*                                                                          *
* "copy memory from place to place"                                        *
*                                                                          *
* WARNING - ANSI version handles overlapping memory. this does not         *
*                                                                          *
\**************************************************************************/
#ifndef PORTABLE
#asm
	public memcpy_		;memcpy(dest,source,count)
memcpy_:
	push	bc		; save BC register as we use it
	ld	hl,9		; point to top of params ( count )
	add	hl,sp
	ld	b,(hl)		; BC contains count
	dec	hl
	ld	c,(hl)
	dec	hl
	ld	d,(hl)		; DE contains destination for now
	dec	hl
	ld	e,(hl)
	dec	hl
	ld	a,(hl)
	dec	hl
	ld	l,(hl)		; HL has source address but ....
	ld	h,a
	ex	de,hl		; swap DE & HL registers
	ldir
	pop	bc
	ret

#endasm
#endif

/**************************************************************************\
*                                                                          *
* "compare memory at two locations"                                        *
*                                                                          *
* WARNING - assembly versions of cmpid & cmpcal jump INTO this procedure ! *
\**************************************************************************/
#ifndef PORTABLE
#asm
	public compare_		;compare(id1, id2, count )
compare_:
	push	bc		; save BC register as we use it
	ld	hl,9		; point to top of params ( count )
	add	hl,sp
	ld	b,(hl)		; BC contains count
	dec	hl
	ld	c,(hl)
	dec	hl
	ld	d,(hl)		; DE contains one address
	dec	hl
	ld	e,(hl)
	dec	hl
	ld	a,(hl)
	dec	hl
	ld	l,(hl)		; HL has second address
	ld	h,a
c0:	ld	a,(de)
	cpi
	jr	nz, c1
	inc	de
	jp	pe,c0
c4:	ld	hl,1
	jr	c2
c1:	ld	hl,0
c2:	ld	a,h
	or	l
	pop	bc
	ret

	public cmpcal_
cmpcal_:	push bc
	ld	hl,7		; point to top of params ( count )
	add	hl,sp
	ld	d,(hl)		; DE contains count
	dec	hl
	ld	e,(hl)
	dec	hl
	ld	a,(hl)
	dec	hl
	ld	l,(hl)		; HL has second address
	ld	h,a
	ld  a,(de)
	cp  32
	jr  z,c1
	ld  a,(hl)
	cp  32
	jr  z,c1
	ld  bc,6
	jr  c0

	public cmpid_
cmpid_:	push bc
	ld	hl,7		; point to top of params ( count )
	add	hl,sp
	ld	d,(hl)		; DE contains count
	dec	hl
	ld	e,(hl)
	dec	hl
	ld	a,(hl)
	dec	hl
	ld	l,(hl)		; HL has second address
	ld	h,a
	ld  bc,6
c3:	ld	a,(de)
	cpi
	jr	nz, c1
	inc	de
	jp	pe,c3
	ld  a,(de)
	and 30
	ld  b,a
	ld  a,(hl)
	and 30
	cp  b
	jr  nz,c1
	jr  c4


#endasm
#endif
