/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    version.h  -   Headerfile to tailor version                           *
*                                                                          *
\**************************************************************************/

/* Compile time switch definitions :
 * WARNING - not all combinations will work. They have grown like topsy
 *           and have been designed to allow variants to be built, but
 *           this has never been tested for most permutations. If you
 *           find errors, tell me !
 *           The most basic is MODIFIED - this must always be present
 *           unless you want the original version. Simplest thing is
 *           to define MAXVERSION which puts it all in !
 *
 *           The PORTABLE keyword enables the use of Z80 assembler
 *           versions of some modules. If it is not used, some
 *           features will be omitted so it must be used for the Z80.
 *           If other versions are included though, it will need to be
 *           rewritten as, for example 'Z80_TNC2' to distinguish types
 *
 *    MAXVERSION - include almost all the rest !
 *    PORTABLE   - do not use assembly language versions of modules
 *    BANKED     - Split the code in two for bank switching in TNC2
 *    NODOWNLINK - bar the use of downlinking connect commands
 *    NOCQ       - remove from the code the CQ command
 *    FIRMWARE   - compile TheFirmware rather than TheNet
 *    STATSCMD   - include level 1 stats info
 *    MANAGED    - include the management commands and collection routines
 *    HOSTMODE   - include hardware handshake host ctrl, BBS and HOST cmds
 *    KISSMODE   - include rs232 kiss driver code
 *    TALKCMD    - include conferencing command
 *    MONITORCMD - include the MHEARD command and collection routines
 *    CWID       - include  CWID keyer code
 *    DXCLUSTER  - include this only if HOSTCMD is defined
 *    CLOSEDOWN  - include closedown command
 *    ACL        - include access control list and related functions
 *    METERS     - include the ADC stuff
 *    MOD_MTU    - include the s/w settable MTU parameters and command
 *    INTEGRITY  - include the linked list integrity checking routines
 *    IPROUTE    - include the IP router and related bits.
 *
 * Released as TheNet X-1J, September 1993
 *
 *    TEXNET     - include TexNet interface code
 */

#define NOHILOW

/*                                                         Festlegungen   */
/**************************************************************************/

                              /* Portnummern :                            */
#ifdef FIRMWARE
#define NUMPORTS    1
#define MAXPORTMASK 1
#else
#define HDLCPORT    0         /*   Packet-Port                            */
#define ASYNPORT    1         /*   RS232 Crosslink-Port                   */
#define NUMPORTS    2         /* Total number of ports                    */
#define MAXPORTMASK 3         /* mask to AND with a port number           */
#endif

/* Definitions that control the compiled version
 */

#ifdef MAXVERSION
#define LINKSCMD
#define MONITORCMD
#define STATSCMD
#define HOSTMODE
#define KISSMODE
#define TALKCMD
#define CWID
#define MANAGED
#define DXCLUSTER
#define CLOSEDOWN
#define ACL
/* #define ACL_DISCMD_OVERRIDE */
#define IPROUTE
#define INTEGRITY
#define MOD_MTU
/* #define METERS */
#define TEXNET
#define MODIFIED
#define PORTFLUSH
#define L3MONITOR
#define CHOKE_FLAGS
#endif

#ifdef MODIFIED
#define MODBYSTRING "\015\012By DF2AU/DC4OX/G8KBB\015\012"
#ifndef SIGNONTEXT
#define SIGNONTEXT "TheNet X-1J4 [PK-96] "
#endif
#endif


#ifdef METERS
/* The following apply to meterflags variable - unused in pk-96
 */
#define ADC 0x20
#define CH3_START 6
#define CH4_START 7

#endif

