/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    L2V.C   -   Level 2, globale Variable                                 *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:                                                          *
*                                                                          *
*                                                                          *
* September 1993 - released as TheNet X-1J                                 *
*                                                                          *
* Released as TheNet X-1J release 4, January 1995                          *
\**************************************************************************/





/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "tntyp.h"       /* Festlegungen/Datenstrukturen fuer den Level 2 */





/*                                                              Globals   */
/**************************************************************************/

char        myid[L2IDLEN];    /* Call (normal) + SSID (1 Bit linksgesch.) */
char        alias[L2CALEN];   /* Ident der Station                        */

#ifndef FIRMWARE
char        istraf[L2PNUM];   /* != 0 -> Frame gesendet                   */
#endif

char        nmblks;           /* Anzahl aktiver Level-2-Links (1..127)    */
char        Ypar;             /* Anzahl moeglicher Links (Y-Befehl)       */
char        Vpar;             /* 0 = Linkaufbau mit Version 1 Protokoll   */
                              /* 1 = Linkaufbau mit Version 2 Protokoll   */
                              /* (V-Befehl)                               */
                              
                              /* empfangenes Frame :                      */
char        rxfhdr[L2AFLEN+1];/*   Header (Ziel/Quell/via-Id's), 0-term.  */
char        rxfctl;           /*   Kontrollbyte ohne P/F-Bit              */
char        rxfPF;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x10 = P/F gesetzt, 0 sonst  */
char        rxfV2;            /*   0 = V1-Frame, 1 = V2-Frame             */
char        rxfCR;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x80 = Command-Frame         */
                              /*             0x00 = Response-Frame        */
char        rxfprt;           /*   0 = HDLC-Frame, 1 = Crosslink-Frame    */
                              
                              /* zu sendendes Frame :                     */
char        txfhdr[L2AFLEN+1];/*   Header (Ziel/Quell/via-Id's), 0-term.  */
char        txfctl;           /*   Kontrollbyte ohne P/F-Bit              */
char        txfPF;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x10 = P/F gesetzt, 0 sonst  */
char        txfV2;            /*   0 = V1-Frame, 1 = V2-Frame             */
char        txfCR;            /*   V1-Frame: 0                            */
                              /*   V2-Frame: 0x80 = Command-Frame         */
                              /*             0x00 = Response-Frame        */
char        txfprt;           /*   0 = HDLC-Frame, 1 = Crosslink-Frame    */

unsigned    Fpar;             /* FRACK      sec               F-Befehl    */
unsigned    Opar;             /* MAXFRAME   0..7              O-Befehl    */
unsigned    Npar;             /* RETRY      0..127            N-Befehl    */
unsigned    T2par;            /* T2         20ms              @-T2-Befehl */
unsigned    T3par;            /* T3         sec               @-T3-Befehl */
unsigned    Rpar;             /* DIGION     0..1              R-Befehl    */
                              /* 1 = Digipeaten ein, 0 = aus              */
unsigned    nmbfre;           /* "number free", Anzahl freier 32-Byte-    */
                              /* Buffer (36 Byte mit Kopf)                */
LHEAD       freel;            /* "free list",                             */
                              /* Listenkopf Freibuffer                    */
LHEAD       rxfl;             /* "rx frame list",                         */
                              /* Listenkopf empfangene Frames             */
LHEAD       stfl;             /* "sent frame list",                       */
                              /* Listenkopf gesendete Frames              */
LHEAD       trfl;             /* "trash frame list",                      */
                              /* Listenkopfe Frames fuer den Muelleimer   */
LHEAD       txl2fl[L2PNUM];   /* "tx level 2 frame list",                 */
                              /* Listenkoepfe (je Port einer) zu sendende */
                              /* Frames                                   */
MBHEAD     *rxfhd[L2PNUM];    /* "rx frame head",                         */
                              /* Zeiger (je Port einer) auf das gerade    */
                              /* aktuelle Frame waherend Empfang,         */
                              /* 0 = es wird gerade kein Frame empfangen  */ 
MBHEAD     *txfhd[L2PNUM];    /* "tx frame head",                         */
                              /* Zeiger (je Port einer) auf das gerade    */
                              /* aktuelle Frame waherend Sendung,         */
                              /* 0 = es wird gerade kein Frame gesendet   */
LNKBLK      lnktbl[LINKNMBR]; /* "link table", fuer jeden moeglichen      */
                              /* Level-2-Link ein Eintrag                 */
LNKBLK     *lnkpoi;           /* "link pointer", globaler Zeiger auf den  */
                              /* gerade aktuellen Linkblock (in lnktbl)   */


#ifdef STATSCMD
unsigned l2stats[NUML2STATS][NUMPORTS*2];
#endif

#ifdef METERS
unsigned char rxfdev;
unsigned char siglev;
#endif

/* Ende von L2V.C */
