/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    L2E.C   -   Level 2, Teil 5                                           *
*                                                                          *
*                Dieser Teil ist eine Zusammenfassung der                  *
*                zeitunkritischsten Funktionen und kann somit mit der      *
*                groessten Platzersparnis optimiert werden.                *
*                                                                          *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:                                                          *
*            G8KBB April 1991 - use of register keyword to reduce code     *
*                               initialise L2 stats buffers if needed      *
*                               add the following to l2init()              *
*                                   stats, integrity checking & ACL        *
*                                                                          *
* September 1993 - released as TheNet X-1J                                 *
*                                                                          *
* Various speedups                                                         *
*                                                                          *
* Released as TheNet X-1J release 4, January 1995                          *
\**************************************************************************/





/*                                                             Includes   */
/**************************************************************************/

#include "all.h"         /* allgemeine Festlegungen                       */
#include "tntyp.h"       /* Festlegungen/Datenstrukturen fuer den Level 2 */
#include "l2s.h"         /* Zugriff auf die State-Tabellen                */
#include "l2ext.h"       /* globale Variable / nicht int-Funktionen       */






/**************************************************************************\
*                                                                          *
* action      :  "level 2 initialize"                                      *
*                                                                          *
*                Initialisieren des dynamischen Freispeichers sowie        *
*                aller Level-2-spezifischer Listen- und Framekoepfe.       *
*                                                                          *
 **************************************************************************
*                                                                          *
* parameter   :  -                                                         *
*                                                                          *
* r/o globals :  (Routing-Table)                                           *
*                                                                          *
* r/w globals :  lnkpoi   - Zeiger in lnktbl                               *
*                rxfl     - "leere Liste"                                  *
*                monfl    - "leere Liste"                                  *
*                stfl     - "leere Liste"                                  *
*                trfl     - "leere Liste"                                  *
*                freel    - Liste freier 32-Byte-Buffer dynam. Speicher,   *
*                           jeder Buffer ist initialisiert :  mbpc, mbgc   *
*                           geloescht, mbbp initialisiert, mbl             *
*                           "leere Liste", Buffer der Routing-Table        *
*                           werden nicht neu allokiert bei Warmstart       *
*                nmblks   - 0                                              *
*                nmbfre   - Anzahl freie 32-Byte-Buffer dynam. Speicher    *
*                txl2fl[] - alle Listenkoepfe "leere Liste"                *
*                rxfhd[]  - alle Eintrage NULL                             *
*                txfhd[]  - alle Eintrage NULL                             *
*                istraf[] - alle Eintrage NULL                             *
*                lnktbl   - alle Linkbloecke werden initialisiert          *
*                           (rcvdil, sendil, rcvd, tosend, state, srcid    *
*                           loeschen, snglT1, k, N2, V2link setzen,        *
*                           reslnk() wird aufgerufen)                      *
*                                                                          *
* locals      :  s.u.                                                      *
*                                                                          *
* returns     :  -                                                         *
*                                                                          *
\**************************************************************************/

VOID l2init()
  {
    register char *actbp;     /* Zeiger auf aktuellen Freibuffer          */
    register char *nextbp;    /* Zeiger auf naechsten Freibuffer          */
    char       *minm;         /* niedrigste nutzbare Freispeicherstelle   */
    char       *maxm;         /* hoechste nutzbare Freispeicherstelle     */
    register unsigned n;      /* Laufindex                                */
#ifdef STATSCMD
    unsigned i;               /* extra counter needed for clearing stats  */
#endif

    inithd(&rxfl);            /* diverse Listenkoepfe = "leere Liste"     */
#ifdef FIRMWARE
    inithd(&monfl);           /* Monitor gibt es nur in Firmware          */
#endif
    inithd(&stfl);
    inithd(&trfl);
    inithd(&freel);

    nmblks = nmbfre = 0;      /* keine Links aktiv, noch keine Freibuffer */
    minm = actbp = minmem();  /* niedrigste nutzbare Freispeicherstelle   */
    maxm = maxmem();          /* hoechste nutzbare Freispeicherstelle     */

    while (    ((nextbp = actbp + sizeof(MB) - 1) <= maxm)
            && (nextbp >= minm)
          )                                  /* solange Buffer in Frei-   */
      {                                      /* speicher passen, es keine */
     /* Routingtablebuffer sind   */

        /* if integrity checking is enabled, use those routines in preference
         * otherwise check routing tables or acl tables only
         */
#ifdef INTEGRITY
        if( !iswarm() || !integrity( actbp ) )
#else
#ifdef ACL
        if (!iswarm() || ( !isrout(actbp) && !isacl( actbp ) ))
#else
        if (!iswarm() || !isrout(actbp))
#endif
#endif
          dealoc(actbp);                     /* oder Kaltstart, diese     */
        actbp = nextbp + 1;                  /* initialisieren und in     */
      }                                      /* Freispeicherliste haengen */
       
    for (n = 0; n < L2PNUM; ++n)             /* fuer alle Ports TX-Frame- */
      {                                      /* listen "leer", RX- und    */
       inithd(&txl2fl[n]);                   /* TX-Framekoepfe unbesetzt, */
                                             /* noch nichts gesendet      */

#ifdef FIRMWARE
       rxfhd[n] = txfhd[n] = (MBHEAD *)NULL;
#else
       rxfhd[n] = txfhd[n] = (MBHEAD *)(istraf[n] = (char)NULL);
#endif

      }
      
    for (n = LINKNMBR, lnkpoi = lnktbl; n != 0; --n, ++lnkpoi)  /* Link-   */
      {                                                        /* bloecke */
        lnkpoi->state = lnkpoi->rcvd = lnkpoi->tosend = NULL;  /* initia- */
        inithd(&lnkpoi->rcvdil);                               /* lisier- */
        inithd(&lnkpoi->sendil);                               /* en      */
        inilbl();
        reslnk(); /* damit L-Kommando nach Kaltstart im Hostmode richtig  */
      }
#ifdef STATSCMD
	actbp = l2stats;
	for(n=sizeof(l2stats);n != 0; n--)
		*actbp++ = 0;
/*
    for( n = 0; n < NUMPORTS*2; n++ )
      for( i=0; i<NUML2STATS; i++ )
        l2stats[i][n] = 0;   */           /* clear all level 2 stats */
#endif
  }





/**************************************************************************\
*                                                                          *
* "send frame reject"                                                      *
*                                                                          *
* Wenn Linkzustand des aktuellen Linkblocks (lnkpoi) nicht Disconnectet/   *
* Linksetup/Disconnectrequest/Framereject ist, FRMR-Zustand einnehmen      *
* (state), FRMR den hoeheren Leveln melden, FRMR-Infobytes aufbauen mit    *
* den Flags ZYXW und merken im Linkblock (frmr), FRACK-Timer abschalten,   *
* FRMR senden.                                                             *
*                                                                          *
\**************************************************************************/

VOID sdfrmr(ZYXW)

char ZYXW;

  {
    register char *frmrip;             /* Zeiger in Linkblock-FRMR-Infobytes       */
    
    if (lnkpoi->state >= L2SIXFER)           /* nur ausfuehren, wenn s.o. */
      {
        frmrip = lnkpoi->frmr;               /* Zeiger auf FRMR-Infobytes */
        *frmrip++ = rxfctl | rxfPF;          /* die FRMR-Infobytes        */
        *frmrip++ =   lnkpoi->VR << 5        /* aufbauen                  */
                    | (!rxfCR ? 0x10 : 0)
                    | lnkpoi->VS << 1;
        *frmrip   = ZYXW;
        lnkpoi->state = L2SFRREJ;            /* Linkzustand: Framereject  */
        clrT1();                             /* FRACK-Timer abschalten    */
        l2tolx(L2MFRMRT);                    /* FRMR melden               */
        xfrmr();                             /* FRMR aussenden            */
      }
  }





/**************************************************************************\
*                                                                          *
* FRMR senden mit den im aktuellen Linkblock (lnkpoi) gegebenen            *
* Parametern (frmr). Die txf...-Parameter muessen gesetzt sein bis auf     *
* txfctl.                                                                  *
*                                                                          *
\**************************************************************************/

VOID xfrmr()
  {
    register char     *frmrip;         /* Zeiger in Linkblock-FRMR-Infobytes       */
    register MBHEAD   *fbp;            /* Framemessageheader fuer Frameaufbau      */
    
    txfctl = L2CFRMR;                   /* FRMR-Frame !                   */
    fbp = makfhd(L2FUS | L2FT1ST);      /* Buffer holen, Framekopf bauen  */
    frmrip = lnkpoi->frmr;              /* Zeiger auf FRMR-Infobytes      */
    putchr(*frmrip++,fbp);              /* FRMR-Infobytes in Frame        */
    putchr(*frmrip++,fbp);
    putchr(*frmrip  ,fbp);
    sdl2fr(fbp);                        /* Frame aussenden                */
  }



/* Ende von L2E.C */

