{(s0p16h0s0b4099T}
Program Con_filt;

Uses Dos, Strings, TSTHunit;

Var
  TstHostIRQVector : Byte;            {IRQ vector to get the info}
                                      {WARNING : This is NOT the IRQ vector for
                                       communication to e.g. TFPCX(286) driver!}
  TstHostActive,                      { True if TstHost is active }
  FullInfo         : Boolean;         { Fullinfo set in config file }


Procedure ReadCfgFile(FileName : String; Var Full : Boolean);

(* Read Cfg file *)

Var
  FileInput     : Text;
  Line          : String;
  DirInfo       : SearchRec;
  Code,
  Channel       : Integer;

Begin
  Full := False;
  FindFirst(FileName,AnyFile,DirInfo);
  If DosError > 0 then
  Begin
    Exit;
  End;

  Assign(FileInput, FileName);
  {$I-}
  Reset(FileInput);
  {SI+}
  If IOResult <> 0 then
  Begin
    Exit;
  End;

  Repeat
    Readln(FileInput,Line);
    If (Copy(Line,1,1) <> '#') and
    (Pos('INFO',UpCaseStr(Line)) > 0) and (Pos('FULL',UpCaseStr(Line)) > 0)
     then Full := True;
    Val(Copy(Line,1,1),Channel,Code);
    If (Code = 0) and (Channel >= 1) and (Channel <= 8) then
    Begin
      ChannelData[Channel].ExtraInfo := '(' + Copy(Line,3,8) + ')';
      While Length(ChannelData[Channel].ExtraInfo) < 10 Do
        ChannelData[Channel].ExtraInfo := ChannelData[Channel].ExtraInfo + ' ';
    End;
  Until Eof(FileInput);
  Close(FileInput);
End;


Function GetConnectChannel : Byte;

(* Returning the incoming channel, only valid when using as con_filt! *)

Var
  Param          : String;
  P,
  Code           : Integer;

Begin
  GetConnectChannel := 0;
  If ParamCount >= 6 then
  Begin
    Param := ParamStr(6);
    Val(Param,P,Code);
    If Code = 0 then GetConnectChannel := P;
  End;
End;


Procedure DisplayStatus(Full : Boolean);

(* Read the data from memory and display on channel *)

Var
  LinePart     : String;
  SysopCall    : String[10];
  Channel      : Byte;

Begin
  For Channel := 1 to ChannelData[0].MaxChannel do { Scan the channels 1 to max.}
  Begin
    With ChannelData[Channel] do
    Begin

      If SuppCall = '' Then SysopCall := TstHostCall else SysopCall := SuppCall;

      Case Chstatus of
        1 : Begin
              LinePart := '(Normal)  ---> '+UserCall;
            End;
        2 : Begin
              LinePart := '(Normal)  <--- '+UserCall+' - '+UIThisConnTime;
            End;
        3 : Begin
              LinePart := '(Forward) <--- '+UserCall+' - '+UIThisConnTime;
            End;
        4 : Begin
              LinePart := '(Forward) ---> '+UserCall;
            End;
        5 : Begin
              LinePart := '(Unproto) ---> '+UserCall;
            End;
      End; {Case}

      If Chstatus > 0 then
      Begin
        Writeln('Ch. ',Channel:1,' ',ExtraInfo,' ',
                SysopCall,LinePart);
      End;

    End;
  End;
  If Full then
  Begin
    For Channel := 1 to ChannelData[0].MaxChannel do
    Begin
      With ChannelData[Channel] do
      If (Chstatus = 2) or (ChStatus = 3) and (GetConnectChannel = Channel) then
      Begin
        Writeln;
        Writeln('Tsthost version       : ',Version);
        Case DrvType of
          0  : Writeln('Drivertype            : TFPCX, using IRQ vector : ',IntNo);
          1  : Writeln('Drivertype            : Real host driver, comport : ',Port,' baudrate : ',BaudRate);
          2  : Writeln('Drivertype            : DRSI');
        End; { Case }
        Writeln('MaxChannel            : ',MaxChannel);
        If UlistEnable <> 0 then
          Writeln('UlistEnabled          : Active') else
          Writeln('UlistEnabled          : Not active');
        Writeln('WorkDir               : ',WPath);
        Writeln('UploadPath            : ',UPath);
        Writeln('HomeBBS               : ',HomeBBS);
        Writeln('HomeAlias             : ',HomeAlias);
        Writeln('UserName              : ',UIname);
        Writeln('Last time connected   : ',UILastConnTime);
        Writeln('Last time message     : ',UILastMsgList);
        Writeln('Number of connections : ',UINbrConn);
        Writeln('Time connected        : ',UIThisConnTime);
        Writeln('Sys level             : ',SysFlag); { when using as con_filt always 0 !}
        Writeln('Memory available      : ',MemAvail);
      End;
    End;
  End;
  Writeln;
End;




Begin { main }
  GetTstHostIRQVector(TstHostIRQVector,TstHostActive);
  If NOT TstHostActive then
  Begin
    Writeln('This programm requires TstHost.');
    Writeln('This software is public domain. It can be installed or copied only for');
    Writeln('amateur radio use. All commercial or professional use is prohibited.');
    Writeln;
    Writeln('Packet address : PE1PKD @ PI8WFL.#NH1.NLD.EU');
    Halt(0);
  End;
  Writeln('CONnect FiLTer V1.2 entry activated.');
  Writeln;
(*  Fillchar(ChannelData,SizeOf(ChannelData),' '); {Clear all data} *)
  GetChannelsInfo(TstHostIRQVector);
  ReadCfgFile(GetTstHostPath + 'CON_FILT.CFG',FullInfo);
  DisplayStatus(FullInfo);
End.




