#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <dos.h>
#include <ctype.h>
#include <time.h>

struct dirmes	{
		char type;			/* type of message B o P*/
		char status;			/* N, F, K, Y */
		long number;			/* numero del messaggio */
		struct date date;		/* data del messaggio */
		struct time time;		/* tempo del messaggio */
		char to[7];			/* destinatario */
		char route[7];			/* bbs di destinazione */
		char from[7];			/* mittente del messaggio */
		char title[61];			/* titolo del messaggio */
		char frombbs;			/* 1 se ricevuto in forward */
		char startbbs[7];		/* bbs di partenza */
		char bid[13];			/* bid or mid */
		char rcvbbs[7];			/* bbs da cui ricevo il messaggio */
		char free[4];			/* reserved */
		} dm;

struct hbb	{
		char call[7];
		char route[7];
		} hbb;
char comment[81],buffer[129],call[7],route[7];

struct hbb *hb;

main()
{
FILE *fhbb,*fdms,*ftmp;
void *p;
int nr,i,h;
struct ftime ftime;
struct date date;
struct time time;
struct hbb *hb,*hb1;
long timeref;
unsigned int update,total,change;

puts("\nUpdHbb v1.00, (c) IK1GKJ\nUpdate tsthost.hbb from tsthost.dms\n");
p=(void*)malloc(sizeof(struct hbb)*1000);
if(p==NULL)
	{
	puts("Insufficent memory\n");
	exit(1);
	}
fhbb=fopen("TSTHOST.HBB","rb+");
if(fhbb==NULL)
	{
	if((fhbb=fopen("TSTHOST.HBB","wb+"))==NULL)
		{
		puts("Cannot open or create file: tsthost.hbb\n");
		exit(1);
		}
	}
getftime(fileno(fhbb),&ftime);
date.da_year=ftime.ft_year+1980;
date.da_day=ftime.ft_day;
date.da_mon=ftime.ft_month;
time.ti_hund=0;
time.ti_sec=ftime.ft_tsec*2;
time.ti_min=ftime.ft_min;
time.ti_hour=ftime.ft_hour;
timeref=dostounix(&date,&time);
printf("Opening tsthost.hbb, last update: %s",ctime(&timeref));
if((ftmp=tmpfile())==NULL)
	{
	puts("Cannot open tmp file\n");
	exit(1);
	}
if((fdms=fopen("TSTHOST.DMS","rb"))==NULL)
	{
	puts("Cannot open file: tsthost.dms\n");
	exit(1);
	}
printf("Opening tsthost.dms....\nSearch for message received after last hbb update time.....\n");
i=0;
while(1){
	if(fread(&dm,1,sizeof(struct dirmes),fdms)!=sizeof(struct dirmes)) break;
	if(dostounix(&dm.date,&dm.time)<timeref) continue;
	i++;
	break;
	}
if(i==0){
	puts("No new messages.\n");
	exit(0);
	}
printf("Reading data from tsthost.dms....\n");
total=update=change=0;
nr=0;
hb=(struct hbb*)p;
do	{
	if(*dm.startbbs!=0)
		{
		hb1=(struct hbb*)p;
		for(h=0;h<nr;h++)
			{
			if(stricmp(hb1->call,dm.from)==0)
				{
				strcpy(hb1->call,dm.from);
				strcpy(hb1->route,dm.startbbs);
				break;
				}
			hb1++;
			}
		if(h<nr) continue;
		if(nr==1000)
			{
			memmove(p,(char*)(p)+sizeof(struct hbb),999*sizeof(struct hbb));
			hb--;
			nr--;
			}
		strcpy(hb->call,dm.from);
		strcpy(hb->route,dm.startbbs);
		hb++;
		nr++;
		}
	} while(fread(&dm,1,sizeof(struct dirmes),fdms)==sizeof(struct dirmes));
printf("Updating tsthost.hbb....\n");
if(nr)	{
	while(fgets(buffer,128,fhbb))
		{
		hb=(struct hbb*)p;
		*comment=0;
		if(sscanf(buffer," %6s @ %6s &79[^\r\n]",call,route,comment)<2) continue;
		for(i=0,h=0;i<nr;i++,hb++)
			{
			if(stricmp(call,hb->call)==0)
				{
				if(stricmp(route,hb->route))
					{
			 		strcpy(route,hb->route);
					h=1;
					}
				*hb->call=0;
				}
			}
		fprintf(ftmp,"%-6s @ %-6s %s\r\n",call,route,comment);
		if(h)	change++;
		total++;
		}
	fflush(ftmp);
	chsize(fileno(fhbb),0L);
	rewind(fhbb);
	rewind(ftmp);
	while(fgets(buffer,127,ftmp)) fputs(buffer,fhbb);
	hb=(struct hbb*)p;
	for(i=0;i<nr;i++,hb++)
		{
		if(*hb->call)
			{
			fprintf(fhbb,"%-6s @ %-6s \r\n",hb->call,hb->route);
			update++;
			total++;
			}
		}
	}
printf("New: %u, Change: %u, Total record: %u\n",update,change,total);
puts("Done.\n");
return 0;
}
