Uses Dos;
Const HexTab      : Array[0..15] of char =
                     ('0','1','2','3','4','5','6','7','8','9',
                      'A','B','C','D','E','F');
      ConMode     : Array[0..2] of String[12] =
                     ('disconnected','incoming','outgoing');

Type  Userrec = Record
                 Channel  : byte;                     { Which channel   }
                 Mode     : byte;                     { Mode            }
                 Filename : string[80];               { FileName        }
                End;

      Channel_Rec  = Record
                       UserCall    : String [ 9]; {User Callsign   }
                       MyCall      : String [ 9]; {Sysop Callsign  }
                       ProgName    : String [12]; {Default Program }
                       PrgNme      : String [12]; {Active Program  }
                       ExecLevel   : Byte;        {Times Executed  }
                       ConnectMode : Byte;        {Channel-mode    }
                                                  {0 = not connected }
                                                  {1 = incoming      }
                                                  {2 = outgoing      }
                       Hours,
                       Minutes,
                       Seconds    : Word;         {Connection Time   }

                       initcall   : String [9]; {Initialization mycall }

                     End;

      MHeardRec = Record
                    Call : String [9];
                    Port : Byte;
                    Time : LongInt; {PackedTime}
                  End;

      MHeard      = Array[1..26] Of MHeardRec; {26 x MHeardRec}
      ChannelRec  = Array[0..20] Of Channel_Rec; {21 x Channel_Rec}

Var TempStr       : String;
    TempFile      : Text;
    Ur            : UserRec;
    NPGInt,
    Code,I        : Integer;
    MH            : ^Mheard;
    DT            : DateTime;
    Cr            : ^ChannelRec;

function hexword(w:word):string;
var s : string;
    i : byte;
begin
  s := '';
  for i := 3 downto 0 do s := s  + HexTab[(w shr (i*4)) and $F];
  hexword := s;
end;

function hexbyte(b:byte):string;
var s : string;
    i : byte;
begin
  s := '';
  for i := 1 downto 0 do s := s  + HexTab[(b shr (i*4)) and $F];
  hexbyte := s;
end;

Function NPG_check: Integer;
Type ident = Record
               nop : Array [1..2] Of Char;
               id  : Array [1..6] Of Char;
             End;
Var
  i: Integer;
  ok: Boolean;
  SPtr: Pointer;
Begin
  i := 0; ok := False;
  While (i <= 255) And Not ok Do
  Begin
    GetIntVec (i, SPtr);
    If ident (SPtr^).id = 'NwPkGn' Then Ok := True;
    If Not Ok Then Inc (i);
  End;
  NPG_Check  := i;
End;

Function Adjust (s: String; len: Byte; fillc:char;mode:boolean): String;
Begin
  If Length (s) < len Then
  begin
   if mode  then  While Length (s) < len Do s := s + fillc
            else  While Length (s) < len Do s := fillc + s;
  end;
  If Length (s) > len Then s [0] := Chr (len);
  Adjust := s;
End;

Function AdjustVal (Val:Word;len:byte;fillc:char;mode:boolean): String;
var s : string;
Begin
  str(val,s);
  If Length (s) < len Then
  begin
   if mode  then  While Length (s) < len Do s := s + fillc
            else  While Length (s) < len Do s := fillc + s;
  end;
  If Length (s) > len Then s [0] := Chr (len);
  AdjustVal := s;
End;

Procedure Writeuser;
Var F : File;
Begin
 Assign(F,'USERS.NPU');
 {$i-} Reset(F,1); {$i+}
 if ioresult = 0 then seek(f,filesize(f))
                 else {$i-} Rewrite(F,1); {$i+}
 If IOresult = 0 then
 begin
   Blockwrite(F,Ur,Sizeof(Userrec));
   Close(F);
 end;
End;

function NPG_Version:word;
var regs : registers;
begin
  regs.ah := 0;
  intr(NPGInt,Regs);
  NPG_Version := regs.ax;
end;
Function remove_spaces (s: String): String;
Begin
  While (Pos (' ', s) > 0)  Do Delete (s, Pos (' ', s), 1);
  remove_spaces := s;
End;

function NPG_ChannelRec:pointer;
var regs : registers;
begin
  regs.ah := 1;
  intr(NPGInt,Regs);
  NPG_ChannelRec := Ptr(regs.es,regs.bx);
end;

function NPG_SysopChannel:Byte;
var regs : registers;
begin
  regs.ah := 2;
  intr(NPGInt,Regs);
  NPG_SysopChannel := regs.al;
end;

function NPG_Channels:Byte;
var regs : registers;
begin
  regs.ah := 3;
  intr(NPGInt,Regs);
  NPG_Channels := regs.al;
end;

function NPG_Mheard:pointer;
var regs : registers;
begin
  regs.ah := 4;
  intr(NPGInt,Regs);
  NPG_Mheard := Ptr(regs.es,regs.bx);
end;

Begin
  NPGInt := NPG_Check;
  if NPGInt = 256 then
  begin
   writeln('NPG not found in memory');
   halt;
  end;
  ur.mode := 1;
  val(paramstr(5),ur.channel,code);
  ur.filename := 'example4.'+paramstr(5);
  Assign(tempfile,ur.filename);
  {$i-} rewrite(tempfile); {$i+}
  writeln(tempfile,'Pascal example program for NPG v1.03'#13#10);
  (* Make a bar *)
  for i := 1 to 80 do write(tempfile,'-');

  (* Skip a line *)
  writeln(tempfile);
  code := NPG_version;
  str(lo(code),tempstr);
  writeln(tempfile,'NPG found at interrupt  : ',npgint,' ('+hexbyte(npgint)+'h)');
  Writeln(tempfile,'NPG version             : ',hi(code),'.',adjust(tempstr,2,'0',false));
  Writeln(tempfile,'Sysop at channel number : ',NPG_SysopChannel:2);
  Writeln(tempfile,'Number of channels used : ',NPG_Channels:2);
  writeln(tempfile);
  mh := NPG_Mheard;
  cr := NPG_ChannelRec;
  for i := 1 to 26 do
  begin
    with MH^[i] do
    begin
     if Remove_Spaces (call) <> '' then
     begin
       UnPackTime(Time,Dt);
       writeln(tempfile,i:3,' ',adjust(Call,12,' ',true),'port=',port:3,'  time= ',
               AdjustVal(Dt.hour,2,'0',false),':',
               AdjustVal(Dt.Min,2,'0',false),':',
               AdjustVal(Dt.Sec,2,'0',false),'  date= ',
               AdjustVal(Dt.Day,2,'0',false),'/',
               AdjustVal(Dt.Month,2,'0',false),'/',
               AdjustVal(Dt.Year,4,'0',false));
     end;
    end;
  end;
  writeln(tempfile);
  for i := 0 to NPG_Channels do
  begin
   with Cr^[i] do
   begin
    case ConnectMode of
     0 : Begin
           write(tempfile,i:3,' My= ',Adjust(MyCall,10,' ',true));
           if i = 0 then writeln(tempfile,'[monitor]')
                    else writeln(tempfile,'[disconnected]');
         End;
   1,2 : Begin
           write(tempfile,i:3,' My= ',Adjust(MyCall,10,' ',true),
                 'Usr= ',Adjust(UserCall,10,' ',true),
                 '[',conmode[connectmode],'] C-Time= ',
                 AdjustVal(hours,2,'0',false),':',
                 AdjustVal(Minutes,2,'0',false),':',
                 AdjustVal(Seconds,2,'0',false));
           if prgnme <> '' then writeln(tempfile,' Prg=',PrgNme)
                           else writeln(tempfile);
          End;
    end;
   end;
  end;
  (* Make a bar *)
  for i := 1 to 80 do write(tempfile,'-');

  (* Skip a line *)
  writeln(tempfile);
  {$i-} close(tempfile); {$i+}
  writeuser;
  halt(2);
End.
