{TXT2MSG - Wandelt System-Texte der MCUT-Mailbox in die korrekte
 Binr-form um.

 Wechsel des Formates:

 Ab heute (15.09.95) wird folgendes Format benutzt:

 <Version><Offset-Array><Daten>

 - Die Version ist 1 Byte gro. Sie dient zum Abfragen der Version der
   Texte.
 - Offset-Array ist ein per Hand gebautes Array. Jeder Eintrag besteht
   aus einem WORD-Offset (also 2 Bytes) auf den eigentlichen Text.
   Die Stelle des Offsets berechnet sich aus: x*2 + 1 (Versions-Kennung
   berspringen).
 - Jedes Datenfeld besteht aus einem Byte als Lngen-Angabe und
   dem eigentlichen String. (Pascal-Form)

 Diese Form braucht wirklich nur soviel Speicher wie Text vorhanden
 ist und ist auch nur geringfgig langsamer als eine Version mit einem
 FILE OF ^STRING[80]. (1 Week-Befehl wird mehr gebraucht)

}

PROGRAM Txt2Message;

CONST
  Version = '2.0';
  Datum = '15.09.95';

VAR FileVers: BYTE;
    code: WORD;

TYPE tLongIntArray = ARRAY[1..4] OF BYTE;

PROCEDURE Info;
BEGIN
  WRITELN('TXT2MSG V'+Version+' ('+Datum+')');
  WRITELN('by Jochen Sarrazin');
END;


PROCEDURE Wandel(FileVers: BYTE);
TYPE tArr255 = ARRAY[1..255] OF CHAR;
VAR SF: Text;
    DF: File;
    S: STRING;
    Len,i: BYTE;
    Arr255: tArr255;
    AktOffset: WORD;
BEGIN
  ASSIGN(SF,ParamStr(1));
  {$I-}
  RESET(SF);
  {$I+}
  IF IOResult<>0 THEN BEGIN
    Info;
    WRITELN;
    WRITELN('Fehler beim ffnen des Source-Files.');
    WRITELN;
    Halt;
  END;

  ASSIGN(DF,'MESSAGES.'+ParamStr(2));
  {$I-}
  REWRITE(DF,1);
  {$I+}
  IF IOResult<>0 THEN BEGIN
    Info;
    WRITELN;
    WRITELN('Fehler beim ffnen des Ausgangs-Files.');
    WRITELN;
    CLOSE(SF);
    Halt;
  END;

  Info;
  WRITELN;
  WRITELN('Versions-Info schreiben');
  Arr255[1] := Char(FileVers);
  BLOCKWRITE(DF,Arr255,1);

  WRITELN('Fr jede Textzeile Platzhalter fr die Offset-Adresse schreiben..');
  Len := 2;
  Arr255[1] := #0;
  Arr255[2] := #0;
  WHILE NOT EOF(SF) DO BEGIN
    READLN(SF,S);
    BLOCKWRITE(DF,Arr255,Len);
  END;

  CLOSE(SF);
  RESET(SF);
  AktOffset := FILEPOS(DF);
  WRITELN('Jetzt den eigentlichen Text schreiben...');
  WHILE NOT EOF(SF) DO BEGIN
    READLN(SF,S);
    Len := LENGTH(S)+1;
    Arr255[1] := S[0];
    FOR i := 1 TO LENGTH(S) DO Arr255[i+1] := S[i];
    BLOCKWRITE(DF,Arr255,Len);
  END;
  CLOSE(SF);
  RESET(SF);

  {Im Destination-File an den ersten Offset-Eintrag springen}
  SEEK(DF,1);

  WRITELN('Platzhalter mit dem richtigen Offset ersetzen..');

  Len := 2;
  WHILE NOT EOF(SF) DO BEGIN
    READLN(SF,S);
    Arr255[1] := Char(Hi(AktOffset));
    Arr255[2] := Char(Lo(AktOffset));
    BLOCKWRITE(DF,Arr255,Len);
    AktOffset := AktOffset + LENGTH(S) + 1;
  END;
  CLOSE(SF);

  CLOSE(DF);

  WRITELN('fertig!');
END;


BEGIN
  IF ParamCount < 3 THEN BEGIN
    Info;
    WRITELN;
    WRITELN('Syntax: TXT2MSG <Klartext-File> <Abkrzung> <Version>');
    WRITELN;
    WRITELN('also z.B.:  TXT2MSG deutsch.txt DL 2');
    WRITELN; WRITELN;
    Halt;
  END;

  IF LENGTH(ParamStr(2)) > 3 THEN BEGIN
    Info;
    WRITELN;
    WRITELN('Die Abkrzung der Sprache darf nicht lnger als 3 Zeichen sein!');
    WRITELN; WRITELN;
    Halt;
  END;

  VAL(ParamStr(3),FileVers,code);
  IF code<>0 THEN BEGIN
    Info;
    WRITELN;
    WRITELN('Die File-Version MUSS eine Integer-Zahl sein!');
    WRITELN; WRITELN;
    Halt;
  END;


  Wandel(FileVers);;

END.