/* System-dependent definitions of various files, spool directories, etc */
#include "global.h"
#include "config.h"
#include "files.h"
#include "socket.h"

#ifdef	MSDOS
char *Startup = "/autoexec.nos";		/* Initialization file */
char *Userfile = "/ftpusers";			/* Authorized FTP users and passwords */
char *Hostfile = "/nos.rc";             /* hosts and passwords */
char *Maillog = "/spool/mail.log";		/* mail log */
char *Mailspool = "/spool/mail";		/* Incoming mail */
char *Mailqdir = "/spool/mqueue";		/* Outgoing mail spool */
char *Mailqueue = "/spool/mqueue/*.wrk";	/* Outgoing mail work files */
char *Routeqdir = "/spool/rqueue";		/* queue for router */
char *Alias = "/alias";					/* the alias file */
char *Dfile = "/domain.txt";			/* Domain cache */
char *Fdir = "/finger";					/* Finger info directory */
char *Mboxlog = "/spool/node.log";		/* MBox activity log */
char *Arealist = "/spool/areas";		/* List of message areas */
char *Helpdir = "/spool/help";			/* Mailbox help file directory */
char *Rewritefile = "/spool/rewrite";	/* Address rewrite file */
char *Signature = "/spool/signatur";	/* Mail signature file directory */
char *Popusers = "/popusers";			/* POP user and password file */
char *Axroutefile = "/axroute.dat";		/* AX25 routes */
char *Axroutetmp = "/axroute.tmp";		/* AX25 temp routes */
char *Arproutefile = "/arproute.dat";	/* ARP entries */
char *Arproutetmp = "/arproute.tmp";	/* ARP temp entries */
char *Iproutefile = "/iproute.dat";     /* IP route entries */
char *Iproutetmp = "/iproute.tmp";		/* IP temp route */
#ifdef NETROM
char *Nrroutefile = "/nrroute.dat";		/* NET/ROM routes */
#endif
char *Forwardfile = "/spool/forward.bbs";	/* Mail forwarding file */
char *Historyfile = "/spool/history";
char *News    = "/spool/news";		  	/* Top of NeWs file system */
char *Active  = "/spool/news/active";	/* Active article file */
char *Pointer = "/spool/news/pointer";	/* */
char *NInfo   = "/spool/news/xinfo";   	/* */
char *Nhelp   = "/spool/news/help";
char *History = "/spool/news/history";
char *Forward = "/spool/news/junk";
char *Poll    = "/spool/news/poll";
char *Convers = "/convers.cfg";
char *Bbsfile = "/bbs.cfg";
char Eol[] = "\r\n";
#define	SEPARATOR	"/"
#endif

#ifdef	UNIX
char *Startup = "./startup.net";		/* Initialization file */
char *Config = "./config.net";			/* Device configuration list */
char *Userfile = "./ftpusers";
char *Hostfile = "./nos.rc";
char *Mailspool = "./mail";
char *Maillog = "./mail.log";			/* mail log */
char *Mailqdir = "./mqueue";
char *Mailqueue = "./mqueue/*.wrk";
char *Routeqdir = "./rqueue";			/* queue for router */
char *Alias = "./alias";			/* the alias file */
char *Dfile = "./domain.txt";			/* Domain cache */
char *Fdir = "./finger";			/* Finger info directory */
char *Arealist = "./areas";			/* List of message areas */
char *Helpdir = "./help";			/* Mailbox help file directory */
char *Rewritefile = "./rewrite";		/* Address rewrite file */
char *Signature = "./signatur";			/* Mail signature file directory */
char *Popusers = "./popusers";			/* POP user and password file */
char *News = "./news";			/* News messages and NNTP data */
char *Forwardfile = "./forward.bbs";		/* Mail forwarding file */
char *Historyfile = "./history";
char *Convers = "./convers.cfg";
char Eol[] = "\n";
#define	SEPARATOR	"/"
#endif

#ifdef	AMIGA
char *Startup = "TCPIP:net-startup";
char *Config = "TCPIP:config.net";		/* Device configuration list */
char *Hostfile = "TCPIP:nos.rc";
char *Userfile = "TCPIP:ftpusers";
char *Mailspool = "TCPIP:spool/mail";
char *Maillog = "TCPIP:spool/mail.log";
char *Mailqdir = "TCPIP:spool/mqueue";
char *Mailqueue = "TCPIP:spool/mqueue/#?.wrk";
char *Routeqdir = "TCPIP:spool/rqueue";		/* queue for router */
char *Alias = "TCPIP:alias";			/* the alias file */
char *Dfile = "TCPIP:domain.txt";		/* Domain cache */
char *Fdir = "TCPIP:finger";			/* Finger info directory */
char *Arealist = "TCPIP:spool/areas";		/* List of message areas */
char *Helpdir = "TCPIP:spool/help";		/* Mailbox help file directory */
char *Rewritefile = "TCPIP:spool/rewrite";	/* Address rewrite file */
char *Signature = "TCPIP:spool/signatur";	/* Mail signature file directory */
char *Popusers = "TCPIP:/popusers";		/* POP user and password file */
char *News = "TCPIP:/spool/news";		/* News messages and NNTP data */
char *Forwardfile = "TCPIP:spool/forward.bbs";	/* Mail forwarding file */
char *Historyfile = "TCPIP:spool/history";
char *Convers = "TCPIP:convers.cfg";
char Eol[] = "\r\n";
#define	SEPARATOR	"/"
#endif

#ifdef	MAC
char *Startup ="Mikes Hard Disk:net.start";
char *Config = "Mikes Hard Disk:config.net";		/* Device configuration list */
char *Hostfile = "Mikes Hard Disk:nos.rc";
char *Userfile = "Mikes Hard Disk:ftpusers";
char *Mailspool = "Mikes Hard Disk:spool:mail:";
char *Maillog = "Mikes Hard Disk:spool:mail.log:";
char *Mailqdir = "Mikes Hard Disk:spool:mqueue:";
char *Mailqueue = "Mikes Hard Disk:spool:mqueue:*.wrk";
char *Routeqdir = "Mikes Hard Disk:spool/rqueue:";	/* queue for router */
char *Alias = "Mikes Hard Disk:alias";			/* the alias file */
char *Dfile = "Mikes Hard Disk:domain:txt";		/* Domain cache */
char *Fdir = "Mikes Hard Disk:finger";			/* Finger info directory */
char *Arealist = "Mikes Hard Disk:spool/areas";		/* List of message areas */
char *Helpdir = "Mikes Hard Disk:spool/help";		/* Mailbox help file directory */
char *Rewritefile = "Mikes Hard Disk:spool/rewrite";	/* Address rewrite file */
char *Signature = "Mikes Hard Disk:spool/signatur";	/* Mail signature file directory */
char *Popusers = "Mikes Hard Disk:/popusers";		/* POP user and password file */
char *News = "Mikes Hard Disk:/spool/news";		/* News messages and NNTP data */
char *Forwardfile = "Mikes Hard Disk:spool/forward.bbs"; /* Mail forwarding file */
char *Historyfile = "Mikes Hard Disk:spool/history";
char *Convers = "Mikes Hard Disk:convers.cfg";
char Eol[] = "\r";
#define	SEPARATOR	":"
#endif

char fatal[] = "503 Fatal error %sFILE %s\n";
static char *roott = NULLCHAR;

/* Concatenate root, separator and arg strings into a malloc'ed output
 * buffer, then remove repeated occurrences of the separator char
 */
static char *
strcatdup(a)
char *a;
{
	char *p1, *p2, *cp, *out = mxallocw(strlen(roott) + strlen(SEPARATOR) + strlen(a) + 2);

#ifdef MSDOS
	while((cp = strchr(a,'\\')) != NULLCHAR)
		*cp = '/';
#endif

	strcpy(out,roott);
	strcat(out,SEPARATOR);
	strcat(out,a);
	strcat(out,"\0");

	/* Remove any repeated occurrences of the separator char */
	p1 = p2 = out;
	while(*p2 != '\0'){
		*p1++ = *p2++;
		while(p2[0] == p2[-1] && p2[0] == roott[0])
			p2++;
	}
	*p1 = '\0';

	return out;
}

/* Establish a root directory other than the default. Can only be called
 * once, at startup time
 */
void
initroot(root)
char *root;
{
	if(root != NULLCHAR)
		roott = strxdup(root);

	Startup = strcatdup(Startup);
	Userfile = strcatdup(Userfile);
	Hostfile = strcatdup(Hostfile);
	Maillog = strcatdup(Maillog);
	Mailspool = strcatdup(Mailspool);
	Mailqdir = strcatdup(Mailqdir);
	Mailqueue = strcatdup(Mailqueue);
	Routeqdir = strcatdup(Routeqdir);
	Alias = strcatdup(Alias);
	Dfile = strcatdup(Dfile);
	Fdir = strcatdup(Fdir);
	Arealist = strcatdup(Arealist);
	Helpdir = strcatdup(Helpdir);
	Rewritefile = strcatdup(Rewritefile);
	Signature = strcatdup(Signature);
	Popusers = strcatdup(Popusers);
	Axroutefile = strcatdup(Axroutefile);
	Axroutetmp = strcatdup(Axroutetmp);
	Arproutefile = strcatdup(Arproutefile);
	Arproutetmp = strcatdup(Arproutetmp);
	Bbsfile = strcatdup(Bbsfile);
	Iproutefile = strcatdup(Iproutefile);
	Iproutetmp = strcatdup(Iproutetmp);
#ifdef NETROM
	Nrroutefile = strcatdup(Nrroutefile);
#endif
	Forwardfile = strcatdup(Forwardfile);
	Historyfile = strcatdup(Historyfile);
	News = strcatdup(News);
	Mboxlog = strcatdup(Mboxlog);
	Active = strcatdup(Active);
	Pointer = strcatdup(Pointer);
	NInfo = strcatdup(NInfo);
	Nhelp = strcatdup(Nhelp);
	History = strcatdup(History); 
	Forward = strcatdup(Forward);
	Poll = strcatdup(Poll);
	Convers = strcatdup(Convers);
	xfree(roott);
}

/* main file-opening routine
 * options: s = socketnumber, if given an error msg is printed to the socket
 * returncode: NULLFILE if error; filepointer success
 */
FILE *
open_file(name,mode,s,t)
char *name;
char *mode;
int s;
int t;
{
	FILE *f;
	char *cp;

	if(name == NULLCHAR || mode == NULLCHAR)
		return NULLFILE;
#ifdef MSDOS
	while((cp = strchr(name,'\\')) != NULLCHAR)
		*cp = '/';
#endif
	if((f = fopen(name,mode)) == NULLFILE) {
		if(s)
			usprintf(s,fatal,"",name);
		if(t)
			tprintf("Can't open %s: %s\n",name,sys_errlist[errno]);
	}
	return f;
}

/* main tempfile-opening routine
 * returncode: NULLFILE if error; filepointer success
 */
FILE *
temp_file(s,t)
int s;
int t;
{
	FILE *f;

	if((f = tmpfile()) == NULLFILE) {
		if(s)
			usprintf(s,fatal,"TMP","");
		if(t) {
			tprintf("Can't open TMP: %s\n",sys_errlist[errno]);
		}
	}
	return f;
}

