#include <stdio.h>
#include "global.h"
#ifndef __CPLUSPLUS
#include "mbuf.h"

extern char _Uend;
extern int _STKRED;

union header {
	struct {
		union header *ptr;
		unsigned size;
	} s;
	long l;
};

static void
dumpbuf(bp)
struct mbuf *bp;
{
	union header *blk;

	if(bp == NULLBUF) {
		tputs("NULL BUFFER\n");
	} else {
		blk = ((union header *)bp) - 1;
		tprintf("bp %lx tot siz %u data %lx cnt %u next %lx anext %lx\n",
			(long)bp,
			blk->s.size * sizeof(union header),
			(long)bp->data,
			bp->cnt,
			(long)bp->next,
			(long)bp->anext);
	}
	return;
}

static void
audit_mbuf(bp,file,line)
struct mbuf *bp;
char *file;
int line;
{
	union header *blk;
	char *bufstart, *bufend;
	int16 datasize;
	int errors = 0;
	int16 overhead = sizeof(union header) + sizeof(struct mbuf);
	char *heapbot = &_Uend;
	char *heaptop = (char *) -_STKRED;

	if(bp == NULLBUF)
		return;

	/* Does buffer appear to be a valid malloc'ed block? */
	blk = ((union header *)bp) - 1;
	if(blk->s.ptr != blk){
		tprintf("Garbage bp %lx\n",(long)bp);
		errors++;
	}
	if((datasize = blk->s.size*sizeof(union header) - overhead) != 0){
		/* mbuf has data area associated with it, verify that
		 * pointers are within it
		 */
		bufstart = (char *)(bp + 1);
		bufend = (char *)bufstart + datasize;
		if(bp->data < bufstart){
			tputs("Data pointer before buffer\n");
			errors++;
		}
		if(bp->data + bp->cnt > bufend){
			tputs("Data pointer + count past bounds\n");
			errors++;
		}
	} else {
		/* Dup'ed mbuf, at least check that pointers are within
		 * heap area
		*/
		if(bp->data < heapbot || bp->data + bp->cnt > heaptop){
			tputs("Data outside heap\n");
			errors++;
		}
	}
	/* Now check link list pointers */
	if(bp->next != NULLBUF && ((bp->next < (struct mbuf *)heapbot)
		 || bp->next > (struct mbuf *)heaptop)){
			tputs("next pointer out of limits\n");
			errors++;
	}
	if(bp->anext != NULLBUF && ((bp->anext < (struct mbuf *)heapbot)
		 || bp->anext > (struct mbuf *)heaptop)){
			tputs("anext pointer out of limits\n");
			errors++;
	}
	if(errors != 0){
		dumpbuf(bp);
		printf("PANIC: buffer audit failure in %s line %d\n",file,line);
		fflush(stdout);
		exit(253);
	}
	return;
}

/* Perform sanity checks on mbuf. Print any errors, return 0 if none,
 * nonzero otherwise
 */
void
audit(bp,file,line)
struct mbuf *bp;
char *file;
int line;
{
	struct mbuf *bp1;

	for(bp1 = bp;bp1 != NULLBUF; bp1 = bp1->next)
		audit_mbuf(bp1,file,line);
}

#endif /* __CPLUSPLUS */