#include "global.h"
#ifdef STATS_HTTP
#include "stats.h"
#include "stats_h.h"


#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: stats_h.c,v 1.1 1997/09/07 00:31:16 root Exp $";
#endif



static struct http_stats httpstats;

static const char httpdailyhdr[] = "     TOTAL REQUESTS%-22.22sPBBS REQUESTS\n\n";
static const char httpweeklyhdr[] = "         TOTAL REQUESTS%-27.27sPBBS REQUESTS\n\n";
static const char httpstr[] = "HTTP Requests";
static const char httpmonthlyhdr[] = "        TOTAL REQUESTS%-29.29sPBBS REQUESTS\n\n";
static const char httpyearlyhdr[] = "   TOTAL%-19.19sPBBS\n\n";


static struct cmds STATShttpcmds[] = {
	{ "clear",	doSTATclear_http,	0,	0,	NULLCHAR },
	{ "daily",	STATdaily_http,		0,	0,	NULLCHAR },
	{ "general",	STATgeneral_http,	0, 	0,	NULLCHAR },
	{ "monthly",	STATmonthly_http,	0, 	0,	NULLCHAR },
	{ "weekly",	STATweekly_http,	0, 	0,	NULLCHAR },
	{ "yearly",	STATyearly_http,	0, 	0,	NULLCHAR },
	{ NULLCHAR,	NULL,			0,	0,	NULLCHAR }
};



int
doSTAThttp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	return subcmd(STATShttpcmds,argc,argv,p);
}



int
doSTATclear_http (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	if(Curproc->input != Command->input)
		tputs (STAT_cannotclear);
	else	{
		memset (&httpstats, 0, sizeof (struct http_stats));
		httpstats.days = 1;
		httpstats.start = time((time_t *)0);
		savestats_http();
		log (-1, "Clearing HTTP stats");
	}
	return 0;
}



int
STATgeneral_http (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
char buf1[26], buf2[26], buf3[36];
int temp, l;
int highest[2], second[2];

	tprintf ("\n%26.26s: %-26.26s%-24.24s\n", "USAGE", "Total Requests", "PBBS Requests");
	sprintf (buf1, "%ld", httpstats.connects[0]);
	sprintf (buf2, "%ld", httpstats.connects[1]);
	sprintf (buf3, "Requests since %6.6s", &(ctime(&httpstats.start))[4]);
	tprintf ("  %24.24s: %-26.26s%-24.24s\n", buf3, buf1, buf2);
	sprintf (buf1, "%ld", httpstats.dailyconnects[0]);
	sprintf (buf2, "%ld", httpstats.dailyconnects[1]);
	tprintf ("  %24.24s: %-26.26s%-24.24s\n", "Requests since midnight",
		buf1, buf2);
	temp = 0;
	sprintf (buf1, "%d", (httpstats.days > 1) ? (int)((httpstats.connects[0] - httpstats.dailyconnects[0] + (httpstats.days - 2)) / (httpstats.days - 1)) : (int)httpstats.connects[0]);
	sprintf (buf2, "%d", (httpstats.days > 1) ? (int)((httpstats.connects[1] - httpstats.dailyconnects[1] + (httpstats.days - 2)) / (httpstats.days - 1)) : (int)httpstats.connects[1]);
	tprintf ("  %24.24s: %-26.26s%-24.24s\n", "Average requests per day",
		buf1, buf2);
	highest[0] = highest[1] = -1;
	second[0] = second[1] = -1;
	for (temp = 0; temp < 24; temp++)
		for (l = 0; l < 2; l++)	{
			if (highest[l] == -1 || httpstats.hourly[temp][l] > httpstats.hourly[highest[l]][l])	{
				second[l] = highest[l];
				highest[l] = temp;
			} else if (second[l] == -1 || httpstats.hourly[temp][l] > httpstats.hourly[second[l]][l])
				second[l] = temp;
		}
	sprintf (buf1, "At %02d and %02d o'clock", highest[0], second[0]);
	sprintf (buf2, "At %02d and %02d o'clock", highest[1], second[1]);
	tprintf ("%26.26s: %-26.26s%-24.24s\n\n", "Rush hours", buf1, buf2);
	return 0;
}



int
STATdaily_http (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	tprintf (dailyhdr, httpstr);
	tprintf (httpdailyhdr, STAT_emptystr);
	doGraph (24, httpstats.hourly);
	tputs (STAT_dailytrailer);
	return 0;
}



int
STATweekly_http (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	tprintf (weeklyhdr, httpstr);
	tprintf (httpweeklyhdr, STAT_emptystr);
	doGraph (7, httpstats.daily);
	tputs (STAT_weeklytrailer);
	return 0;
}



int
STATmonthly_http (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	tprintf (monthlyhdr, httpstr);
	tprintf (httpmonthlyhdr, STAT_emptystr);
	doGraph (31, httpstats.monthly);
	tputs (STAT_monthlytrailer);
	return 0;
}



int
STATyearly_http (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	tprintf (yearlyhdr, httpstr);
	tprintf (httpyearlyhdr, STAT_emptystr);
	doGraph (12, httpstats.yearly);
	tputs (STAT_yearlytrailer);
	return 0;
}



void
STATS_addhttp (int which)
{
	if (which < 0 || which > 1)
		return;
	httpstats.connects[which]++;
	httpstats.dailyconnects[which]++;
	httpstats.hour[which]++;
	httpstats.day[which]++;
	httpstats.month[which]++;
}


void
loadstats_http (void)
{
FILE *fp;
char buffer[256];

	sprintf (buffer, "%s/http.dat", STATSDir);
	fp = fopen (buffer, "r");
	if (fp != NULLFILE)	{
		(void) fread (&httpstats, sizeof (struct http_stats), 1, fp);
		(void) fclose (fp);
	}
}



void
savestats_http (void)
{
FILE *fp;
char buffer[256];

	sprintf (buffer, "%s/http.dat", STATSDir);
	fp = fopen (buffer, "w");
	if (fp != NULLFILE)	{
		fwrite (&httpstats, sizeof (struct http_stats), 1, fp);
		(void) fclose (fp);
	} else
		log (-1, "Can't open stats file '%s/http.dat'", STATSDir);
}



void
newhour_http (int hour)
{
	httpstats.hourly[hour][0] = httpstats.hour[0];
	httpstats.hourly[hour][1] = httpstats.hour[1];
	httpstats.hour[0] = httpstats.hour[1] = 0;
}



void
newday_http (int day)
{
	httpstats.daily[day][0] = httpstats.day[0];
	httpstats.daily[day][1] = httpstats.day[1];
}



void
endmonthclear_http (int day, int month)
{
int k;
FILE *fp;

	/* clear out non-existent days of last month */
	for (k = day; k < 31; k++)
		httpstats.monthly[k][0] = httpstats.monthly[k][1] = 0L;
	httpstats.yearly[month][0] = httpstats.month[0];
	httpstats.yearly[month][1] = httpstats.month[1];
	fp = tmpfile();
	if (fp)	{
		fprintf (fp, "Monthly HTTP Stats for the month of %s: %s\n\n", Months[month], Hostname);
		fprintf (fp, "Total Requests: %ld\n", httpstats.month[0]);
		fprintf (fp, "PBBS Requests: %ld\n",  httpstats.month[1]);
		rewind (fp);
		(void) rdaemon (fp, NULLCHAR, NULLCHAR, "sysop", "Monthly HTTP Stats", 'P', 0);
		(void) fclose (fp);
	}
	httpstats.month[0] = httpstats.month[1] = 0;
}



void
endday_http (int day)
{
	httpstats.monthly[day][0] = httpstats.day[0];
	httpstats.monthly[day][1] = httpstats.day[1];
	httpstats.day[0] = httpstats.day[1] = 0;
	httpstats.days++;
	httpstats.dailyconnects[0] = httpstats.dailyconnects[1] = 0;
}



void
eachcycle_http (time_t now)
{
	httpstats.last = now;
}



void
init_http (time_t now)
{
	httpstats.days = 1;
	httpstats.start = now;
}


#endif /* STATS_HTTP */
