#ifndef _ASY_H
#define _ASY_H

#ifndef _GLOBAL_H
#include "global.h"
#endif

#ifndef _MBUF_H
#include "mbuf.h"
#endif

#ifndef _IFACE_H
#include "iface.h"
#endif

#define _ASY_MAX 5               /* Five asynch ports allowed on the PC */
extern int ASY_MAX;

#define SLIP_MODE       0
#define AX25_MODE       1
#define NRS_MODE        2
#define UNKNOWN_MODE    3
#define PPP_MODE        4

/* In 8250.c: */
int asy_init (int dev,struct iface *ifp,char *arg1,char *arg2,
    int16 bufsize,int trigchar,char monitor,long speed,int force,int triglevel, int polled);
int32 asy_ioctl (struct iface *ifp,int cmd,int set,int32 val);
int asy_speed (int dev,long bps);
int asy_send (int dev,struct mbuf *bp);

int asy_stop (struct iface *ifp);
int get_asy (int dev);

#ifdef TIPMAIL
struct suspended {
	struct iface *ifp;
	unsigned timeout;
	char modem;
};
extern struct suspended *Tipsuspended;
#endif

#endif  /* _ASY_H */
