#include "global.h"
#include "netuser.h"
#include "ax25.h"
#include "cmdparse.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: warnings.c,v 1.5 1996/09/04 01:34:13 root Exp $";
#endif


int Warnings = 1;

int dowarnings (int argc,char *argv[],void *p);

static char warnstr[] = "\n*** %s not set ***";

int
dowarnings(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
int didone = 0;

	if (!argc || (argc > 1 && argv[1][0] == '?'))	{
		/* First check for a valid hostname */
		if (!Hostname)	{
			tprintf (warnstr, "Hostname");
			didone++;
		}

		/* Then check for a valid IP address */
		if (!Ip_addr)	{
			tprintf (warnstr, "IP Address");
			didone++;
		}

#ifdef AX25
		/* Then check for a valid ax25 mycall */
		if (!memcmp (Mycall, NOCALL, AXALEN))	{
			tprintf (warnstr, "AX25 Mycall");
			didone++;
		}
#endif

		/* Now look for a default IP route */
		if (!R_default.iface)	{
			tprintf (warnstr, "IP Default Route");
			didone++;
		}

		if (didone)
			tputs ("\n*** The above omissions WILL cause you problems ***\n*** You've been warned! ***\007\n\n");

		return 0;
	} else
		return setbool(&Warnings,"Display warnings after autoexec.nos",argc,argv);
}

