/* Miscellaneous interger and IP address format conversion subroutines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include "global.h"
#include "ctype.h"
#include "netuser.h"
#include "domain.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: netuser.c,v 1.12 1997/08/19 01:19:22 root Exp $";
#endif


int Net_error;

extern const char *tcp_port_name (int portnum);
long btol (char *s);


/* Convert Internet address in ascii dotted-decimal format (44.0.0.1) to
 * binary IP address
 */
uint32
aton (s)
register const char *s;
{
uint32 n;
register int i;

	n = 0;
	if (s == NULLCHAR)
		return 0;
	for (i = 24; i >= 0; i -= 8) {
		/* Skip any leading stuff (e.g., spaces, '[') */
		while (*s != '\0' && !isdigit (*s))
			s++;
		if (*s == '\0')
			break;
		n |= (uint32) atoi (s) << i;
		if ((s = strchr (s, '.')) == NULLCHAR)
			break;
		s++;
	}
	return n;
}


/* Convert an internet address (in host byte order) to a dotted decimal ascii
 * string, e.g., 255.255.255.255\0
 */
char *
inet_ntoa (a)
uint32 a;
{
static char buf[25];
char *name;

	buf[0] = '\0';
	if (DTranslate && (name = resolve_a (a, !DVerbose)) != NULLCHAR) {
		strncpy (buf, name, 24);
		buf[24] = '\0';
		free (name);
	} else	/*lint -save -e704 */
		sprintf (buf, "%u.%u.%u.%u", hibyte (hiword (a)), lobyte (hiword (a)),
			 hibyte (loword (a)), lobyte (loword (a)));
		/*lint -restore */
	return buf;
}


/* Convert an internet address (in host byte order) to a unformated string
 */
char *
inet_ntobos (a)
uint32 a;
{
static unsigned char buf[5];

	/*lint -save -e704 */
	buf[0] = hibyte (hiword (a));
	buf[1] = lobyte (hiword (a));
	buf[2] = hibyte (loword (a));
	buf[3] = lobyte (loword (a));
	/*lint -restore */
	buf[4] = '\0';

	return (char *)buf;
}


/* Convert hex-ascii string to long integer */
long
htol (s)
char *s;
{
long ret;
char c;

	ret = 0;
	while ((c = *s++) != '\0') {
		c &= 0x7f;
		if (c == 'x')
			continue;	/* Ignore 'x', e.g., '0x' prefixes */
		if (c >= '0' && c <= '9')
			ret = ret * 16 + (c - '0');
		else if (c >= 'a' && c <= 'f')
			ret = ret * 16 + (10 + c - 'a');
		else if (c >= 'A' && c <= 'F')
			ret = ret * 16 + (10 + c - 'A');
		else
			break;
	}
	return ret;
}



/* Convert binary string to long integer */
long
btol (s)
char *s;
{
long ret;
char c;

	ret = 0;
	while ((c = *s++) != '\0') {
		c &= 0x7f;
		if (c == '%')
			continue;	/* Ignore '%' prefixes */
		if (c == '0' || c == '1')
			ret = ret * 2 + (c - '0');
		else
			break;
	}
	return ret;
}


char *
pinet (s)
struct socket *s;
{
static char buf[80];
char port[11];
const char *ptr;

	ptr = tcp_port_name (s->port);
	if (!strcmp (ptr, "0") && s->port)
		sprintf (port, "%u", s->port);
	else
		sprintf (port, ptr);

	sprintf (buf, "%s:%s", inet_ntoa (s->address), port);
	return buf;
}
