#define MAX_URL_LINKS		1500	/* maximum links on a URL */
#define MAX_URL_LINES		2500	/* maximum lines in a URL */
#define LINKBACKS		40	/* number of linkback entries queued */

struct formlink	{
	int		type;
	int		line;
	int		col;

	short		bool;
	char		*data;

	char		*name;
	char		*value;
	char		*align;
	int		size;
	int		maxlength;
	struct formlink	*next;
};
#define NULLFLINK ((struct formlink *)0)

struct form	{
	char		*action;
	char		*enctype;
	int		method;
	struct formlink	*flink;
	struct formlink	*lastlink;	/* the last form component, if applicable */
};
#define NULLFORM ((struct form *)0)

	
struct url_links	{
	int		startline;	/* display line link starts on */
	int		startcolumn;	/* display column link starts on */
	int		endline;	/* display line link ends on */
	int		endcolumn;	/* display column link ends on */
	char		*url;		/* the actual URL this links to */
	struct formlink	*flink;		/* the form component, if applicable */
};


struct realms	{
	char		*host;
	char		*realm;
	char		*auth;
	struct realms	*next;
};
#define NULLREALMS ((struct realms *)0)


struct browser	{
	char	*current_url;		/* current URL being rendered */
	char	*title;			/* current URL's title */
	char	*host;			/* hostname of this URL */
	char	*redirect;		/* redirected URL */
	char	*auth;			/* auth header - if needed */
	char	*marquee;		/* marquee tag string - if one found */
	int	marquee_position;	/* position within marquee string */
	int	status;			/* status of URL request */
	int	consume;		/* non-supported tag - discard data within */
	int	port;			/* port used for this URL */
	int	savingonly;		/* saving URL, only, not displaying */
	int	longestline;		/* longest line in display_lines */
	int	columnoffset;		/* column to begin output from */
	int	lines_in_url;		/* total number of displayable lines
					   in pre-parsed data array */
	int	current_top_line;	/* display line currently at top */
	int	current_screen_lines;	/* number of lines we can display on screen */
	char	*display_lines[MAX_URL_LINES];
					/* pre-parsed version of the URL's data */
	int	links_per_line[MAX_URL_LINES];
					/* number of links that can be found on this data line */
	struct url_links
		links[MAX_URL_LINKS];	/* the various links in this URL */
	int	link_count;		/* total number of links in this URL */
	int	current_link;		/* current highlighted link */
	char	*linkback[LINKBACKS];	/* for backwards/forwards traversing links */
	int	current_linkback;	/* for backwards/forwards traversing links */
	int	total_in_linkback;	/* highwater mark for queue */
	int	has_an_index;		/* is there an isindex on the page? */
	struct realms
		*myrealms;		/* the realms know during this session */
	struct form
		*form;			/* the active form information */
};
#define NULLBROWSER ((struct browser *)0)


struct options	{
	char		*name;
	char		*value;
	struct options	*next;
};
#define NULLOPTIONS ((struct options *)0)

struct tag	{
	char		*name;
	int		endtag;
	struct options	*opts;
};
#define NULLTAG ((struct tag *)0)



#define MAX_TABLE_COLS		50
#define MAX_TABLE_ROWS		150

#define TABLE_ALIGN_LEFT	0
#define TABLE_ALIGN_RIGHT	1
#define TABLE_ALIGN_CENTER	2

struct table_column	{
	int			colspan;
	int			rowspan;
	int			align;
	char			*value;
	char			*url;
};

struct table_row	{
	int			cols_in_row;
	int			align;
	struct table_column	cols[MAX_TABLE_COLS];
};

struct form_table	{
	char		 	*caption;
	int			numcols;
	int			numrows;
	int			colsize[MAX_TABLE_COLS];
	struct table_row	rows[MAX_TABLE_ROWS];
};
#define NULLTABLE ((struct form_table *)0)



struct tag *parse_tag (FILE *fp);
void delete_tag (struct tag *tag);
char *find_option (struct tag *tag, const char *str, int *found);


