head	1.13;
access;
symbols;
locks;
comment	@ * @;


1.13
date	93.05.06.10.11.35;	author karn;	state Exp;
branches;
next	1.12;

1.12
date	93.01.02.08.22.37;	author karn;	state Exp;
branches;
next	1.11;

1.11
date	92.12.03.08.17.03;	author karn;	state Exp;
branches;
next	1.10;

1.10
date	92.09.09.01.18.27;	author karn;	state Exp;
branches;
next	1.9;

1.9
date	92.06.21.08.42.26;	author karn;	state Exp;
branches;
next	1.8;

1.8
date	92.05.05.10.34.26;	author karn;	state Exp;
branches;
next	1.7;

1.7
date	92.05.01.08.24.24;	author karn;	state Exp;
branches;
next	1.6;

1.6
date	92.04.29.10.29.24;	author karn;	state Exp;
branches;
next	1.5;

1.5
date	91.09.18.14.13.56;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	91.03.28.09.21.56;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	91.03.10.06.55.42;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.02.02.22.39.00;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	91.01.27.12.33.00;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.13
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@/* Packet tracing - top level and generic routines, including hex/ascii
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include "global.h"
#include <stdarg.h>
#include "mbuf.h"
#include "iface.h"
#include "pktdrvr.h"
#include "commands.h"
#include "trace.h"
#include "session.h"

static void ascii_dump(FILE *fp,struct mbuf **bpp);
static void ctohex(char *buf,uint16 c);
static void fmtline(FILE *fp,uint16 addr,char *buf,uint16 len);
void hex_dump(FILE *fp,struct mbuf **bpp);
static void showtrace(struct iface *ifp);

/* Redefined here so that programs calling dump in the library won't pull
 * in the rest of the package
 */
static char nospace[] = "No space!!\n";

struct tracecmd Tracecmd[] = {
	"input",	IF_TRACE_IN,	IF_TRACE_IN,
	"-input",	0,		IF_TRACE_IN,
	"output",	IF_TRACE_OUT,	IF_TRACE_OUT,
	"-output",	0,		IF_TRACE_OUT,
	"broadcast",	0,		IF_TRACE_NOBC,
	"-broadcast",	IF_TRACE_NOBC,	IF_TRACE_NOBC,
	"raw",		IF_TRACE_RAW,	IF_TRACE_RAW,
	"-raw",		0,		IF_TRACE_RAW,
	"ascii",	IF_TRACE_ASCII,	IF_TRACE_ASCII|IF_TRACE_HEX,
	"-ascii",	0,		IF_TRACE_ASCII|IF_TRACE_HEX,
	"hex",		IF_TRACE_HEX,	IF_TRACE_ASCII|IF_TRACE_HEX,
	"-hex",		IF_TRACE_ASCII,	IF_TRACE_ASCII|IF_TRACE_HEX,
	"off",		0,		0xffff,
	NULLCHAR,	0,		0
};


void
dump(ifp,direction,bp)
register struct iface *ifp;
int direction;
struct mbuf *bp;
{
	struct mbuf *tbp;
	uint16 size;
	time_t timer;
	char *cp;
	struct iftype *ift;
	FILE *fp;

	if(ifp == NULL || (ifp->trace & direction) == 0
	 || (fp = ifp->trfp) == NULLFILE)
		return;	/* Nothing to trace */

	ift = ifp->iftype;
	switch(direction){
	case IF_TRACE_IN:
		if((ifp->trace & IF_TRACE_NOBC)
		 && ift != NULLIFT
		 && (ift->addrtest != NULLFP)
		 && (*ift->addrtest)(ifp,bp) == 0)
			return;		/* broadcasts are suppressed */
		time(&timer);
		cp = ctime(&timer);
		cp[24] = '\0';
		fprintf(fp,"\n%s - %s recv:\n",cp,ifp->name);
		break;
	case IF_TRACE_OUT:
		time(&timer);
		cp = ctime(&timer);
		cp[24] = '\0';
		fprintf(fp,"\n%s - %s sent:\n",cp,ifp->name);
		break;
	}
	if(bp == NULLBUF || (size = len_p(bp)) == 0){
		fprintf(fp,"empty packet!!\n");
		return;
	}
	dup_p(&tbp,bp,0,size);
	if(tbp == NULLBUF){
		fprintf(fp,nospace);
		return;
	}
	if(ift != NULLIFT && ift->trace != NULLVFP)
		(*ift->trace)(fp,&tbp,1);
	if(ifp->trace & IF_TRACE_ASCII){
		/* Dump only data portion of packet in ascii */
		ascii_dump(fp,&tbp);
	} else if(ifp->trace & IF_TRACE_HEX){
		/* Dump entire packet in hex/ascii */
		free_p(tbp);
		dup_p(&tbp,bp,0,len_p(bp));
		if(tbp != NULLBUF)
			hex_dump(fp,&tbp);
		else
			fprintf(fp,nospace);
	}
	free_p(tbp);
}

/* Dump packet bytes, no interpretation */
void
raw_dump(ifp,direction,bp)
struct iface *ifp;
int direction;
struct mbuf *bp;
{
	struct mbuf *tbp;
	FILE *fp;

	if((fp = ifp->trfp) == NULLFILE)
		return;
	fprintf(fp,"\n******* raw packet dump (%s)\n",
	 ((direction & IF_TRACE_OUT) ? "send" : "recv"));
	dup_p(&tbp,bp,0,len_p(bp));
	if(tbp != NULLBUF)
		hex_dump(fp,&tbp);
	else
		fprintf(fp,nospace);
	fprintf(fp,"*******\n");
	free_p(tbp);
}

/* Dump an mbuf in hex */
void
hex_dump(fp,bpp)
FILE *fp;
register struct mbuf **bpp;
{
	uint16 n;
	uint16 address;
	char buf[16];

	if(bpp == NULLBUFP || *bpp == NULLBUF || fp == NULLFILE)
		return;

	address = 0;
	while((n = pullup(bpp,buf,sizeof(buf))) != 0){
		fmtline(fp,address,buf,n);
		address += n;
	}
}
/* Dump an mbuf in ascii */
static void
ascii_dump(fp,bpp)
FILE *fp;
register struct mbuf **bpp;
{
	int c;
	register uint16 tot;

	if(bpp == NULLBUFP || *bpp == NULLBUF || fp == NULLFILE)
		return;

	tot = 0;
	while((c = PULLCHAR(bpp)) != -1){
		if((tot % 64) == 0)
			fprintf(fp,"%04x  ",tot);
		putc(isprint(uchar(c)) ? c : '.',fp);
		if((++tot % 64) == 0)
			fprintf(fp,"\n");
	}
	if((tot % 64) != 0)
		fprintf(fp,"\n");
}
/* Print a buffer up to 16 bytes long in formatted hex with ascii
 * translation, e.g.,
 * 0000: 30 31 32 33 34 35 36 37 38 39 3a 3b 3c 3d 3e 3f  0123456789:;<=>?
 */
static void
fmtline(fp,addr,buf,len)
FILE *fp;
uint16 addr;
char *buf;
uint16 len;
{
	char line[80];
	register char *aptr,*cptr;
	register char c;

	memset(line,' ',sizeof(line));
	ctohex(line,(uint16)hibyte(addr));
	ctohex(line+2,(uint16)lobyte(addr));
	aptr = &line[6];
	cptr = &line[55];
	while(len-- != 0){
		c = *buf++;
		ctohex(aptr,(uint16)uchar(c));
		aptr += 3;
		*cptr++ = isprint(uchar(c)) ? c : '.';
	}
	*cptr++ = '\n';
	fwrite(line,1,(unsigned)(cptr-line),fp);
}
/* Convert byte to two ascii-hex characters */
static void
ctohex(buf,c)
register char *buf;
register uint16 c;
{
	static char hex[] = "0123456789abcdef";

	*buf++ = hex[hinibble(c)];
	*buf = hex[lonibble(c)];
}

/* Modify or displace interface trace flags */
int
dotrace(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct iface *ifp;
	struct tracecmd *tp;
	struct session *sp;

	if(argc < 2){
		for(ifp = Ifaces; ifp != NULLIF; ifp = ifp->next)
			showtrace(ifp);
		return 0;
	}
	if((ifp = if_lookup(argv[1])) == NULLIF){
		printf("Interface %s unknown\n",argv[1]);
		return 1;
	}
	if(argc == 2){
		showtrace(ifp);
		return 0;
	}
	/* MODIFY THIS TO HANDLE MULTIPLE OPTIONS */
	if(argc >= 3){
		for(tp = Tracecmd;tp->name != NULLCHAR;tp++)
			if(strncmp(tp->name,argv[2],strlen(argv[2])) == 0)
				break;
		if(tp->name != NULLCHAR)
			ifp->trace = (ifp->trace & ~tp->mask) | tp->val;
		else
			ifp->trace = htoi(argv[2]);
	}
	if(ifp->trfp != NULLFILE){
		/* Close existing trace file */
		fclose(ifp->trfp);
		ifp->trfp = NULLFILE;
	}
	if(argc >= 4){
		if((ifp->trfp = fopen(argv[3],APPEND_TEXT)) == NULLFILE){
			printf("Can't write to %s\n",argv[3]);
		}
	} else if(ifp->trace != 0){
		/* Create trace session */
		sp = newsession(Cmdline,ITRACE,1);
		sp->cb.p = NULL;
		sp->proc = sp->proc1 = sp->proc2 = NULLPROC;
		ifp->trfp = sp->output;
		showtrace(ifp);
		getchar();	/* Wait for the user to hit something */
		ifp->trace = 0;
		ifp->trfp = NULLFILE;
		freesession(sp);
	}
	return 0;
}
/* Display the trace flags for a particular interface */
static void
showtrace(ifp)
register struct iface *ifp;
{
	char *cp;

	if(ifp == NULLIF)
		return;
	printf("%s:",ifp->name);
	if(ifp->trace & (IF_TRACE_IN | IF_TRACE_OUT | IF_TRACE_RAW)){
		if(ifp->trace & IF_TRACE_IN)
			printf(" input");
		if(ifp->trace & IF_TRACE_OUT)
			printf(" output");

		if(ifp->trace & IF_TRACE_NOBC)
			printf(" - no broadcasts");

		if(ifp->trace & IF_TRACE_HEX)
			printf(" (Hex/ASCII dump)");
		else if(ifp->trace & IF_TRACE_ASCII)
			printf(" (ASCII dump)");
		else
			printf(" (headers only)");

		if(ifp->trace & IF_TRACE_RAW)
			printf(" Raw output");

		if(ifp->trfp != NULLFILE && (cp = fpname(ifp->trfp)) != NULLCHAR)
			printf(" trace file: %s",cp);
		printf("\n");
	} else
		printf(" tracing off\n");
}

/* shut down all trace files */
void
shuttrace()
{
	struct iface *ifp;

	for(ifp = Ifaces; ifp != NULLIF; ifp = ifp->next){
		fclose(ifp->trfp);
		ifp->trfp = NULLFILE;
	}
}

/* Log messages of the form
 * Tue Jan 31 00:00:00 1987 44.64.0.7:1003 open FTP
 */
void
trace_log(struct iface *ifp,char *fmt, ...)
{
	va_list ap;
	char *cp;
	long t;
	FILE *fp;

	if((fp = ifp->trfp) == NULLFILE)
		return;
	time(&t);
	cp = ctime(&t);
	rip(cp);
	fprintf(fp,"%s - ",cp);
	va_start(ap,fmt);
	vfprintf(fp,fmt,ap);
	va_end(ap);
	fprintf(fp,"\n");
}
int
tprintf(struct iface *ifp,char *fmt, ...)
{
	va_list ap;
	int ret = 0;

	if(ifp->trfp == NULLFILE)
		return -1; 
	va_start(ap,fmt);
	ret = vfprintf(ifp->trfp,fmt,ap);
	va_end(ap);
	return ret;
}
@


1.12
log
@Call newsession with Cmdline
@
text
@a7 1
#ifdef	ANSIPROTO
a8 1
#endif
d16 5
a20 5
static void ascii_dump __ARGS((FILE *fp,struct mbuf **bpp));
static void ctohex __ARGS((char *buf,int16 c));
static void fmtline __ARGS((FILE *fp,int16 addr,char *buf,int16 len));
void hex_dump __ARGS((FILE *fp,struct mbuf **bpp));
static void showtrace __ARGS((struct iface *ifp));
d52 1
a52 1
	int16 size;
d137 2
a138 2
	int16 n;
	int16 address;
d157 1
a157 1
	register int16 tot;
d180 1
a180 1
int16 addr;
d182 1
a182 1
int16 len;
d189 2
a190 2
	ctohex(line,(int16)hibyte(addr));
	ctohex(line+2,(int16)lobyte(addr));
d195 1
a195 1
		ctohex(aptr,(int16)uchar(c));
d206 1
a206 1
register int16 c;
a321 1
#if	defined(ANSIPROTO)
a353 24
#else
/*VARARGS2*/
void
trace_log(ifp,fmt,arg1,arg2,arg3,arg4,arg5)
struct iface *ifp;
char *fmt;
int arg1,arg2,arg3,arg4,arg5;
{
	char *cp;
	long t;

	if(ifp->trfp == NULLFILE)
		return;

	time(&t);
	cp = ctime(&t);
	rip(cp);
	fprintf(ifp->trfp,"%s",cp);

	fprintf(ifp->trfp," - ");
	fprintf(ifp->trfp,fmt,arg1,arg2,arg3,arg4,arg5);
	fprintf(ifp->trfp,"\n");
}
#endif
@


1.11
log
@Make hex_dump() global
@
text
@d261 1
a261 1
		sp = newsession(argv[1],ITRACE,1);
@


1.10
log
@Don't spawn a trace session if the flags are 0
@
text
@d21 1
a21 1
static void hex_dump __ARGS((FILE *fp,struct mbuf **bpp));
d134 1
a134 1
static void
@


1.9
log
@Remove parity stripping
@
text
@d259 1
a259 1
	} else {
@


1.8
log
@src0505
@
text
@a198 1
		c &= 0x7f;
@


1.7
log
@src0501
@
text
@d16 1
d58 1
d60 2
a61 1
	if(ifp == NULL || (ifp->trace & direction) == 0)
d75 1
a75 1
		fprintf(ifp->trfp,"\n%s - %s recv:\n",cp,ifp->name);
d81 1
a81 1
		fprintf(ifp->trfp,"\n%s - %s sent:\n",cp,ifp->name);
d85 1
a85 1
		fprintf(ifp->trfp,"empty packet!!\n");
a87 1

d90 1
a90 1
		fprintf(ifp->trfp,nospace);
d94 1
a94 1
		(*ift->trace)(ifp->trfp,&tbp,1);
d97 1
a97 1
		ascii_dump(ifp->trfp,&tbp);
d103 1
a103 1
			hex_dump(ifp->trfp,&tbp);
d105 1
a105 1
			fprintf(ifp->trfp,nospace);
d118 1
d120 4
a123 3
	/* Dump entire packet in hex/ascii */
	fprintf(ifp->trfp,"\n******* raw packet dump (%s %s)\n",
		((direction & IF_TRACE_OUT) ? "send" : "recv"),ifp->name);
d126 1
a126 1
		hex_dump(ifp->trfp,&tbp);
d128 2
a129 2
		fprintf(ifp->trfp,nospace);
	fprintf(ifp->trfp,"*******\n");
a130 1
	return;
d143 1
a143 1
	if(bpp == NULLBUFP || *bpp == NULLBUF)
d161 1
a161 1
	if(bpp == NULLBUFP || *bpp == NULLBUF)
d226 1
d251 2
a252 2
	/* Always default to stdout unless trace file is given */
	if(ifp->trfp != NULLFILE && ifp->trfp != stdout)
d254 2
a255 5
	ifp->trfp = stdout;
	if(ifp->trfile != NULLCHAR)
		free(ifp->trfile);
	ifp->trfile = NULLCHAR;

a258 3
			ifp->trfp = stdout;
		} else {
			ifp->trfile = strdup(argv[3]);
d260 11
a271 1
	showtrace(ifp);
d279 2
d303 2
a304 2
		if(ifp->trfile != NULLCHAR)
			printf(" trace file: %s",ifp->trfile);
d317 1
a317 5
		if(ifp->trfp != NULLFILE && ifp->trfp != stdout)
			fclose(ifp->trfp);
		if(ifp->trfile != NULLCHAR)
			free(ifp->trfile);
		ifp->trfile = NULLCHAR;
d332 1
d334 1
a334 1
	if(ifp->trfp == NULLFILE)
a335 1

d339 11
a349 1
	fprintf(ifp->trfp,"%s",cp);
d351 2
a352 1
	fprintf(ifp->trfp," - ");
d354 1
a354 1
	vfprintf(ifp->trfp,fmt,ap);
d356 1
a356 1
	fprintf(ifp->trfp,"\n");
a381 1

@


1.6
log
@src0429a
@
text
@d230 1
a230 1
		tprintf("Interface %s unknown\n",argv[1]);
d257 1
a257 1
			tprintf("Can't write to %s\n",argv[3]);
d273 1
a273 1
	tprintf("%s:",ifp->name);
d276 1
a276 1
			tprintf(" input");
d278 1
a278 1
			tprintf(" output");
d281 1
a281 1
			tprintf(" - no broadcasts");
d284 1
a284 1
			tprintf(" (Hex/ASCII dump)");
d286 1
a286 1
			tprintf(" (ASCII dump)");
d288 1
a288 1
			tprintf(" (headers only)");
d291 1
a291 1
			tprintf(" Raw output");
d294 2
a295 2
			tprintf(" trace file: %s",ifp->trfile);
		tprintf("\n");
d297 1
a297 1
		tprintf(" tracing off\n");
@


1.5
log
@src0922
@
text
@d47 1
a47 1
dump(ifp,direction,type,bp)
a49 1
unsigned type;
a52 1
	void (*func) __ARGS((FILE *,struct mbuf **,int));
d56 1
d61 1
d65 3
a67 2
		 && (Tracef[type].addrtest != NULLFP)
		 && (*Tracef[type].addrtest)(ifp,bp) == 0)
a85 5
	if(type < NCLASS)
		func = Tracef[type].tracef;
	else
		func = NULLVFP;

d91 2
a92 2
	if(func != NULLVFP)
		(*func)(ifp->trfp,&tbp,1);
@


1.4
log
@src0420
@
text
@d8 3
d47 2
a48 2
dump(iface,direction,type,bp)
register struct iface *iface;
d59 1
a59 1
	if(iface == NULL || (iface->trace & direction) == 0)
d64 1
a64 1
		if((iface->trace & IF_TRACE_NOBC)
d66 1
a66 1
		 && (*Tracef[type].addrtest)(iface,bp) == 0)
d71 1
a71 1
		fprintf(iface->trfp,"\n%s - %s recv:\n",cp,iface->name);
d77 1
a77 1
		fprintf(iface->trfp,"\n%s - %s sent:\n",cp,iface->name);
d81 1
a81 1
		fprintf(iface->trfp,"empty packet!!\n");
d92 1
a92 1
		fprintf(iface->trfp,nospace);
d96 2
a97 2
		(*func)(iface->trfp,&tbp,1);
	if(iface->trace & IF_TRACE_ASCII){
d99 2
a100 2
		ascii_dump(iface->trfp,&tbp);
	} else if(iface->trace & IF_TRACE_HEX){
d105 1
a105 1
			hex_dump(iface->trfp,&tbp);
d107 1
a107 1
			fprintf(iface->trfp,nospace);
d114 2
a115 2
raw_dump(iface,direction,bp)
struct iface *iface;
d122 2
a123 2
	fprintf(iface->trfp,"\n******* raw packet dump (%s %s)\n",
		((direction & IF_TRACE_OUT) ? "send" : "recv"),iface->name);
d126 1
a126 1
		hex_dump(iface->trfp,&tbp);
d128 2
a129 2
		fprintf(iface->trfp,nospace);
	fprintf(iface->trfp,"*******\n");
d319 50
@


1.3
log
@src0318
@
text
@d25 18
d223 1
d238 10
a247 3
	if(argc >= 3)
		ifp->trace = htoi(argv[2]);

d302 2
a303 1
void shuttrace()
@


1.2
log
@src0202
@
text
@a9 1
#include "trace.h"
d12 1
d50 1
a50 1
		fprintf(iface->trfp,"%s - %s recv:\n",cp,iface->name);
d56 1
a56 1
		fprintf(iface->trfp,"%s - %s sent:\n",cp,iface->name);
d101 1
a101 1
	fprintf(iface->trfp,"******* raw packet dump (%s %s)\n",
d215 4
d280 8
a287 8
        for(ifp = Ifaces; ifp != NULLIF; ifp = ifp->next){
                if(ifp->trfp != NULLFILE && ifp->trfp != stdout)
                        fclose(ifp->trfp);
                if(ifp->trfile != NULLCHAR)
                        free(ifp->trfile);
                ifp->trfile = NULLCHAR;
                ifp->trfp = NULLFILE;
        }
@


1.1
log
@Initial revision
@
text
@d50 1
a50 1
		fprintf(iface->trfp,"%s  - %s recv:\n",cp,iface->name);
@
