head	1.5;
access;
symbols;
locks;
comment	@ * @;


1.5
date	93.05.06.10.11.30;	author karn;	state Exp;
branches;
next	1.4;

1.4
date	93.03.15.05.09.13;	author karn;	state Exp;
branches;
next	1.3;

1.3
date	92.08.20.15.44.46;	author karn;	state Exp;
branches;
next	1.2;

1.2
date	91.04.19.09.28.28;	author karn;	state Exp;
branches;
next	1.1;

1.1
date	90.12.10.13.38.56;	author karn;	state Exp;
branches;
next	;


desc
@src0201
@


1.5
log
@Change int16 to uint16
Remove __ARGS(()) construct
@
text
@#ifndef	_TIMER_H
#define	_TIMER_H

#ifndef	_GLOBAL_H
#include "global.h"
#endif

/* Software timers
 * There is one of these structures for each simulated timer.
 * Whenever the timer is running, it is on a linked list
 * pointed to by "Timers". The list is sorted in ascending order of
 * expiration, with the first timer to expire at the head. This
 * allows the timer process to avoid having to scan the entire list
 * on every clock tick; once it finds an unexpired timer, it can
 * stop searching.
 *
 * Stopping a timer or letting it expire causes it to be removed
 * from the list. Starting a timer puts it on the list at the right
 * place.
 */
struct timer {
	struct timer *next;	/* Linked-list pointer */
	int32 duration;		/* Duration of timer, in ticks */
	int32 expiration;	/* Clock time at expiration */
	void (*func)(void *);	/* Function to call at expiration */
	void *arg;		/* Arg to pass function */
	char state;		/* Timer state */
#define	TIMER_STOP	0
#define	TIMER_RUN	1
#define	TIMER_EXPIRE	2
};
#define	NULLTIMER	(struct timer *)0
#define	MAX_TIME	(int32)4294967295	/* Max long integer */
#ifndef	MSPTICK
#define	MSPTICK		55		/* Milliseconds per tick */
#endif
#ifndef	EALARM
#define	EALARM		106
#endif
/* Useful user macros that hide the timer structure internals */
#define	dur_timer(t)	((t)->duration*MSPTICK)
#define	run_timer(t)	((t)->state == TIMER_RUN)

extern int Tick;
extern void (*Cfunc[])();	/* List of clock tick functions */

/* In timer.c: */
void alarm(int32 ms);
int pause(int32 ms);
int32 read_timer(struct timer *t);
void set_timer(struct timer *t,int32 x);
void start_timer(struct timer *t);
void stop_timer(struct timer *timer);
char *tformat(int32 t);

/* In hardware.c: */
int32 msclock(void);
int32 secclock(void);

#endif	/* _TIMER_H */
@


1.4
log
@Change def of EALARM to match def in socket.h
@
text
@d25 1
a25 1
	void (*func) __ARGS((void *));	/* Function to call at expiration */
d48 7
a54 7
void alarm __ARGS((int32 ms));
int pause __ARGS((int32 ms));
int32 read_timer __ARGS((struct timer *t));
void set_timer __ARGS((struct timer *t,int32 x));
void start_timer __ARGS((struct timer *t));
void stop_timer __ARGS((struct timer *timer));
char *tformat __ARGS((int32 t));
d57 2
a58 2
int32 msclock __ARGS((void));
int32 secclock __ARGS((void));
@


1.3
log
@Add EALARM def so socket.h doesn't have to be included
@
text
@d38 1
a38 1
#define	EALARM	42
@


1.2
log
@src0420
@
text
@d37 3
@


1.1
log
@Initial revision
@
text
@d10 1
a10 1
 * Whenever the timer is running, it is on a doubly-linked list
d12 4
a15 4
 * expiration, with the next timer to expire at the head. Each timer's
 * count field contains only the additional INCREMENT over all preceeding
 * timers; this allows the hardware timer interrupt to decrement only the
 * first timer on the chain until it hits zero.
d19 1
a19 2
 * place. These operations have to be careful about adjusting the count
 * field of the next entry in the list.
d22 3
a24 4
	struct timer *next;	/* Doubly-linked-list pointers */
	struct timer *prev;
	int32 start;		/* Period of counter (load value) */
	int32 count;		/* Ticks to go until expiration */
d38 1
a38 1
#define	dur_timer(t)	((t)->start*MSPTICK)
a40 1
extern int32 Clock;	/* Count of ticks since start up */
d42 1
d50 1
a50 1
void stop_timer __ARGS((struct timer *t));
@
